/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScriptModel<E>
implements Disposable {
    public abstract ScriptModel<E> subModel(@Nullable TextRange var1, boolean var2);

    public abstract StatementIt<E> statements();

    public abstract ParamIt<E> parameters();

    public abstract VirtualFile getVirtualFile();

    public abstract TextRange getTextRange();

    public abstract boolean isAtPosition();

    public abstract <EE> ScriptModel<EE> rawTransform(Function<SyntaxTraverser<E>, SyntaxTraverser<EE>> var1);

    public void dispose() {
    }

    public String toString() {
        return "ScriptModel{range=" + this.getTextRange() + ", file=" + this.getVirtualFile() + "}";
    }

    public static abstract class ModelItBase<E, Self extends ModelItBase<E, Self>>
    extends JBIterator<E>
    implements ModelIt<E> {
        protected SyntaxTraverser<E> traverser;
        protected E current;

        @Override
        public long rangeOffset() {
            return 0L;
        }

        @Override
        public final String text() {
            return this.traverser.api.textOf(this.current).toString();
        }

        @Override
        public final TextRange range() {
            return this.traverser.api.rangeOf(this.current);
        }

        @Override
        public final IElementType type() {
            return this.traverser.api.typeOf(this.current);
        }

        public final JBIterable<Self> asCursor() {
            return JBIterator.cursor((JBIterator)this);
        }
    }

    public static abstract class PStorage
    implements Iterable<Object> {
        @Nullable
        public abstract Object getValue(@NotNull Object var1);

        @Nullable
        public abstract Object putValue(@NotNull Object var1, Object var2);

        @NotNull
        public static PStorage newStorage() {
            PStorage pStorage = new PStorage(){
                Map<Object, Object> map = ContainerUtil.newHashMap();

                @Override
                public Object getValue(@NotNull Object p) {
                    if (p == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/database/script/ScriptModel$PStorage$1", "getValue"));
                    }
                    return this.map.get(p);
                }

                @Override
                public Object putValue(@NotNull Object p, Object v) {
                    if (p == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/database/script/ScriptModel$PStorage$1", "putValue"));
                    }
                    return this.map.put(p, v);
                }

                @Override
                @NotNull
                public Iterator<Object> iterator() {
                    Iterator<Object> iterator = this.map.keySet().iterator();
                    if (iterator == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModel$PStorage$1", "iterator"));
                    }
                    return iterator;
                }
            };
            if (pStorage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/script/ScriptModel$PStorage", "newStorage"));
            }
            return pStorage;
        }
    }

    public static interface ParamIt<E>
    extends ModelIt<E> {
        public String displayName();

        public String name();

        public Iterable<String> description();

        public JBIterable<? extends ParamIt<E>> asCursor();
    }

    public static interface StatementIt<E>
    extends ModelIt<E> {
        public String text(PStorage var1, Condition<? super ParamIt<E>> var2);

        public Object resultType(Object var1);

        public ParamIt<E> parameters();

        public JBIterable<? extends StatementIt<E>> asCursor();
    }

    public static interface ModelIt<E>
    extends Iterator<E> {
        public String text();

        public TextRange range();

        public IElementType type();

        public long rangeOffset();

        public boolean advance();

        public E current();
    }
}

