/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.ErrorHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoaderContext {
    private final DataSource myDataSource;
    private final DatabaseFamilyId myFamilyId;
    private ErrorHandler myErrorHandler = new ErrorHandler();
    private final THashSet<Object> mySelection = new THashSet();
    private Object mySelectedElement;
    private Runnable myUpdateUiRunnable;
    private Pattern myProcedurePattern;

    public static LoaderContext loadAll(DataSource dataSource) {
        return new LoaderContext(dataSource).includeAllSchemas().includeTables().includeProcedures();
    }

    public static LoaderContext loadOne(DataSource dataSource, Object o) {
        return new LoaderContext(dataSource).include(o);
    }

    public LoaderContext(DataSource dataSource) {
        this.myDataSource = dataSource;
        this.myFamilyId = DatabaseFamilyId.forDataSource(this.myDataSource);
    }

    public DataSource getDataSource() {
        return this.myDataSource;
    }

    public DatabaseFamilyId getFamilyId() {
        return this.myFamilyId;
    }

    public Set<Object> getSelection() {
        return this.mySelection;
    }

    public LoaderContext setErrorHandler(ErrorHandler handler) {
        this.myErrorHandler = handler;
        return this;
    }

    public LoaderContext include(@Nullable DasObject cur, String newName, boolean focusInView) {
        this.include(cur);
        return this;
    }

    public LoaderContext include(@Nullable Object o) {
        if (o == null) {
            return this;
        }
        if (o instanceof DasNamespace) {
            this.includeNamespace((DasNamespace)o);
        } else {
            this.mySelection.add(o instanceof DbElement ? ((DbElement)o).getDelegate() : o);
        }
        return this;
    }

    @Deprecated
    public LoaderContext includeSchema(String catalog, String schema) {
        this.mySelection.add((Object)LoaderContext.getPattern(catalog, schema));
        return this;
    }

    public LoaderContext includeNamespace(DasNamespace namespace) {
        String pattern;
        ObjectKind namespaceKind = namespace.getKind();
        if (namespaceKind == ObjectKind.DATABASE) {
            pattern = LoaderContext.getPattern(namespace.getName(), null);
        } else if (namespaceKind == ObjectKind.SCHEMA) {
            DasObject parent = namespace.getDbParent();
            pattern = this.myFamilyId.isOracle() ? LoaderContext.getPattern(null, namespace.getName()) : (parent != null && parent.getKind() == ObjectKind.DATABASE ? LoaderContext.getPattern(parent.getName(), namespace.getName()) : (this.myFamilyId.isMysql() ? LoaderContext.getPattern(namespace.getName(), null) : LoaderContext.getPattern(null, namespace.getName())));
        } else {
            throw new IllegalArgumentException("Strange kind of the given namespace: " + namespaceKind.name());
        }
        this.mySelection.add((Object)pattern);
        return this;
    }

    public LoaderContext includeAllSchemas() {
        this.mySelection.add((Object)LoaderContext.getPattern(null, null));
        return this;
    }

    public LoaderContext includeAllEntities() {
        return this.includeTables().includeProcedures();
    }

    public LoaderContext includeTables() {
        return this.include(DasTable.class);
    }

    public LoaderContext includeProcedures() {
        return this.include(DasRoutine.class);
    }

    public LoaderContext setUpdateUi(final @NotNull Project project, final @Nullable Runnable continuation) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/LoaderContext", "setUpdateUi"));
        }
        this.myUpdateUiRunnable = new Runnable(){

            @Override
            public void run() {
                if (!project.isOpen()) {
                    return;
                }
                DbDataSource dataSourceElement = DbPsiFacade.getInstance(project).findDataSource(LoaderContext.this.myDataSource.getUniqueId());
                if (dataSourceElement != null) {
                    DbPsiFacade.getInstance(project).clearCaches(dataSourceElement);
                    dataSourceElement.getDbManager().fireDataSourceUpdated(dataSourceElement);
                }
                if (continuation != null) {
                    continuation.run();
                }
            }
        };
        return this;
    }

    public boolean loadNothing() {
        return this.mySelection.isEmpty();
    }

    public boolean load(Object o) {
        return this.mySelection.contains(o);
    }

    public boolean load(String catalog, String schema) {
        return this.mySelection.contains((Object)LoaderContext.getPattern(catalog, schema)) || this.mySelection.contains((Object)LoaderContext.getPattern(catalog, null)) || this.mySelection.contains((Object)LoaderContext.getPattern(null, null));
    }

    public boolean loadTables() {
        return this.load(DasTable.class);
    }

    public boolean loadProcedures() {
        return this.load(DasRoutine.class);
    }

    public ErrorHandler getErrorHandler() {
        return this.myErrorHandler;
    }

    @Nullable
    public Runnable getUpdateUiRunnable() {
        return this.myUpdateUiRunnable;
    }

    public Object getElementToFocus() {
        return this.mySelectedElement;
    }

    public void setElementToFocus(@Nullable Object selectedElement) {
        this.mySelectedElement = selectedElement;
    }

    @NotNull
    public static String getPattern(@Nullable String catalog, @Nullable String schema) {
        if (StringUtil.isNotEmpty((String)catalog)) {
            if (StringUtil.isNotEmpty((String)schema)) {
                String string = catalog + "." + schema;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "getPattern"));
                }
                return string;
            }
            String string = catalog + ".*";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "getPattern"));
            }
            return string;
        }
        if (StringUtil.isNotEmpty((String)schema)) {
            String string = "*." + schema;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "getPattern"));
            }
            return string;
        }
        if ("*" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "getPattern"));
        }
        return "*";
    }

    @Nullable
    public Pattern getProcedurePattern() {
        return this.myProcedurePattern;
    }

    public LoaderContext setProcedurePattern(@Nullable Pattern procedurePattern) {
        this.myProcedurePattern = procedurePattern;
        return this;
    }
}

