/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.core;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Version;

public final class ConnectionInfo
implements Serializable {
    @Nullable
    public final String databaseName;
    @Nullable
    public final String schemaName;
    @Nullable
    public final String userName;
    @NotNull
    public final Version serverVersion;
    @NotNull
    public final Version driverVersion;

    public ConnectionInfo(@Nullable String databaseName, @Nullable String schemaName, @Nullable String userName, @NotNull Version serverVersion, @NotNull Version driverVersion) {
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.userName = userName;
        this.serverVersion = serverVersion;
        this.driverVersion = driverVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) return false;
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionInfo that = (ConnectionInfo)o;
        if (this.databaseName != null) {
            if (!this.databaseName.equals(that.databaseName)) {
                return false;
            }
        } else if (that.databaseName != null) return false;
        if (this.schemaName != null) {
            if (!this.schemaName.equals(that.schemaName)) {
                return false;
            }
        } else if (that.schemaName != null) return false;
        if (this.userName != null) {
            if (!this.userName.equals(that.userName)) {
                return false;
            }
        } else if (that.userName != null) return false;
        if (!this.serverVersion.equals(that.serverVersion)) return false;
        if (!this.driverVersion.equals(that.driverVersion)) return false;
        return true;
    }

    public int hashCode() {
        int result = this.databaseName != null ? this.databaseName.hashCode() : 0;
        result = 31 * result + (this.schemaName != null ? this.schemaName.hashCode() : 0);
        result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
        result = 31 * result + this.serverVersion.hashCode();
        return result;
    }
}

