/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.core;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.BaseTestHelper;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.sql.Scriptum;

public class MysqlTestHelper
extends BaseTestHelper<DBFacade> {
    public MysqlTestHelper(@NotNull DBFacade db) {
        super(db, Scriptum.of(MysqlTestHelper.class));
        this.schemasNotToZap.add("performance_schema");
        this.schemasNotToZap.add("mysql");
    }

    @Override
    public void prepareX1() {
        this.performCommand("create or replace view X1 as select 1");
    }

    @Override
    public void prepareX1000() {
        this.performCommand(this.scriptum, "X10");
        this.performCommand(this.scriptum, "X1000");
    }

    @Override
    public void prepareX1000000() {
        this.prepareX1000();
        this.performCommand(this.scriptum, "X1000000");
    }

    @Override
    protected void ensureNoTableOrView4(Object[] params) {
        this.performMetaQueryCommands(this.scriptum, "EnsureNoForeignKeysMetaQuery", params);
        this.performMetaQueryCommands(this.scriptum, "EnsureNoTableOrViewMetaQuery", params);
    }

    @Override
    protected void zapSchemaInternally(ConnectionInfo connectionInfo) {
        this.performMetaQueryCommands(this.scriptum, "ZapForeignKeysMetaQuery", new Object[0]);
        this.performMetaQueryCommands(this.scriptum, "ZapSchemaMetaQuery", new Object[0]);
    }
}

