/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sybase;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;
import org.jetbrains.dekaf.jdbc.SybaseIntermediateSession;
import org.jetbrains.dekaf.util.Version;

public class SybaseIntermediateFacade
extends JdbcIntermediateFacade {
    static final String CONNECTION_INFO_QUERY = "select db_name(), user_name(), suser_name(), @@version";
    static final Pattern SYBASE_ASE_VERSION_PATTERN = Pattern.compile("/(\\d{1,2}(\\.\\d{1,3}){2,5})/");

    public SybaseIntermediateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, @NotNull Driver driver, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        super(connectionString, connectionProperties, driver, connectionsLimit, exceptionRecognizer);
    }

    public SybaseIntermediateFacade(@NotNull DataSource dataSource, int connectionsLimit, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        super(dataSource, connectionsLimit, exceptionRecognizer);
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return Sybase.RDBMS;
    }

    @Override
    @NotNull
    protected SybaseIntermediateSession instantiateSession(@NotNull Connection connection, boolean ownConnection) {
        return new SybaseIntermediateSession(this, this.myExceptionRecognizer, connection, ownConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionInfo getConnectionInfo() {
        String driverVersionStr;
        String[] env;
        JdbcIntermediateSession session = this.openSession();
        try {
            env = session.queryOneRow(CONNECTION_INFO_QUERY, 4, String.class);
            try {
                DatabaseMetaData md = session.getConnection().getMetaData();
                driverVersionStr = md.getDriverVersion();
            }
            catch (SQLException sqle) {
                throw this.getExceptionRecognizer().recognizeException(sqle, "getting versions using JDBC metadata");
            }
        }
        finally {
            session.close();
        }
        Version driverVersion = SybaseIntermediateFacade.extractVersion(driverVersionStr, SIMPLE_VERSION_PATTERN, 1);
        if (env != null) {
            assert (env.length == 4);
            Version serverVersion = SybaseIntermediateFacade.extractVersion(env[3], SYBASE_ASE_VERSION_PATTERN, 1);
            return new ConnectionInfo(env[0], env[1], env[2], serverVersion, driverVersion);
        }
        return new ConnectionInfo(null, null, null, Version.ZERO, driverVersion);
    }
}

