/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.PaintingParent;
import com.intellij.uml.components.UmlGraphZoomableViewport;
import com.intellij.uml.dnd.UmlDnDSupport;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import org.jetbrains.annotations.NotNull;

public class UmlGraphComponent
implements Disposable {
    private final JComponent myComponent;
    private final DiagramBuilder myBuilder;

    public UmlGraphComponent(@NotNull DiagramBuilder builder, ActionToolbar toolbar) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/uml/components/UmlGraphComponent", "<init>"));
        }
        this.myBuilder = builder;
        MyComponent component = new MyComponent();
        ((ActionToolbarImpl)toolbar).setForceUseMacEnhancements(true);
        JComponent jToolbar = toolbar.getComponent();
        jToolbar.setBackground(builder.getProvider().getColorManager().getToolbarColor());
        jToolbar.setBorder(new AbstractBorder(){

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(1, 2, 1, 0);
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Color color = g.getColor();
                g.setColor((Color)new JBColor((Color)JBColor.gray, (Color)Gray._85));
                g.drawLine(0, height - 1, width, height - 1);
                g.setColor(color);
            }

            @Override
            public Insets getBorderInsets(Component c, Insets insets) {
                insets.top = 0;
                insets.right = 0;
                insets.left = 0;
                insets.bottom = 1;
                return insets;
            }
        });
        component.add((Component)jToolbar, "North");
        component.add((Component)new UmlGraphZoomableViewport(builder), "Center");
        Disposer.register((Disposable)this, (Disposable)builder);
        builder.initialize();
        this.addDnDSupport();
        this.myComponent = new PaintingParent.Wrapper((Component)component);
    }

    private void fixScrollBars() {
        try {
            for (Component component : this.myBuilder.getView().getJComponent().getComponents()) {
                if (!(component instanceof JScrollBar)) continue;
                ((JScrollBar)component).setUI(ButtonlessScrollBarUI.createNormal());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static ActionToolbar createToolbarPanel(DefaultActionGroup actionsGroup) {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)actionsGroup);
        return ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actions, true);
    }

    private void addDnDSupport() {
        new DropTarget(this.myBuilder.getView().getCanvasComponent(), new UmlDnDSupport(this.myBuilder));
    }

    public void dispose() {
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/components/UmlGraphComponent", "getComponent"));
        }
        return jComponent;
    }

    private class MyComponent
    extends JPanel {
        public MyComponent() {
            super(new BorderLayout());
        }

        @Override
        public void updateUI() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UmlGraphComponent.this.fixScrollBars();
                }
            });
        }
    }
}

