/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.project;

import aQute.bnd.header.Parameters;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BundleManifest {
    private final Map<String, String> myMap;
    private final PsiFile mySource;

    public BundleManifest(@NotNull Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/osgi/project/BundleManifest", "<init>"));
        }
        this(map, null);
    }

    public BundleManifest(@NotNull Map<String, String> map, @Nullable PsiFile source) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/osgi/project/BundleManifest", "<init>"));
        }
        this.mySource = source;
        this.myMap = ContainerUtil.newHashMap(map);
    }

    @Nullable
    public PsiFile getSource() {
        return this.mySource;
    }

    @Nullable
    public String get(@NotNull String attr) {
        if (attr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attr", "org/jetbrains/osgi/project/BundleManifest", "get"));
        }
        return this.myMap.get(attr);
    }

    @Nullable
    public String getBundleSymbolicName() {
        return this.get("Bundle-SymbolicName");
    }

    @Nullable
    public String getBundleActivator() {
        return this.get("Bundle-Activator");
    }

    @Nullable
    public String getExportedPackage(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/osgi/project/BundleManifest", "getExportedPackage"));
        }
        for (String exported : this.getValues("Export-Package")) {
            if (!PsiNameHelper.isSubpackageOf((String)packageName, (String)exported)) continue;
            return exported;
        }
        return null;
    }

    public boolean isPackageImported(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/osgi/project/BundleManifest", "isPackageImported"));
        }
        for (String imported : this.getValues("Import-Package")) {
            if (!PsiNameHelper.isSubpackageOf((String)packageName, (String)imported)) continue;
            return true;
        }
        return false;
    }

    public boolean isBundleRequired(@NotNull String bsn) {
        if (bsn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bsn", "org/jetbrains/osgi/project/BundleManifest", "isBundleRequired"));
        }
        for (String bundleName : this.getValues("Require-Bundle")) {
            if (!bsn.equals(bundleName)) continue;
            return true;
        }
        return false;
    }

    public boolean isPrivatePackage(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/osgi/project/BundleManifest", "isPrivatePackage"));
        }
        for (String privatePkg : this.getValues("Private-Package")) {
            if (!PsiNameHelper.isSubpackageOf((String)packageName, (String)privatePkg)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getValues(String header) {
        String value = this.get(header);
        return StringUtil.isEmptyOrSpaces((String)value) ? Collections.emptySet() : new Parameters(value).keySet();
    }
}

