/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.lang.psi;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.jetbrains.osgi.project.BundleManifest;
import org.jetbrains.osgi.project.BundleManifestCache;
import org.osmorc.i18n.OsmorcBundle;

public class BundleReference
extends PsiReferenceBase<HeaderValuePart>
implements EmptyResolveMessageProvider {
    private static final ResolveCache.AbstractResolver<BundleReference, PsiElement> RESOLVER = new ResolveCache.AbstractResolver<BundleReference, PsiElement>(){

        public PsiElement resolve(@NotNull BundleReference reference, boolean incompleteCode) {
            Module module;
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/osmorc/manifest/lang/psi/BundleReference$1", "resolve"));
            }
            String text = reference.getCanonicalText();
            HeaderValuePart refElement = (HeaderValuePart)reference.getElement();
            if (!StringUtil.isEmptyOrSpaces((String)text) && refElement.isValid() && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)refElement)) != null) {
                final Ref result = Ref.create();
                final String refText = text.replaceAll("\\s", "");
                final BundleManifestCache cache = BundleManifestCache.getInstance(module.getProject());
                ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
                manager.orderEntries().forEachModule((Processor)new Processor<Module>(){

                    public boolean process(Module module) {
                        BundleManifest manifest = cache.getManifest(module);
                        if (manifest != null && refText.equals(manifest.getBundleSymbolicName())) {
                            result.set((Object)this.getTarget(manifest));
                            return false;
                        }
                        return true;
                    }
                });
                if (!result.isNull()) {
                    return (PsiElement)result.get();
                }
                manager.orderEntries().forEachLibrary((Processor)new Processor<Library>(){

                    public boolean process(Library library) {
                        for (VirtualFile libRoot : library.getFiles(OrderRootType.CLASSES)) {
                            BundleManifest manifest = cache.getManifest(libRoot);
                            if (manifest == null || !refText.equals(manifest.getBundleSymbolicName())) continue;
                            result.set((Object)this.getTarget(manifest));
                            return false;
                        }
                        return true;
                    }
                });
                if (!result.isNull()) {
                    return (PsiElement)result.get();
                }
            }
            return null;
        }

        private PsiElement getTarget(BundleManifest manifest) {
            Header header;
            PsiFile source = manifest.getSource();
            if (source instanceof ManifestFile && (header = ((ManifestFile)source).getHeader("Bundle-SymbolicName")) != null) {
                return header;
            }
            return source;
        }
    };

    public BundleReference(@NotNull HeaderValuePart element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/osmorc/manifest/lang/psi/BundleReference", "<init>"));
        }
        super((PsiElement)element);
    }

    @Nullable
    public PsiElement resolve() {
        return (PsiElement)ResolveCache.getInstance((Project)((HeaderValuePart)this.myElement).getProject()).resolveWithCaching((PsiReference)this, RESOLVER, false, false);
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/manifest/lang/psi/BundleReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = OsmorcBundle.message("cannot.resolve.bundle", this.getCanonicalText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/manifest/lang/psi/BundleReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }
}

