/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.run.ui;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jetbrains.annotations.NotNull;

public class JSpinnerCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private final JSpinner mySpinner = new JSpinner();

    public JSpinnerCellEditor() {
        this.mySpinner.setModel(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.mySpinner.getEditor();
        editor.getTextField().setFormatterFactory(new DefaultFormatterFactory(new MyNumberFormatter("Default")));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null || !(value instanceof Number)) {
            Logger.getInstance(this.getClass()).error("value:" + value);
            value = 0;
        }
        this.mySpinner.setValue(value);
        this.adjust(table, column);
        return this.mySpinner;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.mySpinner.setValue(value);
        this.mySpinner.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JSpinnerCellEditor.this.fireEditingStopped();
            }
        });
        this.mySpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSpinnerCellEditor.this.fireEditingStopped();
            }
        });
        this.adjust(table, column);
        return this.mySpinner;
    }

    private void adjust(JTable table, int column) {
        Dimension size = this.mySpinner.getPreferredSize();
        size.width = table.getColumnModel().getColumn(column).getWidth() - 5;
        this.mySpinner.setPreferredSize(size);
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        return !(evt instanceof MouseEvent) || ((MouseEvent)evt).getClickCount() >= 1;
    }

    @Override
    public Object getCellEditorValue() {
        return this.mySpinner.getValue();
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.mySpinner.commitEdit();
            return super.stopCellEditing();
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static class MyNumberFormatter
    extends NumberFormatter {
        private final String myZeroValue;

        public MyNumberFormatter(@NotNull String zeroValue) {
            if (zeroValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "zeroValue", "org/osmorc/run/ui/JSpinnerCellEditor$MyNumberFormatter", "<init>"));
            }
            this.myZeroValue = zeroValue;
            this.setValueClass(Integer.class);
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            if (value instanceof Long && value.equals(0L) || value instanceof Integer && value.equals(0)) {
                return this.myZeroValue;
            }
            return super.valueToString(value);
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            if (text.equals(this.myZeroValue)) {
                return 0;
            }
            return super.stringToValue(text);
        }
    }
}

