/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.nodes;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelManager;
import com.intellij.jam.view.DefaultUserResponse;
import com.intellij.jam.view.JamDeleteProvider;
import com.intellij.jam.view.JamUserResponse;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ModelMergerUtil;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeObjectDescriptor<P extends CommonModelElement>
extends JavaeeNodeDescriptor<P> {
    protected JavaeeObjectDescriptor(P element, NodeDescriptor parentDescriptor, Object parameters) {
        super(parentDescriptor.getProject(), parentDescriptor, parameters, element);
    }

    protected JavaeeObjectDescriptor(P element, Project project, Object parameters) {
        super(project, null, parameters, element);
    }

    public DeleteProvider getDeleteProvider() {
        DefaultUserResponse response = new DefaultUserResponse(this.myProject);
        return new JamDeleteProvider((CommonModelElement)this.getElement(), (JamUserResponse)response);
    }

    public P updateElement() {
        if (!this.isValid()) {
            return null;
        }
        CommonModelElement element = (CommonModelElement)this.getElement();
        try {
            if (!element.isValid()) {
                return null;
            }
        }
        catch (IndexNotReadyException e) {
            return null;
        }
        return (P)((CommonModelElement)this.getElement());
    }

    public String getNewTooltip() {
        return null;
    }

    public boolean isValid() {
        try {
            return ((CommonModelElement)this.getElement()).isValid();
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    protected void doUpdate() {
        super.doUpdate();
        String textExt = this.getNewNodeTextExt();
        if (StringUtil.isNotEmpty((String)textExt)) {
            this.addColoredFragment(" (" + textExt + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
    }

    @Nullable
    protected String getNewNodeTextExt() {
        return null;
    }

    public Object getData(String dataId) {
        Navigatable navigatable;
        if (DataConstants.NAVIGATABLE.equals(dataId) && (navigatable = this.getNavigatable()) != null) {
            return navigatable;
        }
        if ("psi.Element".equals(dataId)) {
            CommonModelElement element = (CommonModelElement)this.getElement();
            return element.isValid() ? element.getIdentifyingPsiElement() : null;
        }
        if ("module".equals(dataId)) {
            return this.getParentElementOfType(Module.class);
        }
        return super.getData(dataId);
    }

    @Nullable
    public <T> T getParentElementOfType(Class<T> elementClass) {
        for (JavaeeObjectDescriptor cur = this; cur != null; cur = cur.getParentDescriptor()) {
            Object element = cur.getElement();
            if (element == null || !ReflectionUtil.isAssignable(elementClass, element.getClass())) continue;
            return (T)element;
        }
        return null;
    }

    @Nullable
    protected Navigatable getNavigatable() {
        XmlFile file;
        VirtualFile virtualFile;
        DomElement domElement = CommonModelManager.getInstance().getDomElement((CommonModelElement)this.getElement());
        if (domElement != null && domElement.getXmlTag() != null && (virtualFile = (file = DomUtil.getFile((DomElement)domElement)).getVirtualFile()) != null && virtualFile.isValid()) {
            return new OpenFileDescriptor(file.getProject(), virtualFile, domElement.getXmlTag().getTextRange().getStartOffset());
        }
        CommonModelElement annoElement = (CommonModelElement)ModelMergerUtil.getImplementation((Object)this.getElement(), CommonModelElement.class);
        if (annoElement != null && annoElement.getIdentifyingPsiElement() != null) {
            VirtualFile virtualFile2;
            PsiFile file2 = annoElement.getContainingFile();
            VirtualFile virtualFile3 = virtualFile2 = file2 == null ? null : file2.getVirtualFile();
            if (virtualFile2 != null && virtualFile2.isValid()) {
                return new OpenFileDescriptor(file2.getProject(), virtualFile2, annoElement.getIdentifyingPsiElement().getNavigationElement().getTextRange().getStartOffset());
            }
        }
        return null;
    }
}

