/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;

public abstract class DisposableComponent {
    @NonNls
    protected static final String ANCESTOR_PROPERTY = "ancestor";

    protected DisposableComponent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JComponent component = DisposableComponent.this.getComponent();
                if (component == null) {
                    return;
                }
                component.addPropertyChangeListener(DisposableComponent.ANCESTOR_PROPERTY, new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        Object oldValue = evt.getOldValue();
                        Object newValue = evt.getNewValue();
                        if (oldValue != null && newValue == null) {
                            DisposableComponent.this.dispose();
                        }
                    }
                });
            }
        });
    }

    public void dispose() {
    }

    public abstract JComponent getComponent();
}

