/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSIntention
extends PsiElementBaseIntentionAction {
    private static Language JS_LANGUAGE = Language.findLanguageByID((String)"JavaScript");
    @NonNls
    private static final String INTENTION_SUFFIX = "Intention";
    @NonNls
    private static final String DISPLAY_NAME = ".display-name";
    @NonNls
    private static final String FAMILY_NAME = ".family-name";
    private static final String PACKAGE_NAME = JSIntention.class.getPackage().getName();
    private final JSElementPredicate predicate = this.getElementPredicate();

    protected JSIntention() {
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/idea/lang/javascript/intention/JSIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/JSIntention", "invoke"));
        }
        if (JSElementFactory.isFileReadOnly(project, element.getContainingFile())) {
            return;
        }
        PsiElement matchingElement = this.findMatchingElement(element);
        if (matchingElement != null) {
            this.processIntention(matchingElement);
        }
    }

    protected abstract void processIntention(@NotNull PsiElement var1) throws IncorrectOperationException;

    @NotNull
    protected abstract JSElementPredicate getElementPredicate();

    @Nullable
    protected PsiElement findMatchingElement(@Nullable PsiElement element) {
        if (element == null || element instanceof PsiFile) {
            return null;
        }
        Language language = element.getLanguage();
        if (language != Language.ANY && language != JavascriptLanguage.INSTANCE && !(language instanceof JSLanguageDialect)) {
            return null;
        }
        while (element != null) {
            if (this.predicate.satisfiedBy(element)) {
                return element;
            }
            if (!((element = element.getParent()) instanceof PsiFile) && !(element instanceof XmlElement)) continue;
            break;
        }
        return null;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/idea/lang/javascript/intention/JSIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/JSIntention", "isAvailable"));
        }
        return this.findMatchingElement(element) != null && JavaScriptIntention.isAcceptedFor((PsiElement)element, ((Object)((Object)this)).getClass());
    }

    public boolean startInWriteAction() {
        return true;
    }

    protected String getTextKey(Object ... suffixes) {
        return JSIntentionBundle.getKey(((Object)((Object)this)).getClass().getName().substring(PACKAGE_NAME.length() + 1).replace("JS", ""), INTENTION_SUFFIX, null, suffixes);
    }

    @NotNull
    public String getText() {
        String string = JSIntentionBundle.message(this.getTextKey(DISPLAY_NAME), new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/JSIntention", "getText"));
        }
        return string;
    }

    public String getText(Object ... arguments) {
        return JSIntentionBundle.message(this.getTextKey(DISPLAY_NAME), arguments);
    }

    protected String getSuffixedDisplayName(@NonNls String suffix, Object ... arguments) {
        return JSIntentionBundle.message(this.getTextKey(DISPLAY_NAME, Character.valueOf('.'), suffix), arguments);
    }

    @NotNull
    public String getFamilyName() {
        String string = JSIntentionBundle.message(this.getTextKey(FAMILY_NAME), new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/JSIntention", "getFamilyName"));
        }
        return string;
    }
}

