/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.braces;

import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSAddBracesIntention
extends JSMutablyNamedIntention {
    @NonNls
    private static final String IF_KEYWORD = "if";
    @NonNls
    private static final String ELSE_KEYWORD = "else";

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        AddBracesPredicate addBracesPredicate = new AddBracesPredicate();
        if (addBracesPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "getElementPredicate"));
        }
        return addBracesPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        String keyword;
        JSElement parent = (JSElement)element.getParent();
        assert (parent != null);
        if (parent instanceof JSIfStatement) {
            JSIfStatement ifStatement = (JSIfStatement)parent;
            JSStatement elseBranch = ifStatement.getElse();
            keyword = element.equals(elseBranch) ? ELSE_KEYWORD : IF_KEYWORD;
        } else {
            PsiElement firstChild = parent.getFirstChild();
            assert (firstChild != null);
            keyword = firstChild.getText();
        }
        return this.getText(keyword);
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "processIntention"));
        }
        if (!(element instanceof JSStatement)) {
            return;
        }
        JSStatement statement = (JSStatement)element;
        JSElement parent = (JSElement)element.getParent();
        String text = element.getText();
        String newText = parent.getLastChild() instanceof PsiComment ? '{' + text + "\n}" : '{' + text + '}';
        JSAddBracesIntention.replaceAndReformat(statement, newText);
    }

    private static void replaceAndReformat(final @NotNull JSStatement statement, final @NotNull String text) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "replaceAndReformat"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "replaceAndReformat"));
        }
        final Ref newStatement = Ref.create();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)statement.getProject());
        codeStyleManager.performActionWithFormatterDisabled(new Runnable(){

            @Override
            public void run() {
                newStatement.set((Object)JSElementFactory.replaceStatement(statement, text));
            }
        });
        PsiElement formatted = codeStyleManager.reformat((PsiElement)newStatement.get());
        codeStyleManager.reformatNewlyAddedElement(formatted.getNode().getTreeParent(), formatted.getNode());
    }

    private static class AddBracesPredicate
    implements JSElementPredicate {
        private AddBracesPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention$AddBracesPredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSStatement)) {
                return false;
            }
            if (element instanceof JSBlockStatement) {
                return false;
            }
            PsiElement parentElement = element.getParent();
            if (!(parentElement instanceof JSElement)) {
                return false;
            }
            JSElement parent = (JSElement)parentElement;
            if (parent instanceof JSIfStatement) {
                JSIfStatement ifStatement = (JSIfStatement)parent;
                return !(element instanceof JSIfStatement) || !element.equals(ifStatement.getElse());
            }
            if (parent instanceof JSForStatement || parent instanceof JSForInStatement) {
                return element.equals(((JSLoopStatement)parent).getBody());
            }
            return parent instanceof JSWhileStatement || parent instanceof JSDoWhileStatement;
        }
    }
}

