/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.psiutil.ErrorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSVariablesWithInitializerPredicate
implements JSElementPredicate {
    public static final JSElementPredicate PREDICATE = new JSVariablesWithInitializerPredicate();

    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/JSVariablesWithInitializerPredicate", "satisfiedBy"));
        }
        if (!(element instanceof JSVarStatement)) {
            return false;
        }
        PsiElement elementParent = element.getParent();
        if (!JSVariablesWithInitializerPredicate.isRegularVariableContext(elementParent)) {
            return false;
        }
        JSVarStatement varStatement = (JSVarStatement)element;
        if (ErrorUtil.containsError((PsiElement)varStatement)) {
            return false;
        }
        for (JSVariable variable : varStatement.getVariables()) {
            if (!this.isAcceptableVariable(variable)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRegularVariableContext(@Nullable PsiElement statementParent) {
        return !(statementParent instanceof JSForStatement) && !(statementParent instanceof JSClass) && (!(statementParent instanceof JSFile) || JSResolveUtil.getClassOfContext((PsiElement)statementParent) == null);
    }

    protected boolean isAcceptableVariable(@NotNull JSVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/intellij/idea/lang/javascript/intention/initialization/JSVariablesWithInitializerPredicate", "isAcceptableVariable"));
        }
        return variable.hasInitializer() && !variable.isConst();
    }

    @Nullable
    public static String getTypeString(PsiFile containingFile, JSVariable variable) {
        DialectOptionHolder holder;
        String s;
        JSType type = JSPsiImplUtils.getTypeFromDeclaration((JSNamedElement)variable);
        String string = s = type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
        if (s == null && (holder = DialectDetector.dialectOfFile((PsiFile)containingFile)) != null) {
            JSType variableType;
            if (holder.isECMA4) {
                s = JSResolveUtil.getQualifiedExpressionType((JSExpression)variable.getInitializer(), (PsiFile)containingFile);
                s = (String)ImportUtils.importAndShortenReference((String)s, (PsiElement)variable, (boolean)true, (boolean)true).first;
            } else if (holder.isTypeScript && (variableType = variable.getType()) != null) {
                s = TypeScriptUtil.getShortestTypeNameInContext((JSType)variableType, (PsiElement)variable);
            }
        }
        return s;
    }
}

