/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.loop;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.EquivalenceChecker;
import org.intellij.idea.lang.javascript.psiutil.ErrorUtil;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSMergeParallelForLoopsIntention
extends JSIntention {
    @NonNls
    private static final String FOR_STATEMENT_PREFIX = "for (";

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        MergeParallelForLoopsPredicate mergeParallelForLoopsPredicate = new MergeParallelForLoopsPredicate();
        if (mergeParallelForLoopsPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/loop/JSMergeParallelForLoopsIntention", "getElementPredicate"));
        }
        return mergeParallelForLoopsPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/loop/JSMergeParallelForLoopsIntention", "processIntention"));
        }
        PsiElement nextElement = JSElementFactory.getNonWhiteSpaceSibling(element, true);
        assert (nextElement != null);
        JSForStatement firstStatement = (JSForStatement)element;
        JSForStatement secondStatement = (JSForStatement)nextElement;
        StringBuilder statementBuffer = new StringBuilder();
        this.mergeForStatements(statementBuffer, firstStatement, secondStatement);
        JSElementFactory.replaceStatement((JSStatement)firstStatement, statementBuffer.toString());
        JSElementFactory.removeElement((PsiElement)secondStatement);
    }

    private void mergeForStatements(StringBuilder statementBuffer, JSForStatement firstStatement, JSForStatement secondStatement) {
        JSExpression initialization = firstStatement.getInitialization();
        JSVarStatement varStatement = firstStatement.getVarDeclaration();
        JSExpression condition = firstStatement.getCondition();
        JSExpression update = firstStatement.getUpdate();
        JSStatement firstBody = firstStatement.getBody();
        JSStatement secondBody = secondStatement.getBody();
        statementBuffer.append(FOR_STATEMENT_PREFIX).append(initialization == null ? varStatement.getText() : initialization.getText()).append(';').append(condition.getText()).append(';').append(update.getText()).append(')');
        ControlFlowUtils.appendStatementsInSequence((StringBuilder)statementBuffer, (JSStatement)firstBody, (JSStatement)secondBody);
    }

    private static class MergeParallelForLoopsPredicate
    implements JSElementPredicate {
        private MergeParallelForLoopsPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/loop/JSMergeParallelForLoopsIntention$MergeParallelForLoopsPredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSForStatement) || ErrorUtil.containsError(element)) {
                return false;
            }
            PsiElement nextStatement = JSElementFactory.getNonWhiteSpaceSibling(element, true);
            if (!(nextStatement instanceof JSForStatement) || ErrorUtil.containsError(nextStatement)) {
                return false;
            }
            return MergeParallelForLoopsPredicate.forStatementsCanBeMerged((JSForStatement)element, (JSForStatement)nextStatement);
        }

        public static boolean forStatementsCanBeMerged(JSForStatement statement1, JSForStatement statement2) {
            JSExpression secondUpdate;
            JSExpression secondCondition;
            JSVarStatement secondVarStatement;
            JSExpression secondInitialization;
            JSExpression firstInitialization = statement1.getInitialization();
            if (!EquivalenceChecker.expressionsAreEquivalent(firstInitialization, secondInitialization = statement2.getInitialization())) {
                return false;
            }
            JSVarStatement firstVarStatement = statement1.getVarDeclaration();
            if (!EquivalenceChecker.statementsAreEquivalent((JSStatement)firstVarStatement, (JSStatement)(secondVarStatement = statement2.getVarDeclaration()))) {
                return false;
            }
            JSExpression firstCondition = statement1.getCondition();
            if (!EquivalenceChecker.expressionsAreEquivalent(firstCondition, secondCondition = statement2.getCondition())) {
                return false;
            }
            JSExpression firstUpdate = statement1.getUpdate();
            if (!EquivalenceChecker.expressionsAreEquivalent(firstUpdate, secondUpdate = statement2.getUpdate())) {
                return false;
            }
            JSStatement firstBody = statement1.getBody();
            JSStatement secondBody = statement2.getBody();
            return firstBody == null || secondBody == null || ControlFlowUtils.canBeMerged((JSStatement)firstBody, (JSStatement)secondBody);
        }
    }
}

