/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.number;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.intellij.idea.lang.javascript.psiutil.NumberUtil;
import org.jetbrains.annotations.NotNull;

public abstract class JSConvertIntegerIntentionBase
extends JSIntention {
    @Override
    @NotNull
    public final JSElementPredicate getElementPredicate() {
        ConvertPredicate convertPredicate = new ConvertPredicate();
        if (convertPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/number/JSConvertIntegerIntentionBase", "getElementPredicate"));
        }
        return convertPredicate;
    }

    @Override
    public final void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/number/JSConvertIntegerIntentionBase", "processIntention"));
        }
        JSLiteralExpression exp = (JSLiteralExpression)element;
        JSElementFactory.replaceExpression((JSExpression)exp, this.getNumberPrefix(exp) + NumberUtil.getLiteralNumber(exp).toString(this.getRadix()));
    }

    @NotNull
    protected abstract String getNumberPrefix(@NotNull JSLiteralExpression var1);

    protected abstract int getRadix();

    protected abstract boolean isSatisfy(@NotNull JSLiteralExpression var1);

    private class ConvertPredicate
    implements JSElementPredicate {
        private ConvertPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/number/JSConvertIntegerIntentionBase$ConvertPredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSLiteralExpression)) {
                return false;
            }
            JSLiteralExpression literalExpression = (JSLiteralExpression)element;
            if (!NumberUtil.isInteger(literalExpression)) {
                return false;
            }
            return JSConvertIntegerIntentionBase.this.isSatisfy(literalExpression);
        }
    }
}

