/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.parenthesis;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.UnnecessaryParenthesesChecker;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.ErrorUtil;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.intellij.idea.lang.javascript.psiutil.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class JSRemoveUnnecessaryParenthesesIntention
extends JSIntention {
    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = new JSElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/parenthesis/JSRemoveUnnecessaryParenthesesIntention$1", "satisfiedBy"));
                }
                if (!JSInheritedLanguagesHelper.isRemoveUnnecessaryParenthesesEnabled((PsiElement)element)) {
                    return false;
                }
                if (!(element instanceof JSParenthesizedExpression)) {
                    return false;
                }
                if (ErrorUtil.containsError(element)) {
                    return false;
                }
                return UnnecessaryParenthesesChecker.shouldRemove((JSParenthesizedExpression)((JSParenthesizedExpression)element));
            }
        };
        if (jSElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/parenthesis/JSRemoveUnnecessaryParenthesesIntention", "getElementPredicate"));
        }
        return jSElementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/parenthesis/JSRemoveUnnecessaryParenthesesIntention", "processIntention"));
        }
        JSExpression exp = (JSExpression)element;
        while (exp.getParent() instanceof JSExpression) {
            exp = (JSExpression)exp.getParent();
            assert (exp != null);
        }
        String newExpression = ParenthesesUtils.removeParentheses(exp);
        JSElementFactory.replaceExpression(exp, newExpression);
    }
}

