/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.ConditionalUtils;
import org.intellij.idea.lang.javascript.psiutil.ErrorUtil;
import org.jetbrains.annotations.NotNull;

public class JSSimplifyIfElseIntention
extends JSIntention {
    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        SimplifyIfElsePredicate simplifyIfElsePredicate = new SimplifyIfElsePredicate();
        if (simplifyIfElsePredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/trivialif/JSSimplifyIfElseIntention", "getElementPredicate"));
        }
        return simplifyIfElsePredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSSimplifyIfElseIntention", "processIntention"));
        }
        PsiElement statement = element.getParent() instanceof JSIfStatement ? element.getParent() : element;
        ConditionalUtils.replaceAssignmentOrReturnIfSimplifiable((JSIfStatement)statement);
    }

    private static class SimplifyIfElsePredicate
    implements JSElementPredicate {
        private SimplifyIfElsePredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSSimplifyIfElseIntention$SimplifyIfElsePredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSElement)) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSIfStatement)) {
                if (element instanceof JSIfStatement) {
                    parent = element;
                } else {
                    return false;
                }
            }
            if (ErrorUtil.containsError(parent)) {
                return false;
            }
            JSIfStatement ifStatement = (JSIfStatement)parent;
            JSExpression condition = ifStatement.getCondition();
            if (condition == null || !condition.isValid()) {
                return false;
            }
            return ConditionalUtils.isSimplifiableAssignment(ifStatement, false) || ConditionalUtils.isSimplifiableAssignment(ifStatement, true) || ConditionalUtils.isSimplifiableReturn(ifStatement, false) || ConditionalUtils.isSimplifiableReturn(ifStatement, true) || ConditionalUtils.isSimplifiableImplicitReturn(ifStatement, false) || ConditionalUtils.isSimplifiableImplicitReturn(ifStatement, true) || ConditionalUtils.isSimplifiableImplicitAssignment(ifStatement, false) || ConditionalUtils.isSimplifiableImplicitAssignment(ifStatement, true) || ConditionalUtils.isSimplifiableEmptyBranches(ifStatement);
        }
    }
}

