/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.ErrorUtil;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSSplitElseIfIntention
extends JSIntention {
    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        SplitElseIfPredicate splitElseIfPredicate = new SplitElseIfPredicate();
        if (splitElseIfPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitElseIfIntention", "getElementPredicate"));
        }
        return splitElseIfPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitElseIfIntention", "processIntention"));
        }
        JSIfStatement parentStatement = (JSIfStatement)element.getParent();
        assert (parentStatement != null);
        JSStatement elseBranch = parentStatement.getElse();
        String newStatement = '{' + elseBranch.getText() + '}';
        JSElementFactory.replaceStatement(elseBranch, newStatement);
    }

    private static class SplitElseIfPredicate
    implements JSElementPredicate {
        private SplitElseIfPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitElseIfIntention$SplitElseIfPredicate", "satisfiedBy"));
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSIfStatement)) {
                return false;
            }
            JSIfStatement ifStatement = (JSIfStatement)parent;
            if (ErrorUtil.containsError((PsiElement)ifStatement)) {
                return false;
            }
            JSStatement thenBranch = ifStatement.getThen();
            JSStatement elseBranch = ifStatement.getElse();
            return thenBranch != null && elseBranch != null && elseBranch instanceof JSIfStatement;
        }
    }
}

