/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.ErrorUtil;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.intellij.idea.lang.javascript.psiutil.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSSplitIfAndIntention
extends JSIntention {
    @NonNls
    private static final String IF_STATEMENT_PREFIX = "if (";
    @NonNls
    private static final String INNER_IF_STATEMENT_PREFIX = ") {\n if (";
    @NonNls
    private static final String ELSE_KEYWORD = "else ";

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        SplitIfAndPredicate splitIfAndPredicate = new SplitIfAndPredicate();
        if (splitIfAndPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitIfAndIntention", "getElementPredicate"));
        }
        return splitIfAndPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        int elseLength;
        PsiElement jsElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitIfAndIntention", "processIntention"));
        }
        PsiElement psiElement = jsElement = element.getParent() instanceof JSIfStatement ? element.getParent() : element;
        assert (jsElement != null);
        assert (jsElement instanceof JSIfStatement);
        JSIfStatement ifStatement = (JSIfStatement)jsElement;
        assert (ifStatement.getCondition() instanceof JSBinaryExpression);
        JSBinaryExpression condition = (JSBinaryExpression)ifStatement.getCondition();
        String lhsText = ParenthesesUtils.removeParentheses(condition.getLOperand());
        String rhsText = ParenthesesUtils.removeParentheses(condition.getROperand());
        JSStatement thenBranch = ifStatement.getThen();
        JSStatement elseBranch = ifStatement.getElse();
        String thenText = thenBranch.getText();
        String elseText = elseBranch == null ? null : elseBranch.getText();
        int n = elseLength = elseBranch == null ? 0 : elseText.length();
        assert (condition.getOperationSign().equals(JSTokenTypes.ANDAND));
        StringBuilder statement = new StringBuilder(ifStatement.getTextLength() + elseLength + 30);
        statement.append(IF_STATEMENT_PREFIX).append(lhsText).append(INNER_IF_STATEMENT_PREFIX).append(rhsText).append(')');
        if (!(thenBranch instanceof JSBlockStatement)) {
            statement.append(' ');
        }
        statement.append(thenText);
        if (elseBranch != null) {
            statement.append(ELSE_KEYWORD);
            if (!(elseBranch instanceof JSBlockStatement)) {
                statement.append(' ');
            }
            statement.append(elseText);
        }
        statement.append('}');
        if (elseBranch != null) {
            statement.append(ELSE_KEYWORD).append(elseText);
        }
        JSElementFactory.replaceStatement((JSStatement)ifStatement, statement.toString());
    }

    private static class SplitIfAndPredicate
    implements JSElementPredicate {
        private SplitIfAndPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            JSIfStatement ifStatement;
            JSExpression condition;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitIfAndIntention$SplitIfAndPredicate", "satisfiedBy"));
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSIfStatement)) {
                if (element instanceof JSIfStatement) {
                    parent = element;
                } else {
                    return false;
                }
            }
            if ((condition = (ifStatement = (JSIfStatement)parent).getCondition()) == null || ErrorUtil.containsError((PsiElement)condition)) {
                return false;
            }
            return condition instanceof JSBinaryExpression && ((JSBinaryExpression)condition).getOperationSign() == JSTokenTypes.ANDAND;
        }
    }
}

