/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.providers.contexts.spring;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.spring.web.mvc.jam.SpringMVCJamModel;
import com.intellij.spring.web.mvc.jam.SpringMVCModelAttribute;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.thymeleaf.lang.support.ThymeleafContextVariablesProvider;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafVariable;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ThymeleafSpringMvcAModelAttributesProvider
extends ThymeleafContextVariablesProvider {
    @Override
    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafSpringMvcAModelAttributesProvider", "getContextVariables"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)contextElement);
        ArrayList variables = ContainerUtil.newArrayList();
        if (module != null) {
            SpringMVCModel springMVCModel;
            PsiElement containingFileContext;
            for (SpringMVCModelAttribute attribute : SpringMVCJamModel.getModel((Module)module).getModelAttributes()) {
                PsiType type;
                String name = attribute.getName();
                if (!StringUtil.isNotEmpty((String)name) || (type = attribute.getType()) == null) continue;
                variables.add(new ThymeleafVariable(name, type, (PsiElement)attribute.getPsiElement()));
            }
            PsiFile containingFile = contextElement.getContainingFile();
            if (containingFile != null && (containingFileContext = containingFile.getContext()) != null && (springMVCModel = SpringMVCModel.getModel((PsiElement)containingFileContext)) != null) {
                CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
                PsiElement xmlContext = contextElement.getContainingFile().getContext();
                springMVCModel.processVariables(xmlContext, (Processor)collectProcessor);
                variables.addAll(collectProcessor.getResults());
            }
        }
        ArrayList arrayList = variables;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafSpringMvcAModelAttributesProvider", "getContextVariables"));
        }
        return arrayList;
    }
}

