/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.references.paths;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.thymeleaf.references.paths.ThymeleafViewResolverHelper;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafTemplateResolverMethodsSearchHelper
extends ThymeleafViewResolverHelper {
    @Override
    @NotNull
    public Set<String> getTemplateResolverPrefixes(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/thymeleaf/references/paths/ThymeleafTemplateResolverMethodsSearchHelper", "getTemplateResolverPrefixes"));
        }
        Set set = (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/thymeleaf/references/paths/ThymeleafTemplateResolverMethodsSearchHelper", "lambda$getTemplateResolverPrefixes$2"));
            }
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesScope((Module)module);
            PsiClass aClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("org.thymeleaf.templateresolver.TemplateResolver", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
            return CachedValueProvider.Result.create(ThymeleafTemplateResolverMethodsSearchHelper.getTemplateResolverPrefixes(aClass, (SearchScope)scope), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/references/paths/ThymeleafTemplateResolverMethodsSearchHelper", "getTemplateResolverPrefixes"));
        }
        return set;
    }

    @NotNull
    public static Set<String> getTemplateResolverPrefixes(@Nullable PsiClass resolverClass, @NotNull SearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/thymeleaf/references/paths/ThymeleafTemplateResolverMethodsSearchHelper", "getTemplateResolverPrefixes"));
        }
        Set<String> set = ThymeleafTemplateResolverMethodsSearchHelper.getTemplateResolverPrefixes(resolverClass, "setPrefix", scope);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/references/paths/ThymeleafTemplateResolverMethodsSearchHelper", "getTemplateResolverPrefixes"));
        }
        return set;
    }

    @NotNull
    public static Set<String> getTemplateResolverPrefixes(@Nullable PsiClass resolverClass, @NotNull String methodName, @NotNull SearchScope scope) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/thymeleaf/references/paths/ThymeleafTemplateResolverMethodsSearchHelper", "getTemplateResolverPrefixes"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/thymeleaf/references/paths/ThymeleafTemplateResolverMethodsSearchHelper", "getTemplateResolverPrefixes"));
        }
        Set<Pair<PsiElement, String>> expressions = ThymeleafTemplateResolverMethodsSearchHelper.getTemplateResolverPrefixExpressions(resolverClass, methodName, scope);
        Set set = (Set)expressions.stream().filter(pair -> StringUtil.isNotEmpty((String)((String)pair.second))).map(pair -> (String)pair.second).collect(Collectors.toCollection(HashSet::new));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/references/paths/ThymeleafTemplateResolverMethodsSearchHelper", "getTemplateResolverPrefixes"));
        }
        return set;
    }

    @NotNull
    public static Set<Pair<PsiElement, String>> getTemplateResolverPrefixExpressions(@Nullable PsiClass resolverClass, @NotNull String methodName, @NotNull SearchScope scope) {
        PsiMethod[] methods;
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/thymeleaf/references/paths/ThymeleafTemplateResolverMethodsSearchHelper", "getTemplateResolverPrefixExpressions"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/thymeleaf/references/paths/ThymeleafTemplateResolverMethodsSearchHelper", "getTemplateResolverPrefixExpressions"));
        }
        if (resolverClass != null && (methods = resolverClass.findMethodsByName(methodName, false)).length == 1) {
            Set set = StringExpressionHelper.searchStringExpressions((PsiMethod)methods[0], (SearchScope)scope, (int)0);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/references/paths/ThymeleafTemplateResolverMethodsSearchHelper", "getTemplateResolverPrefixExpressions"));
            }
            return set;
        }
        Set<Pair<PsiElement, String>> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/references/paths/ThymeleafTemplateResolverMethodsSearchHelper", "getTemplateResolverPrefixExpressions"));
        }
        return set;
    }
}

