/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.references.paths.spring;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.thymeleaf.references.paths.ThymeleafViewResolverHelper;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ThymeleafSpringTemplateResolverHelper
extends ThymeleafViewResolverHelper {
    @Override
    @NotNull
    public Set<String> getTemplateResolverPrefixes(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/thymeleaf/references/paths/spring/ThymeleafSpringTemplateResolverHelper", "getTemplateResolverPrefixes"));
        }
        PsiClass templateResolverClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.thymeleaf.templateresolver.TemplateResolver");
        if (templateResolverClass == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/references/paths/spring/ThymeleafSpringTemplateResolverHelper", "getTemplateResolverPrefixes"));
            }
            return set;
        }
        HashSet strings = new HashSet();
        SpringModel model = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)templateResolverClass).withInheritors(GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false));
        List configurers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
        for (SpringBeanPointer configurer : configurers) {
            String prefix = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)configurer.getSpringBean(), (String)"prefix");
            if (!StringUtil.isNotEmpty((String)prefix)) continue;
            strings.add(prefix);
        }
        HashSet hashSet = strings;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/references/paths/spring/ThymeleafSpringTemplateResolverHelper", "getTemplateResolverPrefixes"));
        }
        return hashSet;
    }
}

