/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.util.GithubSettings;

public class GithubUrlUtil {
    @NotNull
    public static String removeProtocolPrefix(String url) {
        int index = url.indexOf(64);
        if (index != -1) {
            String string = url.substring(index + 1).replace(':', '/');
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "removeProtocolPrefix"));
            }
            return string;
        }
        index = url.indexOf("://");
        if (index != -1) {
            String string = url.substring(index + 3);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "removeProtocolPrefix"));
            }
            return string;
        }
        String string = url;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "removeProtocolPrefix"));
        }
        return string;
    }

    @NotNull
    public static String removeTrailingSlash(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/plugins/github/util/GithubUrlUtil", "removeTrailingSlash"));
        }
        if (s.endsWith("/")) {
            String string = s.substring(0, s.length() - 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "removeTrailingSlash"));
            }
            return string;
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "removeTrailingSlash"));
        }
        return string;
    }

    @NotNull
    public static String getApiUrl(@NotNull String urlFromSettings) {
        if (urlFromSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlFromSettings", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getApiUrl"));
        }
        String string = GithubUrlUtil.getApiProtocolFromUrl(urlFromSettings) + GithubUrlUtil.getApiUrlWithoutProtocol(urlFromSettings);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getApiUrl"));
        }
        return string;
    }

    @NotNull
    public static String getApiProtocol() {
        String string = GithubUrlUtil.getApiProtocolFromUrl(GithubSettings.getInstance().getHost());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getApiProtocol"));
        }
        return string;
    }

    @NotNull
    public static String getApiProtocolFromUrl(@NotNull String urlFromSettings) {
        if (urlFromSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlFromSettings", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getApiProtocolFromUrl"));
        }
        if (StringUtil.startsWithIgnoreCase((String)urlFromSettings.trim(), (String)"http://")) {
            if ("http://" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getApiProtocolFromUrl"));
            }
            return "http://";
        }
        if ("https://" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getApiProtocolFromUrl"));
        }
        return "https://";
    }

    @NotNull
    public static String getApiUrl() {
        String string = GithubUrlUtil.getApiUrl(GithubSettings.getInstance().getHost());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getApiUrl"));
        }
        return string;
    }

    @NotNull
    public static String getGithubHost() {
        String string = GithubUrlUtil.getApiProtocol() + GithubUrlUtil.getGitHostWithoutProtocol();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getGithubHost"));
        }
        return string;
    }

    @NotNull
    public static String getHostFromUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getHostFromUrl"));
        }
        String path = GithubUrlUtil.removeProtocolPrefix(url).replace(':', '/');
        int index = path.indexOf(47);
        if (index == -1) {
            String string = path;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getHostFromUrl"));
            }
            return string;
        }
        String string = path.substring(0, index);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getHostFromUrl"));
        }
        return string;
    }

    @NotNull
    public static String getGitHostWithoutProtocol() {
        String string = GithubUrlUtil.removeTrailingSlash(GithubUrlUtil.removeProtocolPrefix(GithubSettings.getInstance().getHost()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getGitHostWithoutProtocol"));
        }
        return string;
    }

    @NotNull
    public static String getApiUrlWithoutProtocol(@NotNull String urlFromSettings) {
        if (urlFromSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlFromSettings", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getApiUrlWithoutProtocol"));
        }
        String url = GithubUrlUtil.removeTrailingSlash(GithubUrlUtil.removeProtocolPrefix(urlFromSettings.toLowerCase()));
        String API_PREFIX = "api.";
        String ENTERPRISE_API_SUFFIX = "/api/v3";
        if (url.equals("github.com")) {
            String string = "api." + url;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getApiUrlWithoutProtocol"));
            }
            return string;
        }
        if (url.equals("api.github.com")) {
            String string = url;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getApiUrlWithoutProtocol"));
            }
            return string;
        }
        if (url.endsWith("/api/v3")) {
            String string = url;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getApiUrlWithoutProtocol"));
            }
            return string;
        }
        String string = url + "/api/v3";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getApiUrlWithoutProtocol"));
        }
        return string;
    }

    public static boolean isGithubUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/plugins/github/util/GithubUrlUtil", "isGithubUrl"));
        }
        return GithubUrlUtil.isGithubUrl(url, GithubSettings.getInstance().getHost());
    }

    public static boolean isGithubUrl(@NotNull String url, @NotNull String host) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/plugins/github/util/GithubUrlUtil", "isGithubUrl"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/plugins/github/util/GithubUrlUtil", "isGithubUrl"));
        }
        host = GithubUrlUtil.getHostFromUrl(host);
        if (StringUtil.startsWithIgnoreCase((String)(url = GithubUrlUtil.removeProtocolPrefix(url)), (String)host)) {
            return url.length() <= host.length() || ":/".indexOf(url.charAt(host.length())) != -1;
        }
        return false;
    }

    @Nullable
    public static GithubFullPath getUserAndRepositoryFromRemoteUrl(@NotNull String remoteUrl) {
        if (remoteUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteUrl", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getUserAndRepositoryFromRemoteUrl"));
        }
        int index1 = (remoteUrl = GithubUrlUtil.removeProtocolPrefix(GithubUrlUtil.removeEndingDotGit(remoteUrl))).lastIndexOf(47);
        if (index1 == -1) {
            return null;
        }
        String url = remoteUrl.substring(0, index1);
        int index2 = Math.max(url.lastIndexOf(47), url.lastIndexOf(58));
        if (index2 == -1) {
            return null;
        }
        String username = remoteUrl.substring(index2 + 1, index1);
        String reponame = remoteUrl.substring(index1 + 1);
        if (username.isEmpty() || reponame.isEmpty()) {
            return null;
        }
        return new GithubFullPath(username, reponame);
    }

    @Nullable
    public static String makeGithubRepoUrlFromRemoteUrl(@NotNull String remoteUrl) {
        if (remoteUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteUrl", "org/jetbrains/plugins/github/util/GithubUrlUtil", "makeGithubRepoUrlFromRemoteUrl"));
        }
        return GithubUrlUtil.makeGithubRepoUrlFromRemoteUrl(remoteUrl, GithubUrlUtil.getGithubHost());
    }

    @Nullable
    public static String makeGithubRepoUrlFromRemoteUrl(@NotNull String remoteUrl, @NotNull String host) {
        if (remoteUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteUrl", "org/jetbrains/plugins/github/util/GithubUrlUtil", "makeGithubRepoUrlFromRemoteUrl"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/plugins/github/util/GithubUrlUtil", "makeGithubRepoUrlFromRemoteUrl"));
        }
        GithubFullPath repo = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remoteUrl);
        if (repo == null) {
            return null;
        }
        return host + '/' + repo.getUser() + '/' + repo.getRepository();
    }

    @NotNull
    private static String removeEndingDotGit(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/plugins/github/util/GithubUrlUtil", "removeEndingDotGit"));
        }
        url = GithubUrlUtil.removeTrailingSlash(url);
        String DOT_GIT = ".git";
        if (url.endsWith(".git")) {
            String string = url.substring(0, url.length() - ".git".length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "removeEndingDotGit"));
            }
            return string;
        }
        String string = url;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "removeEndingDotGit"));
        }
        return string;
    }

    @NotNull
    public static String getCloneUrl(@NotNull GithubFullPath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getCloneUrl"));
        }
        String string = GithubUrlUtil.getCloneUrl(path.getUser(), path.getRepository());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getCloneUrl"));
        }
        return string;
    }

    @NotNull
    public static String getCloneUrl(@NotNull String user, @NotNull String repo) {
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getCloneUrl"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getCloneUrl"));
        }
        if (GithubSettings.getInstance().isCloneGitUsingSsh()) {
            String string = "git@" + GithubUrlUtil.getGitHostWithoutProtocol() + ":" + user + "/" + repo + ".git";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getCloneUrl"));
            }
            return string;
        }
        String string = GithubUrlUtil.getApiProtocol() + GithubUrlUtil.getGitHostWithoutProtocol() + "/" + user + "/" + repo + ".git";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/GithubUrlUtil", "getCloneUrl"));
        }
        return string;
    }
}

