/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DeploymentServersUsagesCollector
extends AbstractApplicationUsagesCollector {
    private static final String GROUP_ID = "deployment server";

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)GROUP_ID, (double)0.0);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/DeploymentServersUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/DeploymentServersUsagesCollector", "getProjectUsages"));
        }
        List<WebServerConfig> servers = WebServersConfigManager.getInstance(project).getServers(false);
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        HashSet<String> accessTypes = new HashSet<String>();
        for (WebServerConfig server : servers) {
            if (!server.isUsedInProject(project, publishConfig, false)) continue;
            accessTypes.add(server.getFileTransferConfig().getAccessType().name());
        }
        Set set = ContainerUtil.map2Set(accessTypes, (Function)new Function<String, UsageDescriptor>(){

            public UsageDescriptor fun(String s) {
                return new UsageDescriptor(s, 1);
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/DeploymentServersUsagesCollector", "getProjectUsages"));
        }
        return set;
    }
}

