/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;
import com.jetbrains.plugins.webDeployment.ui.WebServerToolWindowFactory;
import com.jetbrains.plugins.webDeployment.ui.WebServerToolWindowPanel;
import org.jetbrains.annotations.Nullable;

public class RemoteHostSelectInTarget
implements SelectInTarget,
DumbAware {
    public boolean canSelect(SelectInContext context) {
        if (context.getVirtualFile() instanceof RemoteVirtualFile) {
            return true;
        }
        return RemoteHostSelectInTarget.findDeployPath(context) != null;
    }

    public String toString() {
        return WDBundle.message("web.server.browser", new Object[0]);
    }

    @Nullable
    private static WebServerConfig.RemotePath findDeployPath(SelectInContext context) {
        return PublishActionUtil.findDeployPathFor(context.getVirtualFile(), context.getProject(), true);
    }

    public void selectIn(final SelectInContext context, boolean requestFocus) {
        String serverId;
        WebServerConfig.RemotePath deployPath;
        VirtualFile file = context.getVirtualFile();
        if (file instanceof RemoteVirtualFile) {
            RemoteVirtualFile remoteVirtualFile = (RemoteVirtualFile)file;
            deployPath = remoteVirtualFile.getRemotePath();
            serverId = remoteVirtualFile.getServerConfig().getId();
        } else {
            serverId = (String)PublishConfig.getInstance(context.getProject()).getDefaultServerIdAndName().getFirst();
            deployPath = RemoteHostSelectInTarget.findDeployPath(context);
        }
        if (serverId == null || deployPath == null) {
            return;
        }
        final ToolWindow toolWindow = WebServerToolWindowFactory.getInstance().getWebServerToolWindow(context.getProject());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WebServerToolWindowPanel view;
                Content content = toolWindow == null ? null : toolWindow.getContentManager().getContent(0);
                WebServerToolWindowPanel webServerToolWindowPanel = view = content == null ? null : (WebServerToolWindowPanel)((Object)content.getComponent());
                if (view == null) {
                    return;
                }
                view.selectInServer(context.getProject(), serverId, deployPath);
            }
        };
        if (requestFocus) {
            toolWindow.activate(runnable);
        } else {
            runnable.run();
        }
    }

    public String getToolWindowId() {
        return WebServerToolWindowFactory.SERVER_BROWSER_TOOLWINDOW;
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 2.0f;
    }
}

