/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.plugins.webDeployment.AutoUploadComponent;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.UploadBeforeRunTask;
import com.jetbrains.plugins.webDeployment.UploadableRunConfigurationsFilter;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.ui.DeploymentNotifier;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import com.jetbrains.plugins.webDeployment.ui.UploadBeforeRunTaskDialog;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UploadBeforeRunTaskProvider
extends BeforeRunTaskProvider<UploadBeforeRunTask> {
    private static final Logger LOG = Logger.getInstance((String)UploadBeforeRunTaskProvider.class.getName());
    public static final Key<UploadBeforeRunTask> ID = Key.create((String)"FtpUpload");

    public Key<UploadBeforeRunTask> getId() {
        return ID;
    }

    public String getName() {
        return WDBundle.message("upload.before.run.step.description", WDBundle.message("web.server.capitalized", new Object[0]));
    }

    public String getDescription(UploadBeforeRunTask task) {
        String serverName = task.getServerName();
        if (!StringUtil.isEmpty((String)serverName)) {
            return WDBundle.message("upload.before.run.step.description", serverName);
        }
        return WDBundle.message("upload.before.run.step.description", WDBundle.message("web.server.capitalized", new Object[0]));
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public UploadBeforeRunTask createTask(RunConfiguration runConfiguration) {
        for (UploadableRunConfigurationsFilter filter : (UploadableRunConfigurationsFilter[])UploadableRunConfigurationsFilter.EP_NAME.getExtensions()) {
            if (!filter.isUploadBeforeRunEnabled(runConfiguration)) continue;
            return new UploadBeforeRunTask();
        }
        return null;
    }

    public boolean configureTask(RunConfiguration runConfiguration, UploadBeforeRunTask task) {
        UploadBeforeRunTaskDialog d = new UploadBeforeRunTaskDialog(runConfiguration.getProject(), task);
        return d.showAndGet();
    }

    public boolean canExecuteTask(RunConfiguration configuration, UploadBeforeRunTask task) {
        return !task.getRoots().isEmpty() && task.getServerId() != null && task.getServerName() != null;
    }

    public boolean executeTask(final DataContext context, final RunConfiguration configuration, ExecutionEnvironment env, final UploadBeforeRunTask task) {
        final Semaphore done = new Semaphore();
        final Ref result = new Ref((Object)false);
        try {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Project project = (Project)CommonDataKeys.PROJECT.getData(context);
                    if (project == null || project.isDisposed() || project.isDefault()) {
                        return;
                    }
                    PublishConfig publishConfig = PublishConfig.getInstance(project);
                    Pair serverIdAndName = Pair.create((Object)task.getServerId(), (Object)task.getServerName());
                    LOG.assertTrue(serverIdAndName != null);
                    if (StringUtil.isEmpty((String)((String)serverIdAndName.first)) && StringUtil.isEmpty((String)((String)serverIdAndName.second))) {
                        UploadBeforeRunTaskProvider.report(project, null, WDBundle.message("server.is.not.specified", new Object[0]), true);
                        return;
                    }
                    WebServerConfig server = WebServersConfigManager.getInstance(project).findServer((String)serverIdAndName.first);
                    if (server == null) {
                        UploadBeforeRunTaskProvider.report(project, null, WDBundle.message("server.not.exists", serverIdAndName.second), true);
                        return;
                    }
                    String error = server.validateFast();
                    if (error != null) {
                        UploadBeforeRunTaskProvider.report(project, null, WDBundle.message("server.invalid", server.getName(), error), true);
                        return;
                    }
                    if (!server.needsTransfer()) {
                        UploadBeforeRunTaskProvider.report(project, null, WDBundle.message("server.is.local", server.getName()), false);
                        result.set((Object)true);
                        return;
                    }
                    ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(task.getRoots().size());
                    for (String path : task.getRoots()) {
                        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
                        if (file == null || !file.isValid()) continue;
                        files.add(file);
                    }
                    VfsUtilCore.DistinctVFilesRootsCollection roots = new VfsUtilCore.DistinctVFilesRootsCollection(files);
                    AutoUploadComponent.saveDocumentsSilently(project, (Collection<VirtualFile>)roots);
                    FileTransferToolWindow.printWithTimestamp(project, server, WDBundle.message("upload.on.run", server.getName(), configuration.getName()), ConsoleViewContentType.SYSTEM_OUTPUT, publishConfig.getTraceLevel());
                    done.down();
                    new TransferTask.ListBased(project, ConnectionOwnerFactory.createConnectionOwner(project), true, publishConfig, server, WDBundle.message("upload.to", server.getName()), true, true, true, ProjectDeploymentRevisionTracker.getInstance(project), (Collection)roots){
                        final /* synthetic */ Collection val$roots;
                        {
                            this.val$roots = collection;
                            super(project, connectionOwner, serverSideModification, publishConfig, serverConfig, title, updateLocalHistory, background, cancellable, revisionTracker);
                        }

                        @Override
                        public void run(@NotNull ProgressIndicator pi) {
                            if (pi == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/UploadBeforeRunTaskProvider$1$1", "run"));
                            }
                            try {
                                result.set((Object)this.doRun(pi));
                            }
                            finally {
                                done.up();
                            }
                        }

                        @Override
                        protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                            return PublishActionUtil.scanFiles(context, this.val$roots);
                        }
                    }.queue();
                }
            }, ModalityState.NON_MODAL);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return false;
        }
        done.waitFor();
        return (Boolean)result.get();
    }

    private static void report(final Project project, @Nullable WebServerConfig server, final String message, final boolean error) {
        FileTransferToolWindow.printWithTimestamp(project, server, message, error ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.SYSTEM_OUTPUT);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                DeploymentNotifier.notifyWithBalloon(null, message, error ? NotificationType.ERROR : NotificationType.WARNING, null, project, FileTransferToolWindow.ID_PROVIDER);
            }
        });
    }
}

