/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.sftp.SftpAdvancedOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class WebServersConfigManagerBaseImpl<T extends State>
implements PersistentStateComponent<T> {
    protected T myState = this.createState();
    private final boolean isProjectLevel;
    private List<Listener> myListeners = new SmartList();

    public WebServersConfigManagerBaseImpl(boolean level) {
        this.isProjectLevel = level;
    }

    protected abstract T createState();

    @Deprecated
    public T getState() {
        T state = this.createState();
        for (WebServerConfig server : ((State)this.myState).servers) {
            WebServerConfig clone = server.clone();
            clone.setIsProjectLevel(false);
            ((State)state).servers.add(clone);
        }
        return state;
    }

    public void loadState(T state) {
        this.myState = state;
        for (WebServerConfig server : ((State)this.myState).servers) {
            if (StringUtil.isEmpty((String)server.getId())) {
                server.setId(WebServerConfig.getNextId());
            }
            server.setIsProjectLevel(this.isProjectLevel);
        }
        WebServerConfig.fixDuplicatingNames(((State)this.myState).servers);
        this.fireServersLoaded();
    }

    private void fireServersLoaded() {
        for (Listener listener : this.myListeners) {
            listener.serversLoaded();
        }
    }

    public void addListener(Listener listener, Disposable parentDisposable) {
        ContainerUtil.add((Object)listener, this.myListeners, (Disposable)parentDisposable);
    }

    static interface Listener {
        public void serversLoaded();
    }

    @com.intellij.openapi.components.State(name="WebServers", storages={@Storage(value="webServers.xml")})
    public static class App
    extends WebServersConfigManagerBaseImpl<AppState>
    implements ExportableComponent {
        public App() {
            super(false);
        }

        @Override
        protected AppState createState() {
            return new AppState();
        }

        @Override
        public AppState getState() {
            AppState state = (AppState)super.getState();
            state.mySftpAdvancedOptions = ((AppState)this.myState).mySftpAdvancedOptions.clone();
            return state;
        }

        @NotNull
        public SftpAdvancedOptions getSftpAdvancedOptions() {
            SftpAdvancedOptions sftpAdvancedOptions = ((AppState)this.myState).mySftpAdvancedOptions.clone();
            if (sftpAdvancedOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$App", "getSftpAdvancedOptions"));
            }
            return sftpAdvancedOptions;
        }

        public void setSftpAdvancedOptions(@NotNull SftpAdvancedOptions options) {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$App", "setSftpAdvancedOptions"));
            }
            ((AppState)this.myState).mySftpAdvancedOptions = options.clone();
        }

        @NotNull
        public File[] getExportFiles() {
            File[] fileArray = new File[]{PathManager.getOptionsFile((String)"webServers")};
            if (fileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$App", "getExportFiles"));
            }
            return fileArray;
        }

        @NotNull
        public String getPresentableName() {
            String string = WDBundle.message("web.servers.exportable.component.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$App", "getPresentableName"));
            }
            return string;
        }
    }

    public static class AppState
    extends State {
        @Tag(value="sftpAdvancedGlobalOptions")
        public SftpAdvancedOptions mySftpAdvancedOptions = new SftpAdvancedOptions();
    }

    @com.intellij.openapi.components.State(name="WebServers", storages={@Storage(value="webServers.xml")})
    public static class Project
    extends WebServersConfigManagerBaseImpl<State> {
        public Project() {
            super(true);
        }

        @Override
        protected State createState() {
            return new State();
        }
    }

    public static class State {
        @AbstractCollection(surroundWithTag=false)
        public List<WebServerConfig> servers = new ArrayList<WebServerConfig>();
    }
}

