/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.jetbrains.plugins.webDeployment.WDBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentNotifier {
    private static final String WEB_DEPLOYMENT_BALLOON_GROUP = WDBundle.message("web.deployment.balloon.group.id", new Object[0]);
    private static final NotificationGroup BALLOON_GROUP = NotificationGroup.balloonGroup((String)WEB_DEPLOYMENT_BALLOON_GROUP);

    private DeploymentNotifier() {
    }

    public static void notifyWithBalloon(final @Nullable String title, final String message, final NotificationType messageType, final @Nullable NotificationListener listener, final Project project, final @Nullable ToolWindowIdProvider toolWindowIdProvider) {
        ToolWindow toolWindow = null;
        if (toolWindowIdProvider != null && project != null && !project.isDefault()) {
            ToolWindowManager mgr = ToolWindowManager.getInstance((Project)project);
            toolWindow = mgr.getToolWindow(toolWindowIdProvider.getId());
        }
        if (toolWindow == null) {
            BALLOON_GROUP.createNotification(StringUtil.notNullize((String)title), message, messageType, listener).notify(project);
            return;
        }
        ToolWindowManager.getInstance((Project)project).invokeLater(new Runnable(){

            @Override
            public void run() {
                toolWindowIdProvider.getGroup().createNotification(StringUtil.notNullize((String)title), message, messageType, listener).notify(project);
            }
        });
    }

    public static class ToolWindowIdProvider {
        private final NotificationGroup myGroup;
        @NotNull
        private final String myId;

        public ToolWindowIdProvider(@NotNull String toolWindowId) {
            if (toolWindowId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/jetbrains/plugins/webDeployment/ui/DeploymentNotifier$ToolWindowIdProvider", "<init>"));
            }
            this.myId = toolWindowId;
            this.myGroup = NotificationGroup.toolWindowGroup((String)(WEB_DEPLOYMENT_BALLOON_GROUP + ": " + toolWindowId), (String)toolWindowId, (boolean)false);
        }

        @NotNull
        public String getId() {
            String string = this.myId;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/DeploymentNotifier$ToolWindowIdProvider", "getId"));
            }
            return string;
        }

        public NotificationGroup getGroup() {
            return this.myGroup;
        }
    }
}

