/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.remotebrowser;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.PlatformIcons;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.DeploymentNotifier;
import com.jetbrains.plugins.webDeployment.ui.UiConstants;
import com.jetbrains.plugins.webDeployment.ui.WebServerToolWindowFactory;
import com.jetbrains.plugins.webDeployment.ui.auth.AuthHelper;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ErrorTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.FileAttributes;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeContext;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeViewOptions;
import java.awt.Color;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import javax.swing.event.HyperlinkEvent;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerTreeNode
extends SimpleNode {
    private static final Logger LOG = Logger.getInstance((String)ServerTreeNode.class.getName());
    private static final String SPACER = "    ";
    @Nullable
    private FileObject myFile;
    @Nullable
    private final FileAttributes myAttrs;
    @NotNull
    private final WebServerConfig.RemotePath myPath;
    @NotNull
    private final FileType myFileType;
    private final boolean myIsLink;
    @NotNull
    private final ServerTreeContext myTreeContext;
    private final boolean myIsUnderMapping;

    public ServerTreeNode(@Nullable Project project, @NotNull ConnectionOwner connectionOwner, WebServerConfig serverConfig, @Nullable PublishConfig publishConfig, boolean foldersOnly, FileTransferConfig.Origin originOption, @NotNull ServerTreeViewOptions viewOptions) {
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/ServerTreeNode", "<init>"));
        }
        if (viewOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewOptions", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/ServerTreeNode", "<init>"));
        }
        super(project);
        LOG.assertTrue(serverConfig.needsTransfer());
        this.myTreeContext = new ServerTreeContext(foldersOnly, serverConfig, publishConfig, viewOptions, originOption, connectionOwner);
        this.myFile = null;
        this.myAttrs = null;
        this.myPath = serverConfig.getRootPath();
        this.myFileType = FileType.FOLDER;
        this.myIsLink = false;
        this.myIsUnderMapping = this.myTreeContext.isUnderMapping(this.myPath);
    }

    private ServerTreeNode(ServerTreeNode parent, WebServerConfig.RemotePath path, ServerTreeContext treeContext) {
        super((SimpleNode)parent);
        this.myTreeContext = treeContext;
        this.myFile = null;
        this.myAttrs = null;
        this.myPath = path;
        this.myFileType = FileType.FOLDER;
        this.myIsLink = false;
        this.myIsUnderMapping = false;
    }

    protected ServerTreeNode(ServerTreeNode parent, @NotNull FileObject file, FileType fileType, @NotNull ServerTreeContext treeContext) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/ServerTreeNode", "<init>"));
        }
        if (treeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeContext", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/ServerTreeNode", "<init>"));
        }
        super((SimpleNode)parent);
        this.myTreeContext = treeContext;
        this.myPath = treeContext.myServer.getRemotePath(file);
        this.myFile = file;
        this.myFileType = fileType;
        this.myAttrs = FileAttributes.createFor(file, treeContext.myServer.getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps() == AdvancedOptionsConfig.AccurateTimestamps.ALWAYS);
        this.myIsLink = ServerTreeNode.isSymbolicLink(file);
        this.myIsUnderMapping = treeContext.isUnderMapping(this.myPath);
    }

    public static FileType getFileType(FileObject file) {
        try {
            return file.getType();
        }
        catch (FileSystemException e) {
            LOG.warn((Throwable)e);
            return FileType.IMAGINARY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleNode[] getChildren() {
        FileObject[] children;
        if (this.myFileType != FileType.FOLDER) {
            return NO_CHILDREN;
        }
        FileObject file = this.myFile;
        if (file == null) {
            try {
                file = this.computeFile();
            }
            catch (FileSystemException e) {
                return new SimpleNode[]{new ErrorTreeNode(this, PublishUtils.getMessage(e, false))};
            }
            if (file == null) {
                return NO_CHILDREN;
            }
            ServerTreeNode e = this;
            synchronized (e) {
                this.myFile = file;
            }
        }
        try {
            children = ServerTreeNode.getChildren(file, this.myTreeContext.myServer, new ThrowableComputable<RemoteConnection, FileSystemException>(){

                public RemoteConnection compute() throws FileSystemException {
                    return ServerTreeNode.this.myTreeContext.getConnection();
                }
            });
        }
        catch (CustomFileSystemException e) {
            return new SimpleNode[]{new ErrorTreeNode(this, e.getMessage())};
        }
        if (children.length == 0) {
            return NO_CHILDREN;
        }
        final ArrayList result = new ArrayList();
        for (final FileObject child : children) {
            if (this.myTreeContext.isHidden(child.getName())) continue;
            RemoteConnection connection = this.myTreeContext.getOpenConnection();
            LOG.assertTrue(connection != null);
            connection.executeServerOperation(new Runnable(){

                @Override
                public void run() {
                    FileType childType = ServerTreeNode.getFileType(child);
                    if (!((ServerTreeNode)ServerTreeNode.this).myTreeContext.myFoldersOnly || childType == FileType.FOLDER) {
                        result.add(new ServerTreeNode(ServerTreeNode.this, child, childType, ServerTreeNode.this.myTreeContext));
                    }
                }
            }, null);
        }
        return result.toArray(new SimpleNode[result.size()]);
    }

    public static FileObject[] getChildren(final FileObject file_, WebServerConfig server, ThrowableComputable<RemoteConnection, FileSystemException> connectionProvider) throws CustomFileSystemException {
        try {
            RemoteConnection connection = (RemoteConnection)connectionProvider.compute();
            if (connection == null) {
                return DeploymentPathUtils.NO_CHILDREN;
            }
            return connection.executeServerOperation(new ThrowableComputable<FileObject[], FileSystemException>(){

                public FileObject[] compute() throws FileSystemException {
                    return DeploymentPathUtils.getChildren(file_);
                }
            }, null);
        }
        catch (FileNotFolderException ignored) {
            String serverProblem;
            String message = WDBundle.message("error.getting.children", new Object[0]);
            try {
                serverProblem = server.getFileTransferConfig().validateSlow(-1L);
            }
            catch (TimeoutException e1) {
                LOG.error((Throwable)e1);
                serverProblem = null;
            }
            if (serverProblem != null) {
                message = serverProblem;
            }
            throw new CustomFileSystemException(message);
        }
        catch (FileSystemException e) {
            LOG.warn((Throwable)e);
            throw new CustomFileSystemException(StringUtil.capitalize((String)PublishUtils.getMessage(e, false)));
        }
    }

    @Nullable
    private FileObject computeFile() throws FileSystemException {
        String serverProblem;
        try {
            serverProblem = this.myTreeContext.myServer.getFileTransferConfig().validateSlow(-1L);
        }
        catch (TimeoutException e) {
            LOG.error((Throwable)e);
            serverProblem = null;
        }
        if (serverProblem != null) {
            throw new CustomFileSystemException(serverProblem);
        }
        if (this.myTreeContext.myServer.getFileTransferConfig().getAccessType().isProtocolBased() && !AuthHelper.hasPassword(false, this.myTreeContext.myServer.getFileTransferConfig())) {
            if (this.myProject != null && !this.myProject.isDefault()) {
                DeploymentNotifier.notifyWithBalloon(WDBundle.message("failed.to.connect.to.0", this.myTreeContext.myServer.getName()), WDBundle.message("no.authentication.data.provided.set.it.up.here", new Object[0]), NotificationType.WARNING, (NotificationListener)new NotificationListener.Adapter(){

                    protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                        if (notification == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/ServerTreeNode$4", "hyperlinkActivated"));
                        }
                        if (event == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/ServerTreeNode$4", "hyperlinkActivated"));
                        }
                        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                            @Override
                            public void run() {
                                boolean auth = AuthHelper.ensureAuthSpecified(ServerTreeNode.this.myProject, ((ServerTreeNode)ServerTreeNode.this).myTreeContext.myServer, ((ServerTreeNode)ServerTreeNode.this).myTreeContext.myConnectionOwner);
                                if (auth) {
                                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((DeploymentConfigChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).deploymentConfigChanged();
                                        }
                                    });
                                }
                            }
                        });
                    }
                }, this.myProject, WebServerToolWindowFactory.SERVER_BROWSER_TOOLWINDOW_ID_PROVIDER);
            }
            throw new CustomFileSystemException(StringUtil.capitalize((String)WDBundle.message("no.authentication.data.provided", new Object[0])));
        }
        try {
            RemoteConnection connection = this.myTreeContext.getConnection();
            return connection != null ? connection.resolveRoot() : null;
        }
        catch (FileSystemException e) {
            LOG.warn((Throwable)e);
            if (PublishUtils.isAuthFail(e)) {
                PublishUtils.clearPasswordIfNotStored(this.myTreeContext.myServer.getFileTransferConfig());
            }
            throw e;
        }
    }

    @Nullable
    public FileObject getFileObject() {
        return this.myFile;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myFileType;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/ServerTreeNode", "getFileType"));
        }
        return fileType;
    }

    @NotNull
    public ServerTreeContext getTreeContext() {
        ServerTreeContext serverTreeContext = this.myTreeContext;
        if (serverTreeContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/ServerTreeNode", "getTreeContext"));
        }
        return serverTreeContext;
    }

    public SimpleTextAttributes getNameAttributes() {
        if (this.myFileType == FileType.IMAGINARY) {
            return UiConstants.NodeAttributes.IMAGINARY;
        }
        Color fgColor = this.myTreeContext.myViewOptions.isHighlightSymlinks() && this.isSymlink() ? UiConstants.NodeAttributes.SYMLINK_FOREGROUND : this.getColor();
        Color bgColor = this.myTreeContext.myViewOptions.isHighlightMappings() && this.myIsUnderMapping ? UiConstants.NodeAttributes.MAPPED_BACKGROUND : null;
        return new SimpleTextAttributes(bgColor, fgColor, null, 0);
    }

    protected void update(PresentationData presentation) {
        if (this.isRoot()) {
            WebServerConfig server = this.myTreeContext.myServer;
            String label = server.getFileTransferConfig().getAccessType().isProtocolBased() ? (this.myTreeContext.myOrigin != FileTransferConfig.Origin.ForceRoot && !server.isDefaultRootFolder() ? MessageFormat.format("{0} ({1}{2})", server.getName(), server.getFileTransferConfig().getHost(), server.getFileTransferConfig().getRootFolder()) : MessageFormat.format("{0} ({1})", server.getName(), server.getFileTransferConfig().getHost())) : MessageFormat.format("{0} ({1})", server.getName(), server.getFileTransferConfig().getMountedFolder());
            presentation.addText(label, this.getNameAttributes());
            presentation.setIcon(server.getFileTransferConfig().getIcon());
        } else {
            if (this.myFileType == FileType.FOLDER) {
                presentation.setIcon(PlatformIcons.DIRECTORY_CLOSED_ICON);
            } else {
                presentation.setIcon(FileTypeManager.getInstance().getFileTypeByFileName(this.getFileName()).getIcon());
            }
            presentation.addText(this.getFileName(), this.getNameAttributes());
            if (this.myAttrs != null && this.myAttrs.getErrorMessage() == null) {
                String s;
                boolean alternative = true;
                if (!this.isDirectory() && this.myTreeContext.myViewOptions.isShowSize()) {
                    presentation.addText(SPACER + this.myAttrs.getFormattedSize(), UiConstants.NodeAttributes.ALTERNATIVE);
                    boolean bl = alternative = !alternative;
                }
                if (!this.isDirectory() && this.myTreeContext.myViewOptions.isShowTimestamp()) {
                    presentation.addText(SPACER + this.myAttrs.getFormattedLastModified(), alternative ? UiConstants.NodeAttributes.ALTERNATIVE : this.getPlainAttributes());
                    boolean bl = alternative = !alternative;
                }
                if (this.myTreeContext.myViewOptions.isShowPermissions() && (s = this.myAttrs.getPermissionsString(this.myTreeContext.myViewOptions.isShowPermissionsAsNumber())).length() > 0) {
                    presentation.addText(SPACER + s, alternative ? UiConstants.NodeAttributes.ALTERNATIVE : this.getPlainAttributes());
                }
            }
        }
    }

    public boolean isDirectory() {
        return this.myFileType == FileType.FOLDER;
    }

    public boolean isRoot() {
        return this.myPath.equals(this.myTreeContext.myServer.getRootPath());
    }

    private boolean isSymlink() {
        return this.myIsLink;
    }

    @NotNull
    public WebServerConfig.RemotePath getPath() {
        WebServerConfig.RemotePath remotePath = this.myPath;
        if (remotePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/ServerTreeNode", "getPath"));
        }
        return remotePath;
    }

    private ServerTreeNode createFakeChild(String name) {
        String chidPath = DeploymentPathUtils.join(this.myPath.path, name, this.myTreeContext.myServer.getFileTransferConfig().getAccessType().isProtocolBased() ? (char)'/' : (char)File.separatorChar);
        return new ServerTreeNode(this, new WebServerConfig.RemotePath(chidPath), this.myTreeContext);
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myPath};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/ServerTreeNode", "getEqualityObjects"));
        }
        return objectArray;
    }

    @NotNull
    public String getFileName() {
        String string = this.myFile != null ? this.myFile.getName().getBaseName() : "/";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/ServerTreeNode", "getFileName"));
        }
        return string;
    }

    private static boolean isSymbolicLink(FileObject file) {
        try {
            return file.isSymbolicLink();
        }
        catch (FileSystemException ignored) {
            return false;
        }
    }

    @Nullable
    public ServerTreeNode createForSelection(WebServerConfig.RemotePath path) {
        String[] components;
        if (StringUtil.isEmpty((String)path.path)) {
            return this;
        }
        boolean caseSensitive = this.myTreeContext.myServer.getFileTransferConfig().getAccessType().isProtocolBased() ? this.myTreeContext.myServer.isCaseSensitive() : SystemInfo.isFileSystemCaseSensitive;
        String remainder = DeploymentPathUtils.getPathRemainder(this.myPath.path, path.path, caseSensitive);
        if (remainder == null) {
            return DeploymentPathUtils.getPathRemainder(path.path, this.myPath.path, caseSensitive) != null ? this : null;
        }
        if (remainder.length() == 0) {
            return this;
        }
        remainder = StringUtil.trimStart((String)remainder, (String)"/");
        ServerTreeNode result = this;
        for (String component : components = FileUtil.toSystemIndependentName((String)remainder).split("/")) {
            result = result.createFakeChild(component);
        }
        return result;
    }

    public void releaseConnection() {
        this.myTreeContext.releaseConnection();
    }

    @Nullable
    public RemoteConnection getOpenRemoteConnection() {
        return this.myTreeContext.getOpenConnection();
    }

    public synchronized void invalidate() {
        LOG.assertTrue(this.getParent() == null);
        this.myFile = null;
    }

    protected void postprocess(@NotNull PresentationData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/ServerTreeNode", "postprocess"));
        }
        super.postprocess(data);
        if (CopyPasteManager.getInstance().isCutElement((Object)this)) {
            Color fgColor = CopyPasteManager.CUT_COLOR;
            if (data.getForcedTextForeground() == null) {
                data.setForcedTextForeground(fgColor);
            }
        }
    }
}

