/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.remotebrowser;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ErrorTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd.MoveCopyPasteSupport;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebServerTreeBuilder
extends AbstractTreeBuilder {
    private static final Logger LOG = Logger.getInstance((String)WebServerTreeBuilder.class.getName());
    private static final Comparator<NodeDescriptor> COMPARATOR = new Comparator<NodeDescriptor>(){

        @Override
        public int compare(NodeDescriptor o1, NodeDescriptor o2) {
            if (o1 instanceof ErrorTreeNode) {
                return o2 instanceof ErrorTreeNode ? ((ErrorTreeNode)o1).getMessage().compareTo(((ErrorTreeNode)o2).getMessage()) : -1;
            }
            if (o2 instanceof ErrorTreeNode) {
                return 1;
            }
            ServerTreeNode n1 = (ServerTreeNode)o1;
            ServerTreeNode n2 = (ServerTreeNode)o2;
            if (n1.isDirectory() && !n2.isDirectory()) {
                return -1;
            }
            if (!n1.isDirectory() && n2.isDirectory()) {
                return 1;
            }
            return n1.getFileName().compareToIgnoreCase(n2.getFileName());
        }
    };

    public static WebServerTreeBuilder createInstance(@NotNull ServerTreeNode root, @NotNull JTree tree) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/WebServerTreeBuilder", "createInstance"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/WebServerTreeBuilder", "createInstance"));
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode((Object)root));
        tree.setModel(treeModel);
        tree.getSelectionModel().setSelectionMode(4);
        return new WebServerTreeBuilder(tree, treeModel, (AbstractTreeStructure)new SimpleTreeStructure.Impl(root){

            public boolean isToBuildChildrenInBackground(Object element) {
                return true;
            }

            public boolean isAlwaysLeaf(Object element) {
                if (element instanceof ServerTreeNode) {
                    return !((ServerTreeNode)((Object)element)).isDirectory();
                }
                LOG.assertTrue(element instanceof ErrorTreeNode);
                return true;
            }
        });
    }

    public WebServerTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure) {
        super(tree, treeModel, treeStructure, COMPARATOR);
        CopyPasteManager.getInstance().addContentChangedListener((CopyPasteManager.ContentChangedListener)new MoveCopyPasteSupport.RemoteHostCopyPasteListener(this.getUpdater(), tree), (Disposable)this);
    }

    protected void runBackgroundLoading(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/WebServerTreeBuilder", "runBackgroundLoading"));
        }
        if (this.isDisposed()) {
            return;
        }
        runnable.run();
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        if (nodeDescriptor instanceof ErrorTreeNode) {
            return true;
        }
        if (nodeDescriptor instanceof ServerTreeNode) {
            return !((ServerTreeNode)nodeDescriptor).isDirectory() || ((ServerTreeNode)nodeDescriptor).isRoot();
        }
        return false;
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor descriptor) {
        if (descriptor instanceof ServerTreeNode) {
            return ((ServerTreeNode)descriptor).isDirectory();
        }
        LOG.assertTrue(descriptor instanceof ErrorTreeNode);
        return false;
    }

    public void refreshSubtree(final Collection<WebServerConfig.RemotePath> roots, final boolean resync, final WebServerConfig.RemotePath selectAfterRefresh) {
        if (this.isDisposed()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (WebServerTreeBuilder.this.isDisposed()) {
                    return;
                }
                if (resync) {
                    try {
                        RemoteConnection connection = WebServerTreeBuilder.this.getRoot().getOpenRemoteConnection();
                        if (connection == null) {
                            return;
                        }
                        connection.executeServerOperation(new ThrowableRunnable<FileSystemException>(){

                            public void run() throws FileSystemException {
                                for (WebServerConfig.RemotePath root : roots) {
                                    ProgressManager.checkCanceled();
                                    ServerTreeNode node = WebServerTreeBuilder.this.findNode(root);
                                    if (node == null || node.getFileObject() == null) continue;
                                    node.getFileObject().refresh();
                                }
                            }
                        }, null);
                    }
                    catch (FileSystemException e) {
                        LOG.warn((Throwable)e);
                    }
                }
                ActionCallback callback = null;
                for (WebServerConfig.RemotePath root : roots) {
                    ProgressManager.checkCanceled();
                    ServerTreeNode toUpdate = WebServerTreeBuilder.this.getRoot().createForSelection(root);
                    if (toUpdate == null) {
                        return;
                    }
                    if (toUpdate.getParent() != null) {
                        toUpdate = (ServerTreeNode)toUpdate.getParent();
                    }
                    callback = WebServerTreeBuilder.this.queueUpdateFrom((Object)toUpdate, true);
                }
                if (selectAfterRefresh != null) {
                    if (callback != null) {
                        callback.doWhenDone(new Runnable(){

                            @Override
                            public void run() {
                                WebServerTreeBuilder.this.selectPath(selectAfterRefresh);
                            }
                        });
                    } else if (ApplicationManager.getApplication().isDispatchThread()) {
                        WebServerTreeBuilder.this.selectPath(selectAfterRefresh);
                    } else {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                WebServerTreeBuilder.this.selectPath(selectAfterRefresh);
                            }
                        });
                    }
                }
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().executeOnPooledThread(r);
        } else {
            r.run();
        }
    }

    @Nullable
    public ServerTreeNode findNode(WebServerConfig.RemotePath path) {
        Object node = this.findNodeByElement((Object)this.getRoot().createForSelection(path));
        return node instanceof DefaultMutableTreeNode ? (ServerTreeNode)((Object)((DefaultMutableTreeNode)node).getUserObject()) : null;
    }

    public void selectPath(WebServerConfig.RemotePath path) {
        if (this.isDisposed()) {
            return;
        }
        ServerTreeNode selection = this.getRoot().createForSelection(path);
        if (selection != null) {
            this.select((Object)selection);
        }
    }

    public ServerTreeNode getRoot() {
        return (ServerTreeNode)((Object)this.getTreeStructure().getRootElement());
    }
}

