/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.css.CssLanguageProperties;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssDescriptorOwner;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssExpression;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssImportList;
import com.intellij.psi.css.CssMedia;
import com.intellij.psi.css.CssMediaExpression;
import com.intellij.psi.css.CssMediaFeature;
import com.intellij.psi.css.CssMediaQuery;
import com.intellij.psi.css.CssMediumList;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssElementFactory {
    private final PsiManager myManager;

    public CssElementFactory(PsiManager _manager) {
        this.myManager = _manager;
    }

    public static CssElementFactory getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/CssElementFactory", "getInstance"));
        }
        return (CssElementFactory)ServiceManager.getService((Project)project, CssElementFactory.class);
    }

    @NotNull
    public CssString createString(char quoteChar, String value, @Nullable Language language) {
        String stringText = quoteChar + value + quoteChar;
        String declarationsTerminator = (language = CssElementFactory.getLanguage(language)) instanceof CssLanguageProperties ? ((CssLanguageProperties)language).getDeclarationsTerminator() : ";";
        String importText = "@import " + stringText + declarationsTerminator;
        CssStylesheet stylesheet = this.createStylesheet(importText, language);
        CssImport imports = (CssImport)PsiTreeUtil.findChildOfType((PsiElement)stylesheet, CssImport.class);
        CssString cssString = (CssString)PsiTreeUtil.getChildOfType((PsiElement)imports, CssString.class);
        if (cssString == null) {
            throw new IllegalArgumentException("Can't create css string with text: " + stringText);
        }
        CssString cssString2 = cssString;
        if (cssString2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createString"));
        }
        return cssString2;
    }

    @NotNull
    public PsiElement createStringToken(char quoteChar, String value, @Nullable Language language) {
        CssString string = this.createString(quoteChar, value, language);
        assert (string.getChildren().length > 0);
        PsiElement psiElement = string.getFirstChild();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createStringToken"));
        }
        return psiElement;
    }

    @NotNull
    public CssStylesheet createStylesheet(@NotNull String text, @Nullable Language language) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/css/CssElementFactory", "createStylesheet"));
        }
        language = CssElementFactory.getLanguage(language);
        PsiFile fileFromText = PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText("_dummy_", language, (CharSequence)text, false, true);
        if (!(fileFromText instanceof CssFile)) {
            throw new IllegalArgumentException("Can't create ruleset for given file type: " + fileFromText.getFileType().getName());
        }
        CssStylesheet stylesheet = ((CssFile)fileFromText).getStylesheet();
        if (stylesheet == null) {
            throw new IllegalArgumentException("Can't create css stylesheet from text: " + text);
        }
        CssStylesheet cssStylesheet = stylesheet;
        if (cssStylesheet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createStylesheet"));
        }
        return cssStylesheet;
    }

    @NotNull
    public CssRuleset createRuleset(@NotNull @NonNls String text, @Nullable Language language) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/css/CssElementFactory", "createRuleset"));
        }
        CssRuleset[] rulesets = this.createStylesheet(text, language).getRulesets();
        if (rulesets.length == 0) {
            throw new IllegalArgumentException("Can't create ruleset from text: " + text);
        }
        CssRuleset ruleset = rulesets[0];
        if (ruleset == null) {
            throw new IllegalArgumentException("Can't create ruleset from text: " + text);
        }
        CssRuleset cssRuleset = ruleset;
        if (cssRuleset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createRuleset"));
        }
        return cssRuleset;
    }

    @NotNull
    public CssRuleset createRuleset(@NotNull String selector, @NotNull CssDeclaration[] declarations, @Nullable Language language) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/psi/css/CssElementFactory", "createRuleset"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "com/intellij/psi/css/CssElementFactory", "createRuleset"));
        }
        language = CssElementFactory.getLanguage(language);
        String declarationsTerminator = CssPsiUtil.getDeclarationsTerminator(language);
        StringBuilder blockText = new StringBuilder();
        for (CssDeclaration declaration : declarations) {
            blockText.append("  ").append(declaration.getPropertyName()).append(": ");
            CssTermList declarationValue = declaration.getValue();
            if (declarationValue != null) {
                blockText.append(declarationValue.getText());
            }
            blockText.append(declarationsTerminator).append("\n");
        }
        CssRuleset cssRuleset = this.createRuleset(CssElementFactory.createRulesetText(selector, blockText, language).toString(), language);
        if (cssRuleset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createRuleset"));
        }
        return cssRuleset;
    }

    @NotNull
    public CssDeclaration[] createProperties(@NotNull String text, @Nullable Language language) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/css/CssElementFactory", "createProperties"));
        }
        StringBuilder rulesetText = CssElementFactory.createRulesetText("div", new StringBuilder(text), language);
        CssBlock block = this.createRuleset(rulesetText.toString(), language).getBlock();
        if (block == null) {
            throw new IllegalArgumentException("Can't create css declarations from text: " + text);
        }
        CssDeclaration[] cssDeclarationArray = block.getDeclarations();
        if (cssDeclarationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createProperties"));
        }
        return cssDeclarationArray;
    }

    @NotNull
    public CssDeclaration createProperty(@NotNull String propertyText, @Nullable Language language) {
        if (propertyText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyText", "com/intellij/psi/css/CssElementFactory", "createProperty"));
        }
        CssDeclaration[] properties = this.createProperties(propertyText, language);
        if (properties.length == 0) {
            throw new IllegalArgumentException("Can't create css property from text: " + propertyText);
        }
        CssDeclaration cssDeclaration = properties[0];
        if (cssDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createProperty"));
        }
        return cssDeclaration;
    }

    @NotNull
    public CssDeclaration createProperty(@NotNull String name, @NotNull String value, @Nullable Language language) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/CssElementFactory", "createProperty"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/CssElementFactory", "createProperty"));
        }
        CssDeclaration cssDeclaration = this.createProperty(name + ": " + value + CssPsiUtil.getDeclarationsTerminator(CssElementFactory.getLanguage(language)), language);
        if (cssDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createProperty"));
        }
        return cssDeclaration;
    }

    @Nullable
    public CssMedia createMedia(@NotNull String mediaQuery, @Nullable Language language) {
        if (mediaQuery == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mediaQuery", "com/intellij/psi/css/CssElementFactory", "createMedia"));
        }
        String mediaText = CssElementFactory.createRulesetText("@media " + mediaQuery + "{}", new StringBuilder(), language).toString();
        CssStylesheet stylesheet = this.createStylesheet(mediaText, language);
        for (CssAtRule rule : stylesheet.getRulesetList().getAtRules()) {
            if (!(rule instanceof CssMedia)) continue;
            return (CssMedia)rule;
        }
        return null;
    }

    @NotNull
    public CssMediaFeature createMediaFeature(@NotNull String name, @NotNull String value, @Nullable Language language) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/CssElementFactory", "createMediaFeature"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/CssElementFactory", "createMediaFeature"));
        }
        String mediaText = CssElementFactory.createRulesetText("@media screen and (" + name + ":" + value + ")", new StringBuilder(), language).toString();
        CssStylesheet stylesheet = this.createStylesheet(mediaText, language);
        for (CssAtRule rule : stylesheet.getRulesetList().getAtRules()) {
            CssMediaExpression mediaExpression;
            CssMediaFeature mediaFeature;
            CssMediaQuery mediaQuery;
            CssMediumList mediumList;
            if (!(rule instanceof CssMedia) || (mediumList = ((CssMedia)rule).getMediumList()) == null || (mediaQuery = (CssMediaQuery)ArrayUtil.getFirstElement((Object[])mediumList.getMediaQueries())) == null || (mediaFeature = (CssMediaFeature)PsiTreeUtil.getChildOfType((PsiElement)(mediaExpression = (CssMediaExpression)ArrayUtil.getFirstElement((Object[])mediaQuery.getExpressions())), CssMediaFeature.class)) == null) continue;
            CssMediaFeature cssMediaFeature = mediaFeature;
            if (cssMediaFeature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createMediaFeature"));
            }
            return cssMediaFeature;
        }
        throw new IllegalArgumentException("Can't create css media feature: " + mediaText);
    }

    @NotNull
    public CssTermList createPropertyValue(@NotNull String value, @Nullable Language language) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/CssElementFactory", "createPropertyValue"));
        }
        CssTermList propertyValue = this.createProperty("width", value, language).getValue();
        if (propertyValue == null) {
            throw new IllegalArgumentException("Can't create css property value: " + value);
        }
        CssTermList cssTermList = propertyValue;
        if (cssTermList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createPropertyValue"));
        }
        return cssTermList;
    }

    @NotNull
    public CssDescriptorOwner createFunction(@NotNull String name, @Nullable Language language) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/CssElementFactory", "createFunction"));
        }
        CssTerm term = this.createTerm(name + "(param)", language);
        CssFunction function = (CssFunction)PsiTreeUtil.findChildOfType((PsiElement)term, CssFunction.class);
        if (function == null) {
            throw new IllegalArgumentException("Can't create css function with name: " + name);
        }
        CssFunction cssFunction = function;
        if (cssFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createFunction"));
        }
        return cssFunction;
    }

    @NotNull
    public CssTerm createTerm(@NotNull String value, @Nullable Language language) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/CssElementFactory", "createTerm"));
        }
        CssTermList propertyValue = this.createPropertyValue(value, language);
        CssTerm term = (CssTerm)PsiTreeUtil.findChildOfType((PsiElement)propertyValue, CssTerm.class);
        if (term == null) {
            throw new IllegalArgumentException("Can't create css term with value: " + value);
        }
        CssTerm cssTerm = term;
        if (cssTerm == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createTerm"));
        }
        return cssTerm;
    }

    @NotNull
    public CssElement createExpressionParameter(@NotNull String value, @Nullable Language language) {
        CssElement expressionParameter;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/CssElementFactory", "createExpressionParameter"));
        }
        CssTermList propertyValue = this.createPropertyValue("expression(" + value + ")", language);
        CssExpression expression = (CssExpression)PsiTreeUtil.findChildOfType((PsiElement)propertyValue, CssExpression.class);
        CssElement cssElement = expressionParameter = expression != null ? expression.getValueNode() : null;
        if (expressionParameter == null) {
            throw new IllegalArgumentException("Can't create css expression with value: " + value);
        }
        CssElement cssElement2 = expressionParameter;
        if (cssElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createExpressionParameter"));
        }
        return cssElement2;
    }

    @NotNull
    public CssPseudoSelector createPseudoSelector(String name, @Nullable Language language) {
        CssPseudoSelector cssPseudoSelector = this.createPseudoSelector(name, language, false);
        if (cssPseudoSelector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createPseudoSelector"));
        }
        return cssPseudoSelector;
    }

    @NotNull
    public CssPseudoSelector createPseudoSelector(String name, @Nullable Language language, boolean isEscaped) {
        assert (name.startsWith(":"));
        String selector = isEscaped ? "\\" + name : name;
        CssRuleset ruleset = this.createRuleset(CssElementFactory.createRulesetText(selector, new StringBuilder(), language).toString(), language);
        CssPseudoSelector pseudoSelector = (CssPseudoSelector)PsiTreeUtil.findChildOfType((PsiElement)ruleset, CssPseudoSelector.class);
        if (pseudoSelector == null) {
            throw new IllegalArgumentException("Can't create css pseudo selector from text: " + name);
        }
        CssPseudoSelector cssPseudoSelector = pseudoSelector;
        if (cssPseudoSelector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createPseudoSelector"));
        }
        return cssPseudoSelector;
    }

    @NotNull
    public CssSelectorList createSelectorList(@NotNull String text, @Nullable Language language) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/css/CssElementFactory", "createSelectorList"));
        }
        CssRuleset ruleset = this.createRuleset(CssElementFactory.createRulesetText(text, new StringBuilder(), language).toString(), language);
        CssSelectorList selectorList = (CssSelectorList)PsiTreeUtil.findChildOfType((PsiElement)ruleset, CssSelectorList.class);
        if (selectorList == null) {
            throw new IllegalArgumentException("Can't create css selector list from text: " + text);
        }
        CssSelectorList cssSelectorList = selectorList;
        if (cssSelectorList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createSelectorList"));
        }
        return cssSelectorList;
    }

    @NotNull
    public CssSimpleSelector createSimpleSelector(@NotNull String simpleSelectorText, @Nullable Language language) {
        if (simpleSelectorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleSelectorText", "com/intellij/psi/css/CssElementFactory", "createSimpleSelector"));
        }
        CssRuleset ruleset = this.createRuleset(simpleSelectorText + " {}", language);
        CssSimpleSelector simpleSelector = (CssSimpleSelector)PsiTreeUtil.findChildOfType((PsiElement)ruleset, CssSimpleSelector.class);
        if (simpleSelector == null) {
            throw new IllegalArgumentException("Can't create css simple selector from text: " + simpleSelectorText);
        }
        CssSimpleSelector cssSimpleSelector = simpleSelector;
        if (cssSimpleSelector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createSimpleSelector"));
        }
        return cssSimpleSelector;
    }

    @NotNull
    public CssImportList createImportList(@Nullable Language language, String ... imports) {
        String text = StringUtil.join((String[])imports, (String)CssPsiUtil.getDeclarationsTerminator(language));
        CssStylesheet stylesheet = this.createStylesheet(text, language);
        CssImportList importList = stylesheet.getImportList();
        if (importList == null) {
            throw new IllegalArgumentException("Can't create css import list from text: " + text);
        }
        CssImportList cssImportList = importList;
        if (cssImportList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createImportList"));
        }
        return cssImportList;
    }

    @NotNull
    public PsiElement createToken(@NotNull String text, @Nullable Language language) {
        PsiElement result;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/css/CssElementFactory", "createToken"));
        }
        language = CssElementFactory.getLanguage(language);
        PsiFile fileFromText = PsiFileFactory.getInstance((Project)this.myManager.getProject()).createFileFromText("_dummy_", language, (CharSequence)text, false, true);
        PsiElement leaf = PsiTreeUtil.getDeepestFirst((PsiElement)fileFromText);
        PsiElement psiElement = result = leaf instanceof PsiErrorElement ? PsiTreeUtil.nextVisibleLeaf((PsiElement)leaf) : leaf;
        if (result == null) {
            throw new IllegalArgumentException("Can't create css token from text: " + text);
        }
        PsiElement psiElement2 = result;
        if (psiElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createToken"));
        }
        return psiElement2;
    }

    @NotNull
    public CssUri createUri(String string, @Nullable Language language) {
        CssTermList termList = this.createPropertyValue("url(" + string + ")", language);
        CssUri cssUri = (CssUri)PsiTreeUtil.findChildOfType((PsiElement)termList, CssUri.class);
        if (cssUri == null) {
            throw new IllegalArgumentException("Can't create css uri with value: " + string);
        }
        CssUri cssUri2 = cssUri;
        if (cssUri2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createUri"));
        }
        return cssUri2;
    }

    @NotNull
    private static Language getLanguage(@Nullable Language language) {
        CSSLanguage cSSLanguage = language != null && language.isKindOf((Language)CSSLanguage.INSTANCE) ? language : CSSLanguage.INSTANCE;
        if (cSSLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "getLanguage"));
        }
        return cSSLanguage;
    }

    @NotNull
    private static StringBuilder createRulesetText(@NotNull String selector, @NotNull StringBuilder blockText, @Nullable Language language) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/psi/css/CssElementFactory", "createRulesetText"));
        }
        if (blockText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockText", "com/intellij/psi/css/CssElementFactory", "createRulesetText"));
        }
        boolean identBasedCssLanguage = CssPsiUtil.isIndentBasedCssLanguage(CssElementFactory.getLanguage(language));
        if (identBasedCssLanguage) {
            if (!blockText.toString().startsWith(" ")) {
                blockText.insert(0, "\n  ");
            } else {
                blockText.insert(0, '\n');
            }
        } else {
            blockText.insert(0, " {\n");
        }
        blockText.insert(0, selector);
        if (!identBasedCssLanguage) {
            blockText.append('}');
        }
        StringBuilder stringBuilder = blockText;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssElementFactory", "createRulesetText"));
        }
        return stringBuilder;
    }
}

