/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.actions;

import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.plugins.drools.DroolsBundle;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.hash.HashMap;
import icons.DroolsIcons;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CreateRuleFileAction
extends CreateFileAction {
    public CreateRuleFileAction() {
        super(DroolsBundle.message("rule.new.file", new Object[0]), DroolsBundle.message("rule.new.file.description", new Object[0]), DroolsIcons.Drools_16);
    }

    protected boolean isAvailable(DataContext dataContext) {
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        return module != null && JavaPsiFacade.getInstance((Project)module.getProject()).findPackage("org.drools") != null;
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)directory);
        assert (module != null) : directory;
        FileTemplate template = FileTemplateManager.getInstance((Project)module.getProject()).getJ2eeTemplate("drools.rule.drl");
        String fileName = this.getFileName(newName);
        HashMap proprs = new HashMap();
        proprs.put("RULE_NAME", FileUtil.getNameWithoutExtension((String)newName));
        PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Map)proprs, (PsiDirectory)directory, null);
        PsiElement[] psiElementArray = new PsiElement[]{psiElement};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/actions/CreateRuleFileAction", "create"));
        }
        return psiElementArray;
    }

    protected String getDefaultExtension() {
        return "drl";
    }
}

