/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.plugins.drools.lang.psi.DroolsAnnotation;
import com.intellij.plugins.drools.lang.psi.DroolsField;
import com.intellij.plugins.drools.lang.psi.DroolsPsiClass;
import com.intellij.plugins.drools.lang.psi.DroolsSuperType;
import com.intellij.plugins.drools.lang.psi.DroolsTypeDeclaration;
import com.intellij.plugins.drools.lang.psi.DroolsTypeName;
import com.intellij.plugins.drools.lang.psi.impl.DroolsPsiCompositeElementImpl;
import com.intellij.plugins.drools.lang.psi.util.DroolsElementsFactory;
import com.intellij.plugins.drools.lang.psi.util.DroolsResolveUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.light.JavaIdentifier;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DroolsPsiClassImpl
extends DroolsPsiCompositeElementImpl
implements DroolsPsiClass,
DroolsTypeDeclaration {
    public DroolsPsiClassImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "<init>"));
        }
        super(node);
    }

    public String getName() {
        return this.getQualifiedName();
    }

    @Nullable
    public String getQualifiedName() {
        return this.getTypeName().getText();
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAnnotationType() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    @Nullable
    public PsiReferenceList getExtendsList() {
        return null;
    }

    @Nullable
    public PsiReferenceList getImplementsList() {
        return null;
    }

    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        PsiClassType[] psiClassTypeArray;
        PsiClass superClass = this.getSuperClass();
        if (superClass == null) {
            psiClassTypeArray = PsiClassType.EMPTY_ARRAY;
        } else {
            PsiClassType[] psiClassTypeArray2 = new PsiClassType[1];
            psiClassTypeArray = psiClassTypeArray2;
            psiClassTypeArray2[0] = PsiTypesUtil.getClassType((PsiClass)superClass);
        }
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "getExtendsListTypes"));
        }
        return psiClassTypeArray;
    }

    @NotNull
    public PsiClassType[] getImplementsListTypes() {
        PsiClass aClass;
        if (this.isTraitable() && (aClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass("org.drools.core.factmodel.traits.Thing", this.getResolveScope())) != null) {
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{PsiTypesUtil.getClassType((PsiClass)aClass)};
            if (psiClassTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "getImplementsListTypes"));
            }
            return psiClassTypeArray;
        }
        PsiClassType[] psiClassTypeArray = new PsiClassType[]{};
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "getImplementsListTypes"));
        }
        return psiClassTypeArray;
    }

    @Nullable
    public PsiClass getSuperClass() {
        Set<PsiClass> psiClasses;
        DroolsSuperType superType = this.getSuperType();
        if (superType != null && (psiClasses = DroolsResolveUtil.resolveQualifiedIdentifier(superType.getQualifiedName().getQualifiedIdentifier())).size() > 0) {
            return psiClasses.iterator().next();
        }
        return null;
    }

    public PsiClass[] getInterfaces() {
        PsiClass aClass;
        if (this.isTraitable() && (aClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass("org.drools.core.factmodel.traits.Thing", this.getResolveScope())) != null) {
            return new PsiClass[]{aClass};
        }
        return new PsiClass[0];
    }

    @NotNull
    public PsiClass[] getSupers() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getSupers((PsiClass)this);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "getSupers"));
        }
        return psiClassArray;
    }

    @NotNull
    public PsiClassType[] getSuperTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getSuperTypes((PsiClass)this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "getSuperTypes"));
        }
        return psiClassTypeArray;
    }

    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = (PsiField[])this.findChildrenByClass(DroolsField.class);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "getFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        PsiField[] fields;
        HashSet generatedMethods = new HashSet();
        for (PsiField field : fields = this.getFields()) {
            generatedMethods.add(new GeneratedLightMethod(this.getManager(), PropertyUtil.generateGetterPrototype((PsiField)field), field));
            generatedMethods.add(new GeneratedLightMethod(this.getManager(), PropertyUtil.generateSetterPrototype((PsiField)field), field));
        }
        PsiMethod[] psiMethodArray = generatedMethods.toArray(new PsiMethod[generatedMethods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "getMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = new PsiMethod[]{};
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "getConstructors"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = new PsiClass[]{};
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "getInnerClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    public PsiClassInitializer[] getInitializers() {
        PsiClassInitializer[] psiClassInitializerArray = new PsiClassInitializer[]{};
        if (psiClassInitializerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "getInitializers"));
        }
        return psiClassInitializerArray;
    }

    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = PsiClassImplUtil.getAllFields((PsiClass)this);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "getAllFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.getAllMethods((PsiClass)this);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "getAllMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getAllInnerClasses() {
        PsiClass[] psiClassArray = new PsiClass[]{};
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "getAllInnerClasses"));
        }
        return psiClassArray;
    }

    @Nullable
    public PsiField findFieldByName(@NonNls String name, boolean checkBases) {
        return PsiClassImplUtil.findFieldByName((PsiClass)this, (String)name, (boolean)checkBases);
    }

    @Nullable
    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodBySignature((PsiClass)this, (PsiMethod)patternMethod, (boolean)checkBases);
    }

    @NotNull
    public PsiMethod[] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsBySignature((PsiClass)this, (PsiMethod)patternMethod, (boolean)checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "findMethodsBySignature"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findMethodsByName(@NonNls String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsByName((PsiClass)this, (String)name, (boolean)checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "findMethodsByName"));
        }
        return psiMethodArray;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(@NonNls String name, boolean checkBases) {
        List list = PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName((PsiClass)this, (String)name, (boolean)checkBases);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "findMethodsAndTheirSubstitutorsByName"));
        }
        return list;
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        List list = PsiClassImplUtil.getAllWithSubstitutorsByMap((PsiClass)this, (PsiClassImplUtil.MemberType)PsiClassImplUtil.MemberType.METHOD);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "getAllMethodsAndTheirSubstitutors"));
        }
        return list;
    }

    @Nullable
    public PsiClass findInnerClassByName(@NonNls String name, boolean checkBases) {
        return null;
    }

    @Nullable
    public PsiElement getLBrace() {
        return null;
    }

    @Nullable
    public PsiElement getRBrace() {
        return null;
    }

    @Nullable
    public PsiIdentifier getNameIdentifier() {
        return new JavaIdentifier((PsiManager)this.getManager(), (PsiElement)this.getTypeName());
    }

    public PsiElement getScope() {
        return null;
    }

    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "isInheritor"));
        }
        if (this.isTraitable()) {
            return "org.drools.core.factmodel.traits.Thing".equals(baseClass.getQualifiedName());
        }
        return false;
    }

    public boolean isInheritorDeep(PsiClass baseClass, @Nullable PsiClass classToByPass) {
        return false;
    }

    @Nullable
    public PsiClass getContainingClass() {
        return null;
    }

    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        Set<HierarchicalMethodSignature> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "getVisibleSignatures"));
        }
        return set;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "setName"));
        }
        DroolsTypeName oldIdentifier = this.getTypeName();
        DroolsTypeName nameIdentifier = DroolsElementsFactory.createDeclaredTypeNameIdentifier(name, this.getProject());
        if (nameIdentifier != null) {
            oldIdentifier.replace((PsiElement)nameIdentifier);
        }
        return this;
    }

    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean hasTypeParameters() {
        return false;
    }

    @Nullable
    public PsiTypeParameterList getTypeParameterList() {
        return null;
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = new PsiTypeParameter[]{};
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "getTypeParameters"));
        }
        return psiTypeParameterArray;
    }

    @Nullable
    public PsiModifierList getModifierList() {
        return null;
    }

    public boolean hasModifierProperty(@PsiModifier.ModifierConstant @NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl", "hasModifierProperty"));
        }
        return false;
    }

    public boolean isTraitable() {
        for (DroolsAnnotation annotation : this.getAnnotationList()) {
            if (!"Traitable".equals(annotation.getIdentifier().getText())) continue;
            return true;
        }
        return this.getTraitable() != null;
    }

    public class GeneratedLightMethod
    extends LightMethod {
        private final PsiField myField;

        public GeneratedLightMethod(PsiManagerEx manager, PsiMethod method, PsiField field) {
            super((PsiManager)manager, method, (PsiClass)DroolsPsiClassImpl.this);
            this.myField = field;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiField psiField = this.myField;
            if (psiField == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/impl/DroolsPsiClassImpl$GeneratedLightMethod", "getNavigationElement"));
            }
            return psiField;
        }
    }
}

