/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.searchers;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.drools.lang.psi.DroolsFile;
import com.intellij.plugins.drools.lang.psi.DroolsFunctionStatement;
import com.intellij.plugins.drools.lang.psi.DroolsVariable;
import com.intellij.plugins.drools.lang.psi.util.DroolsBeanPropertyLightVariable;
import com.intellij.plugins.drools.lang.psi.util.DroolsLightClass;
import com.intellij.plugins.drools.lang.psi.util.processors.DroolsFunctionsProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class DroolsFilesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public DroolsFilesSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters parameters, @NotNull Processor<PsiReference> consumer) {
        String name;
        DroolsLightClass lightClass;
        String lightClassName;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/plugins/drools/lang/psi/searchers/DroolsFilesSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/plugins/drools/lang/psi/searchers/DroolsFilesSearcher", "processQuery"));
        }
        PsiElement search = parameters.getElementToSearch();
        if (search instanceof DroolsLightClass && (lightClassName = (lightClass = (DroolsLightClass)search).getName()) != null) {
            parameters.getOptimizer().searchWord(lightClassName, parameters.getEffectiveSearchScope(), (short)255, false, (PsiElement)lightClass.getDelegate());
        }
        if (search instanceof DroolsVariable) {
            name = ((DroolsVariable)search).getName();
            if (!StringUtil.isEmptyOrSpaces((String)name) && name.startsWith("$") && name.length() > 1) {
                parameters.getOptimizer().searchWord(name.substring(1), parameters.getEffectiveSearchScope(), (short)255, false, search);
            }
        } else if (search instanceof PsiLocalVariable) {
            name = ((PsiLocalVariable)search).getName();
            if (!StringUtil.isEmptyOrSpaces((String)name)) {
                parameters.getOptimizer().searchWord(name, parameters.getEffectiveSearchScope(), (short)255, false, search);
            }
        } else if (search instanceof DroolsBeanPropertyLightVariable) {
            BeanProperty beanProperty = ((DroolsBeanPropertyLightVariable)search).getBeanProperty();
            DroolsFilesSearcher.searchBeanPropertyElement(parameters, (BeanPropertyElement)beanProperty.getPsiElement());
        } else if (search instanceof BeanPropertyElement) {
            DroolsFilesSearcher.searchBeanPropertyElement(parameters, (BeanPropertyElement)search);
        } else if (search instanceof DroolsFunctionStatement) {
            DroolsFilesSearcher.searchFunction(parameters, (DroolsFunctionStatement)search);
        }
    }

    private static void searchBeanPropertyElement(ReferencesSearch.SearchParameters parameters, BeanPropertyElement search) {
        if (search.getContainingFile() instanceof DroolsFile) {
            String propertyName = search.getName();
            PsiMethod method = search.getMethod();
            parameters.getOptimizer().searchWord(propertyName, parameters.getEffectiveSearchScope(), (short)255, false, (PsiElement)method, (RequestResultProcessor)new DroolsBeanPropertyResultProcessor(search));
            parameters.getOptimizer().searchWord(method.getName(), parameters.getEffectiveSearchScope(), (short)255, false, (PsiElement)method);
        }
    }

    private static void searchFunction(ReferencesSearch.SearchParameters parameters, DroolsFunctionStatement search) {
        String name = search.getName();
        parameters.getOptimizer().searchWord(name, parameters.getEffectiveSearchScope(), (short)255, false, (PsiElement)DroolsFunctionsProcessor.createLightMethodBuilder(search));
    }

    private static class DroolsBeanPropertyResultProcessor
    extends RequestResultProcessor {
        private final BeanPropertyElement myPropertyElement;

        public DroolsBeanPropertyResultProcessor(@NotNull BeanPropertyElement propertyElement) {
            if (propertyElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyElement", "com/intellij/plugins/drools/lang/psi/searchers/DroolsFilesSearcher$DroolsBeanPropertyResultProcessor", "<init>"));
            }
            super(new Object[0]);
            this.myPropertyElement = propertyElement;
        }

        public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<PsiReference> consumer) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/plugins/drools/lang/psi/searchers/DroolsFilesSearcher$DroolsBeanPropertyResultProcessor", "processTextOccurrence"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/plugins/drools/lang/psi/searchers/DroolsFilesSearcher$DroolsBeanPropertyResultProcessor", "processTextOccurrence"));
            }
            for (PsiReference ref : PsiReferenceService.getService().getReferences(element, new PsiReferenceService.Hints(element, Integer.valueOf(offsetInElement)))) {
                if (!ReferenceRange.containsOffsetInElement((PsiReference)ref, (int)offsetInElement) || DroolsBeanPropertyResultProcessor.processReference(consumer, ref, this.myPropertyElement)) continue;
                return false;
            }
            return true;
        }

        private static boolean processReference(Processor<PsiReference> consumer, PsiReference ref, BeanPropertyElement propertyElement) {
            if (!propertyElement.isValid()) {
                return true;
            }
            if (ref instanceof ResolvingHint && !((ResolvingHint)ref).canResolveTo(PsiMethod.class)) {
                return true;
            }
            if (ref.isReferenceTo((PsiElement)propertyElement)) {
                return consumer.process((Object)ref);
            }
            PsiElement refElement = ref.resolve();
            if (refElement instanceof DroolsBeanPropertyLightVariable && propertyElement.equals((Object)((DroolsBeanPropertyLightVariable)refElement).getBeanProperty().getPsiElement())) {
                return consumer.process((Object)ref);
            }
            return true;
        }
    }
}

