/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.util;

import com.intellij.plugins.drools.lang.psi.util.DroolsLightClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveAllClassesInFileHandler;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MoveDroolsLightClassesInFileHandler
extends MoveAllClassesInFileHandler {
    public void processMoveAllClassesInFile(@NotNull Map<PsiClass, Boolean> allClasses, PsiClass psiClass, PsiElement ... elementsToMove) {
        if (allClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allClasses", "com/intellij/plugins/drools/lang/psi/util/MoveDroolsLightClassesInFileHandler", "processMoveAllClassesInFile"));
        }
        if (psiClass instanceof DroolsLightClass) {
            PsiClassOwner containingFile = (PsiClassOwner)psiClass.getContainingFile();
            DroolsLightClass[] classes = (DroolsLightClass[])ContainerUtil.map2Array((Object[])containingFile.getClasses(), DroolsLightClass.class, (Function)new Function<PsiClass, DroolsLightClass>(){

                public DroolsLightClass fun(PsiClass aClass) {
                    return new DroolsLightClass(aClass);
                }
            });
            boolean all = true;
            for (DroolsLightClass aClass : classes) {
                if (ArrayUtil.find((Object[])elementsToMove, (Object)((Object)aClass)) != -1) continue;
                all = false;
                break;
            }
            for (DroolsLightClass aClass : classes) {
                allClasses.put((PsiClass)aClass, all);
            }
        }
    }
}

