/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.util.processors;

import com.intellij.openapi.project.Project;
import com.intellij.plugins.drools.lang.psi.DroolsFile;
import com.intellij.plugins.drools.lang.psi.util.DroolsLightClass;
import com.intellij.plugins.drools.lang.psi.util.DroolsLightVariable;
import com.intellij.plugins.drools.lang.psi.util.processors.DroolsDeclarationsProcessor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.hash.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DroolsImplicitVariablesProcessor
implements DroolsDeclarationsProcessor {
    private static DroolsImplicitVariablesProcessor myInstance;
    private static Map<String, String> vars;

    private DroolsImplicitVariablesProcessor() {
    }

    public static DroolsImplicitVariablesProcessor getInstance() {
        if (myInstance == null) {
            myInstance = new DroolsImplicitVariablesProcessor();
        }
        return myInstance;
    }

    @Override
    public boolean processElement(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place, final @NotNull DroolsFile droolsFile) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsImplicitVariablesProcessor", "processElement"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsImplicitVariablesProcessor", "processElement"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsImplicitVariablesProcessor", "processElement"));
        }
        if (droolsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "droolsFile", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsImplicitVariablesProcessor", "processElement"));
        }
        Set implicitVars = (Set)CachedValuesManager.getCachedValue((PsiElement)droolsFile, (CachedValueProvider)new CachedValueProvider<Set<DroolsLightVariable>>(){

            @Nullable
            public CachedValueProvider.Result<Set<DroolsLightVariable>> compute() {
                HashSet lightVariables = ContainerUtilRt.newHashSet();
                for (Map.Entry entry : vars.entrySet()) {
                    String className = (String)entry.getValue();
                    Project project = droolsFile.getProject();
                    PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
                    if (aClass == null) continue;
                    String varName = (String)entry.getKey();
                    lightVariables.add(new DroolsLightVariable(varName, (PsiType)JavaPsiFacade.getInstance((Project)project).getElementFactory().createType((PsiClass)new DroolsLightClass(aClass)), (PsiElement)droolsFile));
                }
                return CachedValueProvider.Result.createSingleDependency((Object)lightVariables, (Object)((Object)droolsFile));
            }
        });
        for (DroolsLightVariable lightVariable : implicitVars) {
            PsiClass psiClass;
            if (!processor.execute((PsiElement)lightVariable, state)) {
                return false;
            }
            if (!lightVariable.getName().equals("drools") || (psiClass = ((PsiClassType)lightVariable.getType()).resolve()) == null || psiClass.processDeclarations(processor, state, lastParent, place)) continue;
            return false;
        }
        return true;
    }

    static {
        vars = new HashMap();
        vars.put("kcontext", "org.kie.api.runtime.KieContext");
        vars.put("drools", "org.drools.core.spi.KnowledgeHelper");
    }
}

