/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.view.DatabaseView;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddDataSourceFromUrl
extends AnAction
implements DumbAware {
    @NotNull
    private final DatabaseView.DataSourceFactory myFactory;

    public AddDataSourceFromUrl(@NotNull DatabaseView.DataSourceFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/database/actions/AddDataSourceFromUrl", "<init>"));
        }
        super("Data Source from URL", null, DatabaseIcons.Connector);
        this.myFactory = factory;
    }

    public void update(AnActionEvent e) {
        DatabaseView databaseView = (DatabaseView)((Object)DatabaseView.DATABASE_VIEW_KEY.getData(e.getDataContext()));
        e.getPresentation().setEnabledAndVisible(databaseView != null);
    }

    public void actionPerformed(AnActionEvent e) {
        DbPsiFacade facade;
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        DbPsiFacade dbPsiFacade = facade = project == null ? null : DbPsiFacade.getInstance((Project)project);
        if (facade == null) {
            return;
        }
        AddDataSourceFromUrl.newDataSourceFromInput(facade, new TripleFunction<DbPsiManager, DataSourceTemplate, String, Void>(){

            public Void fun(DbPsiManager manager, DataSourceTemplate template, String s) {
                AddDataSourceFromUrl.this.myFactory.create(facade, manager, template, s);
                return null;
            }
        });
    }

    public static void newDataSourceFromInput(@NotNull DbPsiFacade facade, @NotNull TripleFunction<DbPsiManager, DataSourceTemplate, String, Void> consumer) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/actions/AddDataSourceFromUrl", "newDataSourceFromInput"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/actions/AddDataSourceFromUrl", "newDataSourceFromInput"));
        }
        new FastDataSourceDialog(facade.getProject(), (TripleFunction)consumer){
            {
                this.setTitle("New Data Source from URL");
                this.getNameLabel().setText(UIUtil.replaceMnemonicAmpersand((String)"&URL:"));
            }

            @Override
            protected boolean looksLikeOk(@NotNull String str) {
                if (str == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/database/actions/AddDataSourceFromUrl$2", "looksLikeOk"));
                }
                return str.startsWith("jdbc:");
            }

            @Override
            @Nullable
            protected DatabaseDriver selectDriver(@NotNull String str) {
                if (str == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/database/actions/AddDataSourceFromUrl$2", "selectDriver"));
                }
                for (Pair driverPair : this.myDrivers) {
                    for (StatelessJdbcUrlParser parser : ((DatabaseDriver)driverPair.second).getJDBCUrlParsers()) {
                        if (!parser.isUrlValueValid(this.getNameField().getText())) continue;
                        return (DatabaseDriver)driverPair.second;
                    }
                }
                return null;
            }

            @Override
            @NotNull
            protected List<Pair<DbPsiManager, DatabaseDriver>> extractDrivers(@NotNull DbPsiFacade facade) {
                if (facade == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/actions/AddDataSourceFromUrl$2", "extractDrivers"));
                }
                List<Pair<DbPsiManager, DatabaseDriver>> list = 2.allDrivers(facade);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/AddDataSourceFromUrl$2", "extractDrivers"));
                }
                return list;
            }
        }.show();
    }

    static abstract class FastDataSourceDialog
    extends CreateFileFromTemplateDialog {
        private final TripleFunction<DbPsiManager, DataSourceTemplate, String, Void> myConsumer;
        protected List<Pair<DbPsiManager, DatabaseDriver>> myDrivers;
        private boolean myKindUserEdited;
        private boolean myUpdating;

        public FastDataSourceDialog(@NotNull Project project, @NotNull TripleFunction<DbPsiManager, DataSourceTemplate, String, Void> consumer) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/AddDataSourceFromUrl$FastDataSourceDialog", "<init>"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/actions/AddDataSourceFromUrl$FastDataSourceDialog", "<init>"));
            }
            super(project);
            this.myConsumer = consumer;
            this.setup(project);
        }

        private void setup(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/AddDataSourceFromUrl$FastDataSourceDialog", "setup"));
            }
            this.getKindLabel().setText(UIUtil.replaceMnemonicAmpersand((String)"&Driver:"));
            this.myDrivers = this.extractDrivers(DbPsiFacade.getInstance((Project)project));
            Collections.sort(this.myDrivers, new Comparator<Pair<DbPsiManager, DatabaseDriver>>(){

                @Override
                public int compare(Pair<DbPsiManager, DatabaseDriver> o1, Pair<DbPsiManager, DatabaseDriver> o2) {
                    return StringUtil.naturalCompare((String)((DatabaseDriver)o1.second).getFullName(), (String)((DatabaseDriver)o2.second).getFullName());
                }
            });
            for (Pair<DbPsiManager, DatabaseDriver> driver : this.myDrivers) {
                this.getKindCombo().addItem(((DatabaseDriver)driver.getSecond()).getFullName(), ((DatabaseDriver)driver.getSecond()).getIcon(0), ((DatabaseDriver)driver.getSecond()).getFullName());
            }
            this.setTemplateKindComponentsVisible(true);
            this.getNameField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    myUpdating = true;
                    try {
                        DatabaseDriver driver = this.selectDriver(this.getNameField().getText());
                        if (driver != null) {
                            this.getKindCombo().setSelectedName(driver.getFullName());
                        } else if (!myKindUserEdited) {
                            this.getKindCombo().getComboBox().setSelectedItem(null);
                        }
                    }
                    finally {
                        myUpdating = false;
                    }
                }
            });
            String clipboardText = StringUtil.trim((String)((String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)));
            if (clipboardText != null && this.looksLikeOk(clipboardText)) {
                this.getNameField().setText(clipboardText);
            }
            this.getKindCombo().getComboBox().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!myUpdating) {
                        myKindUserEdited = true;
                    }
                }
            });
        }

        @Nullable
        protected ValidationInfo doValidate() {
            if (this.getKindCombo().getComboBox().getSelectedItem() == null) {
                return new ValidationInfo("Please select driver");
            }
            return super.doValidate();
        }

        protected void doOKAction() {
            for (final Pair<DbPsiManager, DatabaseDriver> driver : this.myDrivers) {
                if (!((DatabaseDriver)driver.second).getFullName().equals(this.getKindCombo().getSelectedName())) continue;
                final String text = this.getNameField().getText();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        myConsumer.fun(driver.first, driver.second, (Object)text);
                    }
                });
            }
            super.doOKAction();
        }

        protected abstract boolean looksLikeOk(@NotNull String var1);

        @Nullable
        protected abstract DatabaseDriver selectDriver(@NotNull String var1);

        @NotNull
        protected abstract List<Pair<DbPsiManager, DatabaseDriver>> extractDrivers(@NotNull DbPsiFacade var1);

        static List<Pair<DbPsiManager, DatabaseDriver>> allDrivers(@NotNull DbPsiFacade facade) {
            if (facade == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/actions/AddDataSourceFromUrl$FastDataSourceDialog", "allDrivers"));
            }
            ArrayList allDrivers = ContainerUtil.newArrayList();
            for (DbPsiManager manager : facade.getDbManagers()) {
                for (DataSourceTemplate template0 : manager.getDataSourceTemplates()) {
                    for (DataSourceTemplate template : template0.getSubConfigurations()) {
                        DatabaseDriver databaseDriver = (DatabaseDriver)ObjectUtils.tryCast((Object)template, DatabaseDriver.class);
                        if (databaseDriver == null) continue;
                        allDrivers.add(Pair.create((Object)manager, (Object)databaseDriver));
                    }
                }
            }
            return allDrivers;
        }
    }
}

