/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.psi.DbElement;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.AssignColorDialog;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignColorAction
extends AnAction
implements DumbAware {
    public AssignColorAction() {
        super("Color Settings...");
    }

    public void update(AnActionEvent e) {
        DatabaseView view = (DatabaseView)((Object)DatabaseView.DATABASE_VIEW_KEY.getData(e.getDataContext()));
        boolean enabled = view != null && !view.getTreeBuilder().getSelectedElements(DbElement.class).isEmpty();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        DatabaseView view = (DatabaseView)((Object)DatabaseView.DATABASE_VIEW_KEY.getData(e.getDataContext()));
        if (view == null) {
            return;
        }
        Set selectedElements = view.getTreeBuilder().getSelectedElements(DbElement.class);
        Project project = view.getProject();
        AssignColorDialog dialog = new AssignColorDialog(project, new ArrayList<DbElement>(selectedElements));
        if (dialog.showAndGet()) {
            AssignColorAction.updateOpenFileEditors(project);
            AssignColorAction.updateDatabaseToolwindow(project);
        }
    }

    private static void updateOpenFileEditors(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/AssignColorAction", "updateOpenFileEditors"));
        }
        FileEditorManagerEx managerEx = FileEditorManagerEx.getInstanceEx((Project)project);
        for (VirtualFile file : managerEx.getOpenFiles()) {
            managerEx.updateFilePresentation(file);
            if (!DbConsoleRootType.isConsoleFile(file) && !(file instanceof DatabaseElementVirtualFileImpl)) continue;
            for (FileEditor editor : managerEx.getEditors(file)) {
                AssignColorAction.updateColors(project, file, editor.getComponent());
            }
        }
    }

    private static void updateDatabaseToolwindow(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/AssignColorAction", "updateDatabaseToolwindow"));
        }
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow("Database Console");
        if (window == null) {
            return;
        }
        for (Content content : window.getContentManager().getContents()) {
            JComponent comp = content.getComponent();
            JdbcConsole console = JdbcConsole.getConsole(AnActionEvent.createFromDataContext((String)"", null, (DataContext)DataManager.getInstance().getDataContext((Component)comp)));
            if (console == null) continue;
            AssignColorAction.updateColors(project, console.getLanguageConsole().getVirtualFile(), comp);
        }
    }

    private static void updateColors(@NotNull Project project, @NotNull VirtualFile file, @Nullable JComponent root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/AssignColorAction", "updateColors"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/actions/AssignColorAction", "updateColors"));
        }
        for (EditorHeaderComponent component : UIUtil.uiTraverser((Component)root).filter(EditorHeaderComponent.class)) {
            DatabaseEditorHelper.updateToolbarColor(project, file, (JComponent)component);
        }
    }
}

