/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class ManageDataSourcesAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ManageDataSourcesAction", "actionPerformed"));
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(e.getDataContext());
        DataSourceManagerDialog.showDialog(project, (DbDataSource)PsiTreeUtil.getParentOfType((PsiElement)element, DbDataSource.class, (boolean)false));
    }

    public void update(AnActionEvent e) {
        boolean enabled;
        boolean mainMenu = ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace());
        KeyEvent keyEvent = (KeyEvent)ObjectUtils.tryCast((Object)e.getInputEvent(), KeyEvent.class);
        if (mainMenu) {
            e.getPresentation().setText("Data Sources...");
        } else if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setText("Properties");
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(e.getDataContext());
        DbPsiFacade facade = (DbPsiFacade)DatabaseDataKeys.DB_PSI_FACADE.getData(e.getDataContext());
        DbDataSource dataSource = (DbDataSource)PsiTreeUtil.getParentOfType((PsiElement)element, DbDataSource.class, (boolean)false);
        boolean toolbarPlace = ActionPlaces.isToolbarPlace((String)e.getPlace());
        boolean bl = enabled = facade != null && (toolbarPlace || dataSource != null && element == dataSource);
        if (PlatformUtils.isDatabaseIDE()) {
            KeyboardShortcut shortcut;
            boolean flag = e.getProject() != null && (mainMenu || enabled);
            e.getPresentation().setEnabledAndVisible(flag);
            if (!(enabled || keyEvent == null || (shortcut = e.getActionManager().getKeyboardShortcut(e.getActionManager().getId((AnAction)this))) != null && Comparing.equal((Object)KeyStroke.getKeyStrokeForEvent(keyEvent), (Object)shortcut.getFirstKeyStroke()))) {
                e.getPresentation().setEnabled(false);
            }
        } else {
            e.getPresentation().setEnabledAndVisible(enabled);
        }
    }
}

