/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DataBus;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEngine
extends DataRequest.Visitor
implements DataProducer,
Disposable {
    protected static final Logger LOG = Logger.getInstance(AbstractEngine.class);
    private final ThreadPoolExecutor myExecutorService;
    private final Project myProject;
    private final DataBus.Producing myMessageBus;
    private final DataAuditor myDataAuditor;
    private final DataConsumer myDataConsumer;
    private final AtomicReference<DataRequest.Context> myRequestContext;
    private volatile boolean myCancelled;

    protected AbstractEngine(@NotNull Project project, @NotNull DataBus.Producing messageBus) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/AbstractEngine", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/database/console/AbstractEngine", "<init>"));
        }
        this.myExecutorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), ConcurrencyUtil.newNamedThreadFactory((String)"database engine"));
        this.myRequestContext = new AtomicReference();
        this.myProject = project;
        this.myMessageBus = messageBus;
        Disposer.register((Disposable)project, (Disposable)this);
        this.myDataAuditor = messageBus.getDataAuditor();
        this.myDataConsumer = messageBus.getDataConsumer();
        messageBus.addProducer(this);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/AbstractEngine", "getProject"));
        }
        return project;
    }

    @NotNull
    protected DataAuditor getDataAuditor() {
        DataAuditor dataAuditor = this.myDataAuditor;
        if (dataAuditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/AbstractEngine", "getDataAuditor"));
        }
        return dataAuditor;
    }

    @NotNull
    protected DataConsumer getDataConsumer() {
        DataConsumer dataConsumer = this.myDataConsumer;
        if (dataConsumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/AbstractEngine", "getDataConsumer"));
        }
        return dataConsumer;
    }

    @NotNull
    protected DataRequest.Context getRequestContext() {
        DataRequest.Context context = this.myRequestContext.get();
        if (context == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/AbstractEngine", "getRequestContext"));
        }
        return context;
    }

    @Nullable
    protected DataRequest.Context getRequestContextIfAny() {
        return this.myRequestContext.get();
    }

    @Override
    public void processRequest(@NotNull DataRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/console/AbstractEngine", "processRequest"));
        }
        request.accept(this);
    }

    @Override
    public void visitCancel(DataRequest.Cancel r) {
        if (!this.cancelPendingRequests()) {
            this.terminate();
        }
    }

    @Override
    public void visitRequest(DataRequest r) {
        LOG.error("unknown request: " + r);
    }

    public void dispose() {
        this.myMessageBus.beforeProducerRemove(this);
        this.cancelPendingRequests(new Runnable(){

            @Override
            public void run() {
                AbstractEngine.this.myMessageBus.afterProducerRemove(AbstractEngine.this);
            }
        });
        this.myExecutorService.shutdown();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                this.myExecutorService.awaitTermination(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean isDisposed() {
        return this.myExecutorService.isShutdown();
    }

    public void terminate() {
        this.cancelPendingRequests();
    }

    protected boolean cancelPendingRequests() {
        this.cancelPendingRequests(null);
        return true;
    }

    private void cancelPendingRequests(final @Nullable Runnable finalRunnable) {
        this.myExecutorService.purge();
        final ArrayList c = ContainerUtil.newArrayList();
        this.myExecutorService.getQueue().drainTo(c);
        this.myCancelled = true;
        this.submitRunnable(new Runnable(){

            @Override
            public void run() {
                for (Runnable r : c) {
                    try {
                        r.run();
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        });
        this.myExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    AbstractEngine.this.myCancelled = false;
                }
            }
        });
    }

    @NotNull
    protected abstract DataRequest.Context createRequestContext(@NotNull DataRequest var1);

    protected void submitRunnable(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/console/AbstractEngine", "submitRunnable"));
        }
        this.myExecutorService.submit(runnable);
    }

    private void submitRunnable(final DataRequest request, final Computable<Boolean> runnable) {
        this.getDataAuditor().jobSubmitted(request, this);
        this.submitRunnable(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean result = false;
                try {
                    if (AbstractEngine.this.myCancelled) {
                        return;
                    }
                    result = (Boolean)runnable.compute();
                }
                finally {
                    try {
                        AbstractEngine.this.getDataAuditor().jobFinished(request, AbstractEngine.this);
                    }
                    finally {
                        DbImplUtil.setActionCallbackDone(request.getPromise(), result);
                    }
                }
            }
        });
    }

    protected void submitRequest(final @NotNull DataRequest request, final @NotNull ThrowableComputable<Boolean, Exception> computable) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/console/AbstractEngine", "submitRequest"));
        }
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/database/console/AbstractEngine", "submitRequest"));
        }
        this.submitRunnable(request, new Computable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean compute() {
                boolean result = false;
                try {
                    AbstractEngine.this.myRequestContext.set(AbstractEngine.this.createRequestContext(request));
                    result = (Boolean)computable.compute();
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable e) {
                    try {
                        ((DataRequest.Context)AbstractEngine.this.myRequestContext.get()).reportException(e, null);
                    }
                    catch (Exception e1) {
                        LOG.error((Throwable)e1);
                    }
                }
                finally {
                    AbstractEngine.this.myRequestContext.set(null);
                }
                return result;
            }
        });
    }
}

