/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseConsoleWidget
extends EditorBasedWidget
implements CustomStatusBarWidget {
    public static final String WIDGET_ID = "DatabaseConsoleWidget";
    private final TextPanel.WithIconAndArrows myComponent = new TextPanel.WithIconAndArrows();

    public DatabaseConsoleWidget(Project project) {
        super(project);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/DatabaseConsoleWidget$1", "onClick"));
                }
                DatabaseConsoleWidget.this.showPopup(e);
                DatabaseConsoleWidget.this.update();
                return true;
            }
        }.installOn((Component)this.myComponent);
        DbPsiFacade.getInstance((Project)project).addModificationTrackerListener((ModificationTrackerListener)new ModificationTrackerListener<DbPsiFacade>(){

            public void modificationCountChanged(DbPsiFacade source) {
                DatabaseConsoleWidget.this.update();
            }
        }, (Disposable)this);
        this.myComponent.setBorder(StatusBarWidget.WidgetBorder.WIDE);
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/database/console/DatabaseConsoleWidget", "install"));
        }
        super.install(statusBar);
        this.update();
    }

    @NotNull
    public String ID() {
        if (WIDGET_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DatabaseConsoleWidget", "ID"));
        }
        return WIDGET_ID;
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/console/DatabaseConsoleWidget", "getPresentation"));
        }
        return null;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    private void showPopup(MouseEvent e) {
        ListPopup popup = this.getPopupStep();
        if (popup == null) {
            return;
        }
        Dimension dimension = popup.getContent().getPreferredSize();
        Point at = new Point(0, -dimension.height);
        popup.show(new RelativePoint(e.getComponent(), at));
        Disposer.register((Disposable)this, (Disposable)popup);
    }

    public void dispose() {
        super.dispose();
    }

    private ListPopup getPopupStep() {
        PsiFile file;
        final Editor editor = this.getEditor();
        Project project = this.getProject();
        PsiFile psiFile = file = editor == null || project == null ? null : PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null) {
            return null;
        }
        ArrayList<JdbcConsole> consoles = new ArrayList<JdbcConsole>();
        List<JdbcConsole> openConsoles = JdbcConsole.getActiveConsoles(project);
        consoles.add(null);
        consoles.addAll(openConsoles);
        BaseListPopupStep<JdbcConsole> popupStep = new BaseListPopupStep<JdbcConsole>("", consoles){

            public PopupStep onChosen(JdbcConsole selectedValue, boolean finalChoice) {
                JdbcConsoleProvider.attachConsole(selectedValue, editor, file);
                DatabaseConsoleWidget.this.update();
                return FINAL_CHOICE;
            }

            @NotNull
            public String getTextFor(JdbcConsole value) {
                String string = value == null ? "<detach>" : value.getTitle();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DatabaseConsoleWidget$3", "getTextFor"));
                }
                return string;
            }

            public Icon getIconFor(JdbcConsole value) {
                return value == null ? null : value.getDataSource().getIcon(0);
            }
        };
        popupStep.setDefaultOptionIndex(openConsoles.indexOf(this.getAttachedConsole()) + 1);
        return JBPopupFactory.getInstance().createListPopup((ListPopupStep)popupStep);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/console/DatabaseConsoleWidget", "selectionChanged"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.update();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/DatabaseConsoleWidget", "fileOpened"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/console/DatabaseConsoleWidget", "fileOpened"));
        }
        this.update();
    }

    private void update() {
        JdbcConsole console = this.getAttachedConsole();
        this.myComponent.setIcon(console == null ? null : console.getDataSource().getIcon(0));
        this.myComponent.setText(console == null ? "" : console.getTitle());
        this.myComponent.setVisible(StringUtil.isNotEmpty((String)this.myComponent.getText()));
        this.myComponent.setToolTipText("Attached database console, click to change");
        if (this.myStatusBar != null) {
            JComponent statusBar = this.myStatusBar.getComponent();
            int width = this.myComponent.getWidth();
            if (width < this.myComponent.getPreferredSize().width) {
                this.myComponent.invalidate();
                statusBar.invalidate();
                statusBar.doLayout();
                statusBar.repaint();
            } else {
                this.myComponent.repaint();
            }
        }
    }

    @Nullable
    private JdbcConsole getAttachedConsole() {
        Editor editor = this.getEditor();
        Project project = this.getProject();
        PsiFile file = editor == null || project == null ? null : PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        return JdbcConsoleProvider.getAttachedConsole(file);
    }
}

