/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.console.AbstractEngine;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.SuppressUserStackTrace;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteSavepoint;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcEngine
extends AbstractEngine
implements DataProducer {
    private static final Logger LOG = Logger.getInstance(JdbcEngine.class);
    private final JdbcDriverManager myDriverManager;
    private final LocalDataSource myDataSource;
    private final ThrowableComputable<Connection, Exception> myConnectionFactory;
    private volatile Connection myConnection;
    private DataRequest.TxMarker myTxMarker;
    private ConsoleRunConfiguration myConfiguration;
    private volatile Statement myCurrentStatement;
    private volatile Thread myCancelThread;
    private volatile ObjectPath myCurrentSchema;
    private DatabaseDialectEx myDialect;

    public JdbcEngine(@NotNull Project project, @NotNull DataBus.Producing messageBus, LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/JdbcEngine", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/database/console/JdbcEngine", "<init>"));
        }
        super(project, messageBus);
        this.myDataSource = dataSource;
        this.myDriverManager = JdbcDriverManager.getDriverManager(project);
        this.myConfiguration = configuration;
        this.myConnectionFactory = configuration == null ? new ThrowableComputable<Connection, Exception>(){

            @Nullable
            public Connection compute() throws Exception {
                JdbcEngine.this.myConfiguration = JdbcEngine.this.myDriverManager.getDefaultRunConfiguration(JdbcEngine.this.myDataSource);
                return JdbcEngine.this.myDataSource.getConnection(JdbcEngine.this.myDriverManager, JdbcEngine.this.myConfiguration);
            }
        } : new ThrowableComputable<Connection, Exception>(){

            public Connection compute() throws Exception {
                return JdbcEngine.this.myDataSource.getConnection(JdbcEngine.this.myDriverManager, JdbcEngine.this.myConfiguration);
            }
        };
        this.myTxMarker = DataRequest.getInitialTxMarker(this.myDataSource.isAutoCommit());
    }

    @Nullable
    public Connection getCurrentConnection() {
        return this.myConnection;
    }

    @Nullable
    public Connection getConnection() throws Exception {
        return this.getConnection(true);
    }

    public ObjectPath getCurrentSchema(DataRequest.Context context) {
        try {
            Connection connection = this.getCurrentConnection();
            this.myCurrentSchema = connection == null ? null : this.detectDatabaseDialect().tryToLoadCurrentSchemaName(connection);
            return this.myCurrentSchema;
        }
        catch (Exception e) {
            context.reportException(e, null);
            return this.myCurrentSchema;
        }
    }

    void setCurrentSchema(@Nullable ObjectPath currentSchema) {
        this.myCurrentSchema = currentSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Connection getConnection(boolean setCurrentSchema) throws Exception {
        Connection connection = this.getCurrentConnection();
        boolean freshConnection = false;
        if (!JdbcEngine.isConnectionReady(connection)) {
            ThrowableComputable<Connection, Exception> throwableComputable = this.myConnectionFactory;
            synchronized (throwableComputable) {
                this.myConnection = connection = (Connection)this.myConnectionFactory.compute();
                freshConnection = true;
            }
            this.myDialect = this.detectDatabaseDialect();
        }
        if (!JdbcEngine.isConnectionReady(connection)) {
            connection = null;
            this.myConnection = null;
        }
        if (connection == null) {
            this.getDataAuditor().error(this.getRequestContext(), "Connection failed", null);
        } else {
            this.prepareConnection(connection, setCurrentSchema && freshConnection);
        }
        return connection;
    }

    @Override
    public boolean cancelPendingRequests() {
        Thread thread;
        super.cancelPendingRequests();
        if (this.myCancelThread != null) {
            return false;
        }
        final Statement statement = this.myCurrentStatement;
        if (statement == null) {
            return false;
        }
        this.myCurrentStatement = null;
        this.myCancelThread = thread = new Thread("jdbc engine"){

            @Override
            public void run() {
                try {
                    DataRequest.Context context = JdbcEngine.this.getRequestContextIfAny();
                    if (context != null) {
                        JdbcEngine.this.getDataAuditor().print(context, "Cancelling...");
                        Thread.sleep(500L);
                        if (JdbcEngine.this.getRequestContextIfAny() != null) {
                            statement.cancel();
                        }
                    }
                }
                catch (Throwable ex) {
                    JdbcEngine.this.getRequestContext().reportException(ex, null);
                }
                finally {
                    JdbcEngine.this.myCancelThread = null;
                }
            }
        };
        thread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean completeTransaction(DataRequest.TxRequest r) throws Exception {
        if (this.myTxMarker.getOwner() == null || this.getCurrentConnection() == null) {
            return true;
        }
        Connection connection = this.getConnection();
        if (connection == null || !JdbcEngine.isConnectionReady(connection)) {
            return false;
        }
        boolean autoCommit = connection.getAutoCommit();
        try {
            if (!autoCommit && this.myTxMarker.getOwner() != null) {
                if (r.command == DataRequest.TxCommand.COMMIT) {
                    connection.commit();
                } else {
                    connection.rollback();
                }
                this.getDataAuditor().txCompleted(this.getRequestContext(), r.command == DataRequest.TxCommand.COMMIT);
            }
        }
        finally {
            this.myTxMarker = DataRequest.NONE;
        }
        return true;
    }

    public LocalDataSource getDataSource() {
        return this.myDataSource;
    }

    public boolean isStarted() {
        return this.myDriverManager.getActiveConfigurations(this.myDataSource).contains((Object)this.myConfiguration);
    }

    @Override
    public void terminate() {
        super.terminate();
        this.myDriverManager.releaseDriver(this.myDataSource, this.myConfiguration);
        this.myConnection = null;
        this.myCancelThread = null;
    }

    @Override
    public void visitQuery(final @NotNull DataRequest.QueryRequest r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "visitQuery"));
        }
        this.submitRequest(r, new ThrowableComputable<Boolean, Exception>(){

            public Boolean compute() throws Exception {
                return JdbcEngine.this.executeQueryInner(r);
            }
        });
    }

    @Override
    public void visitUpdate(@NotNull DataRequest.UpdateRequest r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "visitUpdate"));
        }
        this.updateRows(r, r.table, r.columns, r.rows, r.columnsToUpdate, r.newValue);
    }

    @Override
    public void visitInsert(@NotNull DataRequest.InsertRequest r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "visitInsert"));
        }
        this.insertRows(r, r.table, r.columns, r.rows);
    }

    @Override
    public void visitDelete(@NotNull DataRequest.DeleteRequest r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "visitDelete"));
        }
        this.deleteRows(r, r.table, r.columns, r.rows);
    }

    @Override
    public void visitTx(final DataRequest.TxRequest r) {
        this.submitRequest(r, new ThrowableComputable<Boolean, Exception>(){

            public Boolean compute() throws Exception {
                return JdbcEngine.this.completeTransaction(r);
            }
        });
    }

    @Override
    public void visitSchemaSwitch(final @NotNull DataRequest.SchemaSwitchRequest r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/JdbcEngine", "visitSchemaSwitch"));
        }
        this.submitRequest(r, new ThrowableComputable<Boolean, Exception>(){

            public Boolean compute() throws Exception {
                if (!DbImplUtil.supportsDynamicSchemaSwitching(JdbcEngine.this.myDataSource)) {
                    return Boolean.FALSE;
                }
                Connection connection = JdbcEngine.this.getCurrentConnection();
                if (connection == null && !r.forced) {
                    JdbcEngine.this.setCurrentSchema(r.schema);
                    return Boolean.TRUE;
                }
                connection = JdbcEngine.this.getConnection(false);
                return connection != null && JdbcEngine.this.performSchemaSwitch(connection, r.schema, r);
            }
        });
    }

    @Override
    public void visitRaw(final DataRequest.RawRequest r) {
        this.submitRequest(r, new ThrowableComputable<Boolean, Exception>(){

            public Boolean compute() throws Exception {
                Connection connection = JdbcEngine.this.getConnection();
                if (connection == null) {
                    return false;
                }
                try {
                    JdbcEngine.this.getDataAuditor().requestStarted(JdbcEngine.this.getRequestContext());
                    try {
                        r.processRaw(JdbcEngine.this.getRequestContext(), connection);
                    }
                    catch (ProcessCanceledException processCanceledException) {
                    }
                    catch (Throwable ex) {
                        JdbcEngine.this.getRequestContext().reportException(ex, null);
                    }
                }
                finally {
                    JdbcEngine.this.getDataAuditor().requestFinished(JdbcEngine.this.getRequestContext());
                }
                return true;
            }
        });
    }

    @Override
    @NotNull
    protected DataRequest.Context createRequestContext(@NotNull DataRequest request) {
        boolean ownerFailed;
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/console/JdbcEngine", "createRequestContext"));
        }
        if (this.myTxMarker.getOwner() != null && !JdbcEngine.isConnectionReady(this.getCurrentConnection())) {
            this.myTxMarker = DataRequest.getInitialTxMarker(this.myDataSource.isAutoCommit());
        }
        boolean bl = ownerFailed = this.myTxMarker.getOwner() != null && this.myTxMarker != request.txMarker;
        if (!ownerFailed && !(request instanceof DataRequest.TxRequest)) {
            if (request.txMarker == DataRequest.START_NEW || this.myTxMarker == DataRequest.START_NEW) {
                this.myTxMarker = DataRequest.newTxMarker("@" + request.owner.getDisplayName(), request.owner);
                final DataRequest.TxMarker marker = this.myTxMarker;
                if (marker.getOwner() instanceof Disposable) {
                    Disposer.register((Disposable)((Disposable)request.owner), (Disposable)new Disposable(){

                        public void dispose() {
                            if (JdbcEngine.this.isDisposed()) {
                                return;
                            }
                            JdbcEngine.this.processRequest(DataRequest.newTxRollback(marker));
                        }
                    });
                }
            } else if (this.myTxMarker == DataRequest.NONE) {
                this.myTxMarker = DataRequest.AUTO_COMMIT;
            }
        }
        DataRequest.Context context = new DataRequest.Context(this, request, this.myTxMarker){

            @Override
            public void reportException(@NotNull Throwable th, Object parameter) {
                if (th == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "th", "com/intellij/database/console/JdbcEngine$9", "reportException"));
                }
                JdbcEngine.handleException(this, th, (Statement)ObjectUtils.tryCast((Object)parameter, Statement.class), JdbcEngine.this.getDataAuditor(), (DatabaseSystem)JdbcEngine.this.getDataSource());
            }
        };
        if (ownerFailed) {
            ExecutionException th = new ExecutionException("locked by transaction: " + this.myTxMarker);
            context.reportException((Throwable)th, null);
            throw new ProcessCanceledException((Throwable)th);
        }
        DataRequest.Context context2 = context;
        if (context2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "createRequestContext"));
        }
        return context2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeQueryInner(DataRequest.QueryRequest r) throws Exception {
        Connection connection = this.getConnection();
        if (connection == null) {
            return false;
        }
        Statement statement = null;
        String queryText = r.query;
        DataRequest.Constraints constraints = r.constraints;
        try {
            boolean willScrollResultSet = constraints.offset != 0 && constraints.offset != 1;
            statement = this.openStatement(connection, queryText, willScrollResultSet);
            int maxRows = -1;
            if (constraints.offset >= 0 && constraints.limit > 0) {
                Object type = null;
                try {
                    type = r instanceof ConsoleDataRequest ? ((ConsoleDataRequest)r).resultType : DbSqlUtil.parseQueryType(this.getProject(), DbSqlUtil.getSqlDialect(this.myDialect), this.getCurrentNamespaceFile(), queryText, null);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
                if (type instanceof SqlTableType) {
                    maxRows = constraints.offset + constraints.limit + 1;
                    statement.setMaxRows(maxRows);
                }
            }
            int maxAllowedChunkSize = maxRows < 0 ? Integer.MAX_VALUE : maxRows;
            int defaultPrefetchSize = DatabaseSettings.getSettings().getPrefetchSize();
            int chunkSize = Math.min(maxAllowedChunkSize, Math.max(constraints.limit / 10, defaultPrefetchSize <= 0 ? 100 : defaultPrefetchSize));
            this.configurePreFetchSize(statement, chunkSize);
            try {
                ResultSet resultSet = null;
                boolean resultSetHere = r instanceof ConsoleDataRequest && ((ConsoleDataRequest)r).resultType instanceof SqlTableType ? (resultSet = statement.executeQuery(queryText)) != null : statement.execute(queryText);
                int updateCount = JdbcEngine.getUpdateCountSafe(statement);
                this.printWarnings(statement);
                int resultSetIndex = 0;
                do {
                    if (r.constraints.resultSetNumber <= 0 || r.constraints.resultSetNumber == ++resultSetIndex) {
                        if (updateCount == -1 || resultSetHere) {
                            if (resultSet == null) {
                                resultSet = statement.getResultSet();
                            }
                            if (resultSet != null) {
                                int rowCount = 0;
                                try {
                                    this.getDataAuditor().fetchStarted(this.getRequestContext(), resultSetIndex);
                                    rowCount = this.printResultSet(resultSet, resultSetIndex, constraints.offset, constraints.limit, chunkSize);
                                }
                                finally {
                                    this.getDataAuditor().fetchFinished(this.getRequestContext(), resultSetIndex, rowCount);
                                }
                            }
                        } else {
                            this.getDataAuditor().updateCountReceived(this.getRequestContext(), updateCount);
                        }
                    }
                    resultSet = null;
                    resultSetHere = statement.getMoreResults();
                    updateCount = JdbcEngine.getUpdateCountSafe(statement);
                } while (resultSetHere || updateCount != -1);
            }
            catch (Exception e) {
                this.printWarnings(statement);
                throw e;
            }
            boolean bl = true;
            this.closeStatement(statement);
            return bl;
        }
        catch (Throwable e) {
            try {
                this.getRequestContext().reportException(e, queryText);
                boolean bl = false;
                this.closeStatement(statement);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeStatement(statement);
                throw throwable;
            }
        }
    }

    @Nullable
    public DatabaseElementVirtualFileImpl getCurrentNamespaceFile() {
        return DatabaseElementVirtualFileImpl.findFile(this.getProject(), (DatabaseSystem)this.myDataSource, this.myCurrentSchema);
    }

    private void configurePreFetchSize(Statement statement, int chunkSize) {
        try {
            DatabaseFamilyId familyId = this.myDialect.getFamilyId();
            if (familyId.isMysql()) {
                statement.setFetchSize(Integer.MIN_VALUE);
            } else {
                statement.setFetchSize(chunkSize);
            }
        }
        catch (SQLException e) {
            LOG.warn((Throwable)e);
        }
    }

    public static int getUpdateCountSafe(@NotNull Statement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/console/JdbcEngine", "getUpdateCountSafe"));
        }
        try {
            return statement.getUpdateCount();
        }
        catch (Exception ignored) {
            return -1;
        }
    }

    private void printWarnings(@NotNull Statement statement) throws SQLException {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/console/JdbcEngine", "printWarnings"));
        }
        DatabaseFamilyId familyId = DatabaseFamilyId.forDataSource((DatabaseSystem)this.myDataSource);
        if (familyId.isTransactSql() || familyId.isPostgres()) {
            for (SQLWarning w = statement.getWarnings(); w != null; w = w.getNextWarning()) {
                this.getDataAuditor().print(this.getRequestContext(), w.getMessage());
            }
        }
    }

    private static boolean isConnectionReady(@Nullable Connection connection) {
        if (connection == null) {
            return false;
        }
        try {
            return !connection.isClosed();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void prepareConnection(@NotNull Connection connection, boolean setCurrentSchema) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine", "prepareConnection"));
        }
        connection.setAutoCommit(this.myTxMarker == DataRequest.AUTO_COMMIT);
        try {
            if (this.myTxMarker == DataRequest.AUTO_COMMIT) {
                connection.setReadOnly(this.myDataSource.isReadOnly());
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        if (DbImplUtil.supportsDynamicSchemaSwitching(this.myDataSource)) {
            ObjectPath schema = this.myCurrentSchema;
            if (setCurrentSchema && schema != null) {
                this.performSchemaSwitch(connection, schema, null);
            }
        }
    }

    private boolean performSchemaSwitch(@NotNull Connection connection, @NotNull ObjectPath to, @Nullable DataRequest.SchemaSwitchRequest request) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine", "performSchemaSwitch"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/console/JdbcEngine", "performSchemaSwitch"));
        }
        this.setCurrentSchema(to);
        String setSchemaSql = this.myDialect.sqlSetCurrentSchema(to);
        if (setSchemaSql == null) {
            if (to.path.size() > 1 && to.kind == ObjectKind.SCHEMA) {
                setSchemaSql = this.myDialect.sqlSetCurrentSchema(new ObjectPath(ObjectKind.DATABASE, to.path));
            }
            if (setSchemaSql == null) {
                return false;
            }
        }
        return request == null ? this.performImplicitSchemaSwitch(connection, setSchemaSql) : this.performExplicitSchemaSwitch(connection, setSchemaSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performImplicitSchemaSwitch(@NotNull Connection connection, @NotNull String setSchemaSql) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine", "performImplicitSchemaSwitch"));
        }
        if (setSchemaSql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setSchemaSql", "com/intellij/database/console/JdbcEngine", "performImplicitSchemaSwitch"));
        }
        this.getDataAuditor().print(this.getRequestContext(), setSchemaSql);
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(setSchemaSql);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            if (statement != null) {
                this.printWarnings(statement);
            }
            String errorMessage = JdbcEngine.getErrorMessage(e, statement, this.myDataSource.getName(), this.myDataSource.getFamilyId());
            this.getDataAuditor().print(this.getRequestContext(), "Failed to switch schema.\n" + errorMessage);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    this.getDataAuditor().print(this.getRequestContext(), JdbcEngine.getErrorMessage(e, statement, this.myDataSource.getName(), this.myDataSource.getFamilyId()));
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performExplicitSchemaSwitch(@NotNull Connection connection, @NotNull String setSchemaSql) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine", "performExplicitSchemaSwitch"));
        }
        if (setSchemaSql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setSchemaSql", "com/intellij/database/console/JdbcEngine", "performExplicitSchemaSwitch"));
        }
        Statement statement = null;
        try {
            statement = this.openStatement(connection, setSchemaSql, false);
            statement.execute(setSchemaSql);
            boolean bl = true;
            this.closeStatement(statement);
            return bl;
        }
        catch (SQLException e) {
            try {
                if (statement != null) {
                    this.printWarnings(statement);
                }
                this.getRequestContext().reportException(e, statement);
                this.closeStatement(statement);
            }
            catch (Throwable throwable) {
                this.closeStatement(statement);
                throw throwable;
            }
        }
        return false;
    }

    @NotNull
    public DatabaseDialectEx detectDatabaseDialect() {
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(this.myDataSource), (Object)GenericDialect.INSTANCE);
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "detectDatabaseDialect"));
        }
        return databaseDialectEx;
    }

    public void deleteRows(DataRequest.DeleteRequest request, DasTable table, List<DataConsumer.Column> columns, List<DataConsumer.Row> rows) {
        List<DataConsumer.Column> keyColumns = JdbcEngine.filterColumns(table, columns);
        List<Boolean> columnNullability = JdbcEngine.calcColumnsNullability(columns, rows);
        DdlBuilder builder = DbImplUtil.createBuilderForExec(this.myDialect);
        builder.keyword("DELETE").space().keyword("FROM").space().qualifiedRef((DasObject)table).space();
        builder.keyword("WHERE").space();
        List<DataConsumer.Column> whereParameterColumns = DbImplUtil.composeWhereConditionWithParameters(builder, keyColumns, columnNullability, null, this.myDialect);
        String sql = builder.getStatement();
        ArrayList params = ContainerUtil.newArrayList();
        for (DataConsumer.Row row : rows) {
            params.add(JdbcEngine.rowValues(whereParameterColumns, row));
        }
        this.executeUpdateStatement(request, sql, whereParameterColumns, params);
    }

    public void updateRows(DataRequest.UpdateRequest request, DasTable table, List<DataConsumer.Column> columns, List<DataConsumer.Row> rows, List<DataConsumer.Column> columnsToUpdate, Object newValue) {
        List<DataConsumer.Column> keyColumns = JdbcEngine.filterColumns(table, columns);
        List<Boolean> nullability = JdbcEngine.calcColumnsNullability(columns, rows);
        DatabaseFamilyId familyId = this.myDialect.getFamilyId();
        boolean alias = !familyId.isSqlite() && !familyId.isPostgres() && !familyId.isTransactSql();
        DdlBuilder builder = DbImplUtil.createBuilderForExec(this.myDialect);
        builder.keyword("UPDATE").space().qualifiedRef((DasObject)table).space();
        if (alias) {
            builder.alias("t").space();
        }
        boolean setDefault = newValue == ReservedCellValue.DEFAULT;
        builder.keyword("SET").space();
        boolean first = true;
        for (DataConsumer.Column targetColumn : columnsToUpdate) {
            if (!first) {
                builder.symbol(",").space();
            } else {
                first = false;
            }
            if (alias) {
                builder.alias("t").symbol(".");
            }
            builder.identifier(targetColumn.name).space().symbol("=").space();
            if (setDefault) {
                builder.keyword("DEFAULT");
                continue;
            }
            builder.symbol("?");
        }
        builder.space().keyword("WHERE").space();
        List<DataConsumer.Column> whereParameterColumns = DbImplUtil.composeWhereConditionWithParameters(builder, keyColumns, nullability, alias ? "t" : null, this.myDialect);
        String sql = builder.getStatement();
        ArrayList paramColumns = ContainerUtil.newArrayList();
        if (!setDefault) {
            paramColumns.addAll(columnsToUpdate);
        }
        paramColumns.addAll(whereParameterColumns);
        ArrayList params = ContainerUtil.newArrayList();
        for (DataConsumer.Row row : rows) {
            ArrayList p = ContainerUtil.newArrayListWithCapacity((int)paramColumns.size());
            if (!setDefault) {
                for (int i = 0; i < columnsToUpdate.size(); ++i) {
                    p.add(newValue);
                }
            }
            p.addAll(JdbcEngine.rowValues(whereParameterColumns, row));
            params.add(p);
        }
        this.executeUpdateStatement(request, sql, paramColumns, params);
    }

    @NotNull
    private static List<Boolean> calcColumnsNullability(List<DataConsumer.Column> columns, List<DataConsumer.Row> rows) {
        ArrayList nullValues = ContainerUtil.newArrayListWithCapacity((int)columns.size());
        for (DataConsumer.Column column : columns) {
            DataConsumer.Row row;
            boolean nullValue;
            boolean hasNulls = false;
            boolean hasValues = false;
            Iterator<DataConsumer.Row> iterator = rows.iterator();
            while (!(!iterator.hasNext() || (hasNulls |= (nullValue = column.getValue(row = iterator.next()) == null)) && (hasValues |= !nullValue))) {
            }
            nullValues.add(hasNulls && hasValues ? null : (hasNulls ? Boolean.TRUE : Boolean.FALSE));
        }
        ArrayList arrayList = nullValues;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "calcColumnsNullability"));
        }
        return arrayList;
    }

    public void insertRows(DataRequest.InsertRequest request, DasTable table, List<DataConsumer.Column> columns, List<DataConsumer.Row> rows) {
        DatabaseDialectEx dialect = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(this.myDataSource), (Object)GenericDialect.INSTANCE);
        DdlBuilder builder = DbImplUtil.createBuilderForExec(dialect);
        ArrayList colNames = ContainerUtil.newArrayList();
        ArrayList colValues = ContainerUtil.newArrayList();
        ArrayList columnsCopy = ContainerUtil.newArrayList();
        for (DataConsumer.Column column : columns) {
            ReservedCellValue reason = JdbcEngine.skipColumnReason(column, rows);
            if (reason == ReservedCellValue.GENERATED) {
                if (!dialect.supportsInsertDefaultIntoAutoVal()) continue;
                reason = ReservedCellValue.DEFAULT;
            }
            colNames.add(column.name);
            if (reason == ReservedCellValue.DEFAULT) {
                colValues.add("DEFAULT");
                continue;
            }
            columnsCopy.add(column);
            colValues.add("?");
        }
        dialect.sqlInsertInto(builder, table, colNames, colValues);
        String sql = builder.getStatement();
        ArrayList<List<Object>> params = new ArrayList<List<Object>>();
        for (DataConsumer.Row row : rows) {
            params.add(JdbcEngine.rowValues(columnsCopy, row));
        }
        this.executeUpdateStatement(request, sql, columnsCopy, params);
    }

    @Nullable
    private static ReservedCellValue skipColumnReason(@NotNull DataConsumer.Column column, @NotNull List<DataConsumer.Row> rows) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/console/JdbcEngine", "skipColumnReason"));
        }
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/console/JdbcEngine", "skipColumnReason"));
        }
        ReservedCellValue result = null;
        for (DataConsumer.Row row : rows) {
            Object value = column.getValue(row);
            if (value != ReservedCellValue.DEFAULT && value != ReservedCellValue.GENERATED) {
                return null;
            }
            if (result == null) {
                result = (ReservedCellValue)((Object)value);
                continue;
            }
            if (result == value) continue;
            return null;
        }
        return result;
    }

    @NotNull
    private static ArrayList<Object> rowValues(@NotNull List<DataConsumer.Column> columns, @NotNull DataConsumer.Row row) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/console/JdbcEngine", "rowValues"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/console/JdbcEngine", "rowValues"));
        }
        ArrayList values = ContainerUtil.newArrayListWithCapacity((int)columns.size());
        for (DataConsumer.Column column : columns) {
            values.add(column.getValue(row));
        }
        ArrayList arrayList = values;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "rowValues"));
        }
        return arrayList;
    }

    @NotNull
    private static List<DataConsumer.Column> filterColumns(@NotNull DasTable table, @NotNull List<DataConsumer.Column> columns) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/console/JdbcEngine", "filterColumns"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/console/JdbcEngine", "filterColumns"));
        }
        DasTableKey primaryKey = DasUtil.getPrimaryKey((DasTable)table);
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)columns.size());
        if (primaryKey != null) {
            THashSet set = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            ContainerUtil.addAll((Collection)set, (Iterable)primaryKey.getColumnsRef().names());
            for (DataConsumer.Column column : columns) {
                if (!set.contains(column.name)) continue;
                result.add(column);
            }
        }
        if (result.isEmpty() || primaryKey == null) {
            for (DataConsumer.Column column : columns) {
                if (column.type == 2004 || column.type == 2005) continue;
                result.add(column);
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "filterColumns"));
        }
        return arrayList;
    }

    public void executeUpdateStatement(DataRequest.DmlRequest request, final String sql, final List<DataConsumer.Column> columns, final List<List<Object>> params) {
        this.submitRequest(request, new ThrowableComputable<Boolean, Exception>(){

            public Boolean compute() throws Exception {
                return JdbcEngine.this.executeUpdateStatementInner(sql, columns, params);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeUpdateStatementInner(@NotNull String sql, @NotNull List<DataConsumer.Column> columns, @NotNull List<List<Object>> params) throws Exception {
        if (sql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sql", "com/intellij/database/console/JdbcEngine", "executeUpdateStatementInner"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/console/JdbcEngine", "executeUpdateStatementInner"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/database/console/JdbcEngine", "executeUpdateStatementInner"));
        }
        Connection connection = this.getConnection();
        if (connection == null) {
            return false;
        }
        UnexpectedUpdatesGuard guard = connection.getAutoCommit() ? new AutoCommitGuard(connection, sql) : new AutoCommitOffGuard(connection, sql);
        try {
            List<Integer> updateCounts = this.executeUpdateStatementAndGetUpdateCounts(connection, sql, columns, params);
            boolean bl = guard.updateComplete(updateCounts);
            return bl;
        }
        finally {
            guard.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<Integer> executeUpdateStatementAndGetUpdateCounts(@NotNull Connection connection, @NotNull String sql, @NotNull List<DataConsumer.Column> columns, @NotNull List<List<Object>> params) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine", "executeUpdateStatementAndGetUpdateCounts"));
        }
        if (sql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sql", "com/intellij/database/console/JdbcEngine", "executeUpdateStatementAndGetUpdateCounts"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/console/JdbcEngine", "executeUpdateStatementAndGetUpdateCounts"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/database/console/JdbcEngine", "executeUpdateStatementAndGetUpdateCounts"));
        }
        int escapeIdx = StringUtil.startsWithIgnoreCase((String)sql, (String)"update") ? 1 : (StringUtil.startsWithIgnoreCase((String)sql, (String)"delete") ? 0 : columns.size());
        PreparedStatement statement = null;
        ArrayList updateCounts = ContainerUtil.newArrayListWithCapacity((int)params.size());
        try {
            statement = this.openPreparedStatement(connection, sql);
            for (List<Object> list : params) {
                for (int i = 0; i < columns.size(); ++i) {
                    DbImplUtil.setStatementParameter(statement, i + 1, columns.get(i), list.get(i), i > escapeIdx, this.myDialect);
                }
                updateCounts.add(statement.executeUpdate());
            }
            int updateCountTotal = 0;
            for (Integer updateCount : updateCounts) {
                updateCountTotal += updateCount.intValue();
            }
            this.getDataAuditor().updateCountReceived(this.getRequestContext(), updateCountTotal);
        }
        catch (Exception e) {
            updateCounts = null;
            this.getRequestContext().reportException(e, statement);
        }
        finally {
            this.closeStatement(statement);
        }
        return updateCounts;
    }

    public static void handleException(@NotNull DataRequest.Context context, @NotNull Throwable th, @Nullable Statement statement, @NotNull DataAuditor dataAuditor, @NotNull DatabaseSystem dataSource) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/JdbcEngine", "handleException"));
        }
        if (th == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "th", "com/intellij/database/console/JdbcEngine", "handleException"));
        }
        if (dataAuditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataAuditor", "com/intellij/database/console/JdbcEngine", "handleException"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/JdbcEngine", "handleException"));
        }
        if (th instanceof ProcessCanceledException) {
            return;
        }
        String message = JdbcEngine.getErrorMessage(th, statement, dataSource.getName(), DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource));
        dataAuditor.error(context, message, null);
    }

    @NotNull
    public static String getErrorMessage(Throwable th, Statement statement, String sourceName, DatabaseFamilyId familyId) {
        StringBuilder sb = new StringBuilder();
        if (statement != null) {
            try {
                for (SQLWarning warnings = statement.getWarnings(); warnings != null; warnings = warnings.getNextWarning()) {
                    sb.append(JdbcEngine.getSqlExceptionCode(warnings)).append(JdbcEngine.getMessage(warnings)).append("\n");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JdbcEngine.appendErrorMessage(sb, th, sourceName, familyId);
        String string = sb.toString().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "getErrorMessage"));
        }
        return string;
    }

    private static StringBuilder appendErrorMessage(@NotNull StringBuilder sb, @NotNull Throwable e, @NotNull String processName, @NotNull DatabaseFamilyId familyId) {
        String localizedMessage;
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/console/JdbcEngine", "appendErrorMessage"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/JdbcEngine", "appendErrorMessage"));
        }
        if (processName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processName", "com/intellij/database/console/JdbcEngine", "appendErrorMessage"));
        }
        if (familyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyId", "com/intellij/database/console/JdbcEngine", "appendErrorMessage"));
        }
        Throwable t = ExceptionUtil.getRootCause((Throwable)e);
        if (e != t && e instanceof SQLException && StringUtil.indexOf((CharSequence)sb, (CharSequence)(localizedMessage = JdbcEngine.getMessage(e))) == -1) {
            sb.append(JdbcEngine.getSqlExceptionCode((SQLException)e)).append(localizedMessage).append("\n");
        }
        if (t instanceof SQLException) {
            localizedMessage = JdbcEngine.getMessage(t);
            if (StringUtil.indexOf((CharSequence)sb, (CharSequence)localizedMessage) == -1) {
                sb.append(JdbcEngine.getSqlExceptionCode((SQLException)t)).append(localizedMessage);
            }
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
            if (StringUtil.contains((CharSequence)sb, (CharSequence)"ORA-12705:")) {
                sb.append("\n").append(DatabaseMessages.message((String)"error.message.ora.nls", (Object[])new Object[]{processName}));
            }
        } else if (t instanceof RemoteException) {
            sb.append(t.toString());
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
        } else if (t instanceof EOFException && e instanceof RemoteException) {
            sb.append(processName).append(": process exited");
        } else if (t instanceof IOException) {
            sb.append(t.toString());
        } else if (t instanceof ExecutionException) {
            sb.append(JdbcEngine.getMessage(t));
        } else if (t instanceof SuppressUserStackTrace) {
            sb.append(JdbcEngine.getMessage(t));
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
        } else if (t instanceof UnsafeUpdateRolledBackException) {
            sb.append(t.getMessage());
        } else if (t instanceof OutOfMemoryError) {
            sb.append(DatabaseMessages.message((String)"error.message.remote.oomerror", (Object[])new Object[]{processName}));
            LOG.info(t);
        } else if (t instanceof RuntimeException && familyId.isDerby() && sb.length() > 0) {
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
        } else {
            sb.append(ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG));
        }
        return sb;
    }

    @NotNull
    public static String getMessage(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/database/console/JdbcEngine", "getMessage"));
        }
        String m = (String)ObjectUtils.chooseNotNull((Object)t.getLocalizedMessage(), (Object)t.getMessage());
        String string = StringUtil.isNotEmpty((String)m) ? m : t.getClass().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "getMessage"));
        }
        return string;
    }

    @NotNull
    public static String getSqlExceptionCode(@NotNull SQLException e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/JdbcEngine", "getSqlExceptionCode"));
        }
        String state = e.getSQLState();
        int code = e.getErrorCode();
        if (StringUtil.isEmpty((String)state)) {
            String string = code != 0 ? "[" + code + "] " : "";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "getSqlExceptionCode"));
            }
            return string;
        }
        if (code != 0) {
            String string = "[" + state + "][" + code + "] ";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "getSqlExceptionCode"));
            }
            return string;
        }
        String string = "[" + state + "] ";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "getSqlExceptionCode"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int printResultSet(@NotNull ResultSet resultSet, int resultSetIndex, int start, int pageSize, int chunkSize) throws Exception {
        int rowCount;
        block19: {
            if (resultSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/database/console/JdbcEngine", "printResultSet"));
            }
            this.checkCanceled();
            DataRequest request = this.getRequestContext().request;
            DataConsumer handler = this.getDataConsumer();
            if (request instanceof DataRequest.IsolatedQueryRequest) {
                handler = (DataConsumer)((Object)request);
            }
            if (start < 0) {
                handler = new LastPageHandler(handler, start, pageSize);
                pageSize = -1;
            }
            RemoteResultSet remoteResultSet = (RemoteResultSet)ObjectUtils.assertNotNull((Object)RemoteUtil.castToRemote((Object)resultSet, RemoteResultSet.class));
            DataConsumer.Column[] columnsDescr = JdbcEngine.getColumnDescriptors(resultSet, this.myDialect);
            handler.setColumns(this.getRequestContext(), resultSetIndex, columnsDescr, Math.max(1, start));
            rowCount = 0;
            int rowNum = 0;
            boolean hasNext = true;
            ArrayList<DataConsumer.Row> rows = ContainerUtil.newArrayListWithCapacity((int)chunkSize);
            try {
                rowNum = remoteResultSet.scrollToPosition(0, start - 1);
                if (request instanceof DataRequest.RawQueryRequest) {
                    while (hasNext = resultSet.next()) {
                        this.checkCanceled();
                        DataConsumer.Row row = JdbcEngine.getCurrentRow(resultSet, columnsDescr, ++rowNum, this.myDialect);
                        handler.addRows(this.getRequestContext(), Collections.singletonList(row));
                        if (pageSize <= 0 || ++rowCount < pageSize) continue;
                        break block19;
                    }
                    break block19;
                }
                int maxLobLength = DatabaseSettings.getSettings().getMaxLobLength();
                while (hasNext) {
                    int rowsToLoad;
                    this.checkCanceled();
                    int n = rowsToLoad = pageSize > 0 ? Math.min(chunkSize, pageSize - rowCount) : chunkSize;
                    if (rowsToLoad == 0) break;
                    List data = (List)RemoteUtil.handleRemoteResult((Object)remoteResultSet.getObjects(rowsToLoad, this.myDialect.getClass().getSimpleName(), maxLobLength), List.class, (Object)this);
                    hasNext = data.size() == rowsToLoad;
                    rowCount += data.size();
                    for (Object[] rowData : data) {
                        rows.add(new DataConsumer.Row(++rowNum, rowData));
                        if (rows.size() != chunkSize) continue;
                        handler.addRows(this.getRequestContext(), (List<DataConsumer.Row>)rows);
                        rows = new ArrayList<DataConsumer.Row>(chunkSize);
                    }
                }
                if (hasNext) {
                    hasNext = remoteResultSet.next();
                }
            }
            finally {
                if (!rows.isEmpty()) {
                    handler.addRows(this.getRequestContext(), (List<DataConsumer.Row>)rows);
                }
                if (start < 0) {
                    rowCount = ((LastPageHandler)handler).getRowCount();
                }
                try {
                    if (hasNext && rowCount != 0) {
                        ++rowNum;
                    }
                }
                finally {
                    handler.afterLastRowAdded(this.getRequestContext(), rowNum);
                }
            }
        }
        return rowCount;
    }

    public static DataConsumer.Column[] getColumnDescriptors(ResultSet resultSet, DatabaseDialect dialect) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int count = metaData.getColumnCount();
        DataConsumer.Column[] columnsDescr = new DataConsumer.Column[count];
        int columnNum = 0;
        for (int i = 1; i <= count; ++i) {
            String name = null;
            try {
                name = metaData.getColumnLabel(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String typeName = null;
            try {
                typeName = metaData.getColumnTypeName(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int type = 1111;
            try {
                type = metaData.getColumnType(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String clazz = null;
            try {
                clazz = metaData.getColumnClassName(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String catalog = null;
            try {
                catalog = metaData.getCatalogName(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String schema = null;
            try {
                schema = metaData.getSchemaName(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String table = null;
            try {
                table = metaData.getTableName(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int precision = -1;
            try {
                precision = metaData.getPrecision(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int scale = -1;
            try {
                scale = metaData.getScale(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dialect.getFamilyId().isMysql()) {
                if (type == 91 && "YEAR".equals(typeName) && "java.lang.Short".equals(clazz)) {
                    type = 5;
                }
            } else if (dialect.getFamilyId().isPostgres()) {
                if (Arrays.asList("bit", "varbit", "tid", "uuid").contains(typeName)) {
                    type = 12;
                } else if ("money".equals(typeName)) {
                    type = 1111;
                }
            } else if (dialect.getFamilyId().isOracle()) {
                if (type == -101 || type == -102) {
                    type = 93;
                } else if (type == 2007) {
                    type = 12;
                }
            } else if (dialect.getFamilyId().isSqlite()) {
                catalog = "";
            }
            columnsDescr[i - 1] = new DataConsumer.Column(columnNum++, name, type, typeName, clazz, precision, scale, catalog, schema, table);
        }
        return columnsDescr;
    }

    private void checkCanceled() {
        if (this.myCurrentStatement == null) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    private Statement openStatement(@NotNull Connection connection, @NotNull String sql, boolean withScrollableResultSet) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine", "openStatement"));
        }
        if (sql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sql", "com/intellij/database/console/JdbcEngine", "openStatement"));
        }
        if (this.myCurrentStatement != null) {
            throw new AssertionError();
        }
        this.getRequestContext().query.set((Object)sql);
        this.getDataAuditor().requestStarted(this.getRequestContext());
        Statement statement = this.myCurrentStatement = this.openStatement(connection, withScrollableResultSet);
        if (statement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "openStatement"));
        }
        return statement;
    }

    @NotNull
    private Statement openStatement(@NotNull Connection connection, boolean withScrollableResultSet) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine", "openStatement"));
        }
        Statement statement = withScrollableResultSet && Registry.is((String)"database.scrollable.result.sets") ? this.openStatementWithScrollableResultSetType(connection) : null;
        Statement statement2 = statement != null ? statement : connection.createStatement();
        if (statement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "openStatement"));
        }
        return statement2;
    }

    @Nullable
    private Statement openStatementWithScrollableResultSetType(@NotNull Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine", "openStatementWithScrollableResultSetType"));
        }
        try {
            if (this.myDialect.getFamilyId().isDb2()) {
                return null;
            }
            if (connection.getMetaData().supportsResultSetType(1004)) {
                return connection.createStatement(1004, 1007);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to create a statement with a scrollable result set type", (Throwable)e);
        }
        return null;
    }

    @NotNull
    private PreparedStatement openPreparedStatement(@NotNull Connection connection, @NotNull String sql) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine", "openPreparedStatement"));
        }
        if (sql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sql", "com/intellij/database/console/JdbcEngine", "openPreparedStatement"));
        }
        if (this.myCurrentStatement != null) {
            throw new AssertionError();
        }
        this.getRequestContext().query.set((Object)sql);
        this.getDataAuditor().requestStarted(this.getRequestContext());
        PreparedStatement result = connection.prepareStatement(sql);
        this.myCurrentStatement = result;
        PreparedStatement preparedStatement = result;
        if (preparedStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine", "openPreparedStatement"));
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStatement(Statement statement) {
        block11: {
            try {
                if (statement == null) break block11;
                try {
                    if (this.myConnection != null) {
                        statement.close();
                    }
                }
                catch (Exception e) {
                    this.getRequestContext().reportException(e, statement);
                }
                this.myCurrentStatement = null;
            }
            finally {
                try {
                    this.getDataAuditor().requestFinished(this.getRequestContext());
                }
                finally {
                    this.getRequestContext().query.set(null);
                }
            }
        }
    }

    @Override
    public void dispose() {
        final Connection connection = this.myConnection;
        this.myConnection = null;
        if (connection != null) {
            this.submitRunnable(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        JdbcUtil.closeConnectionSafe((Connection)connection);
                    }
                }
            });
        }
        super.dispose();
    }

    private static DataConsumer.Row getCurrentRow(ResultSet resultSet, DataConsumer.Column[] columnsDescr, int rowNum, DatabaseDialect dialect) throws SQLException {
        Object[] objects = new Object[columnsDescr.length];
        for (int i = 1; i <= columnsDescr.length; ++i) {
            Object o;
            block6: {
                DataConsumer.Column column = columnsDescr[i - 1];
                int jdbcType = ExtractorsUtil.guessJdbcType(column);
                if (jdbcType == 2004 || jdbcType == 2005) {
                    try {
                        if (jdbcType == 2004) {
                            o = resultSet.getBlob(i);
                            break block6;
                        }
                        o = resultSet.getClob(i);
                    }
                    catch (SQLException e) {
                        o = resultSet.getObject(i);
                    }
                } else {
                    o = dialect.getFamilyId().isPostgres() && ("bit".equals(column.typeName) || "varbit".equals(column.typeName)) ? resultSet.getString(i) : resultSet.getObject(i);
                }
            }
            objects[i - 1] = o;
        }
        return new DataConsumer.Row(rowNum, objects);
    }

    private static class UnsafeUpdateRolledBackException
    extends Exception {
        public UnsafeUpdateRolledBackException(String message) {
            super(message);
        }
    }

    class AutoCommitOffGuard
    extends UnexpectedUpdatesGuard {
        private final RemoteSavepoint mySavepoint;
        private boolean myRollback;

        public AutoCommitOffGuard(@NotNull Connection connection, String statement) {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$AutoCommitOffGuard", "<init>"));
            }
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/console/JdbcEngine$AutoCommitOffGuard", "<init>"));
            }
            super(connection, statement);
            this.myRollback = true;
            this.mySavepoint = this.trySetSavepoint();
        }

        @Override
        public boolean updateComplete(@Nullable List<Integer> updateCounts) {
            boolean unexpectedUpdateCount = updateCounts != null && this.hasUnexpectedUpdateCount(updateCounts);
            boolean bl = this.myRollback = updateCounts == null || unexpectedUpdateCount;
            if (unexpectedUpdateCount) {
                if (this.mySavepoint != null) {
                    this.reportChangesWillBeRolledBack();
                } else {
                    this.reportUnexpectedUpdateCount();
                }
            }
            return !this.myRollback;
        }

        @Override
        public void free() throws Exception {
            if (this.mySavepoint == null) {
                return;
            }
            RemoteConnection connection = this.getRemoteConnection();
            try {
                if (this.myRollback) {
                    connection.rollback(this.mySavepoint);
                }
            }
            catch (SQLException e) {
                throw new SQLException(DatabaseMessages.message((String)"message.text.error.failed.to.rollback.to.a.savepoint", (Object[])new Object[0]), e);
            }
            finally {
                try {
                    connection.releaseSavepoint(this.mySavepoint);
                }
                catch (SQLException sQLException) {}
            }
        }

        @Nullable
        private RemoteSavepoint trySetSavepoint() {
            RemoteConnection connection = this.getRemoteConnection();
            try {
                if (!connection.getMetaData().supportsSavepoints()) {
                    return null;
                }
                return connection.setSavepoint();
            }
            catch (Exception e) {
                LOG.info("Exception while setting an unnamed savepoint", (Throwable)e);
                return null;
            }
        }

        private void reportUnexpectedUpdateCount() {
            String message = DatabaseMessages.message((String)"message.text.error.unexpected.update.count", (Object[])new Object[0]) + " Rollback the current transaction to undo changes made by: \n" + this.myStatement;
            JdbcEngine.this.getDataAuditor().print(JdbcEngine.this.getRequestContext(), message);
        }

        @NotNull
        private RemoteConnection getRemoteConnection() {
            RemoteConnection remoteConnection = (RemoteConnection)ObjectUtils.assertNotNull((Object)RemoteUtil.castToRemote((Object)this.myGuardedConnection, RemoteConnection.class));
            if (remoteConnection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine$AutoCommitOffGuard", "getRemoteConnection"));
            }
            return remoteConnection;
        }
    }

    class AutoCommitGuard
    extends UnexpectedUpdatesGuard {
        private boolean myRollback;

        public AutoCommitGuard(@NotNull Connection connection, String statement) throws SQLException {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$AutoCommitGuard", "<init>"));
            }
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/console/JdbcEngine$AutoCommitGuard", "<init>"));
            }
            super(connection, statement);
            this.myRollback = true;
            this.myGuardedConnection.setAutoCommit(false);
        }

        @Override
        public boolean updateComplete(@Nullable List<Integer> updateCounts) {
            boolean unexpectedUpdateCount = updateCounts != null && this.hasUnexpectedUpdateCount(updateCounts);
            boolean bl = this.myRollback = updateCounts == null || unexpectedUpdateCount;
            if (unexpectedUpdateCount) {
                this.reportChangesWillBeRolledBack();
            }
            return !this.myRollback;
        }

        @Override
        public void free() throws Exception {
            if (this.myRollback) {
                this.myGuardedConnection.rollback();
            } else {
                this.myGuardedConnection.commit();
            }
            this.myGuardedConnection.setAutoCommit(true);
        }
    }

    private abstract class UnexpectedUpdatesGuard {
        protected final Connection myGuardedConnection;
        protected final String myStatement;

        public UnexpectedUpdatesGuard(@NotNull Connection connection, String statement) {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$UnexpectedUpdatesGuard", "<init>"));
            }
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/console/JdbcEngine$UnexpectedUpdatesGuard", "<init>"));
            }
            this.myGuardedConnection = connection;
            this.myStatement = statement;
        }

        public abstract boolean updateComplete(@Nullable List<Integer> var1);

        public abstract void free() throws Exception;

        protected boolean hasUnexpectedUpdateCount(@NotNull List<Integer> updateCounts) {
            if (updateCounts == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateCounts", "com/intellij/database/console/JdbcEngine$UnexpectedUpdatesGuard", "hasUnexpectedUpdateCount"));
            }
            for (Integer updateCount : updateCounts) {
                if (updateCount <= 1) continue;
                return true;
            }
            return false;
        }

        protected void reportChangesWillBeRolledBack() {
            String message = DatabaseMessages.message((String)"message.text.error.unexpected.update.count", (Object[])new Object[0]) + " Changes will be rolled back. SQL: \n" + this.myStatement;
            JdbcEngine.this.getRequestContext().reportException(new UnsafeUpdateRolledBackException(message), null);
        }
    }

    private static class LastPageHandler
    implements DataConsumer {
        private final DataConsumer delegate;
        private int resultSetIndex;
        private DataConsumer.Column[] columnInfos;
        private RowsCyclicBuffer myBuffer;

        public LastPageHandler(DataConsumer handler, int start, int size) {
            this.delegate = handler;
            this.myBuffer = new RowsCyclicBuffer(Math.max(size, -start));
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] infos, int firstRowNum) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/JdbcEngine$LastPageHandler", "setColumns"));
            }
            this.resultSetIndex = resultSetIndex;
            this.columnInfos = infos;
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/JdbcEngine$LastPageHandler", "addRows"));
            }
            this.myBuffer.addRows(rows);
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/JdbcEngine$LastPageHandler", "afterLastRowAdded"));
            }
            List<DataConsumer.Row> rows = this.myBuffer.getRows();
            if (rows.isEmpty()) {
                this.delegate.setColumns(context, this.resultSetIndex, this.columnInfos, 0);
                this.delegate.afterLastRowAdded(context, 0);
                return;
            }
            this.delegate.setColumns(context, this.resultSetIndex, this.columnInfos, rows.get((int)0).rowNum);
            this.delegate.addRows(context, rows);
            this.delegate.afterLastRowAdded(context, total);
        }

        public int getRowCount() {
            return this.myBuffer.getRows().size();
        }

        private static class RowsCyclicBuffer {
            private final DataConsumer.Row[] myBuffer;
            private int myFirstIdx = 0;
            private int myLastIdx = -1;

            public RowsCyclicBuffer(int bufferSize) {
                this.myBuffer = new DataConsumer.Row[bufferSize];
            }

            public void addRows(@NotNull Iterable<DataConsumer.Row> rows) {
                if (rows == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/console/JdbcEngine$LastPageHandler$RowsCyclicBuffer", "addRows"));
                }
                for (DataConsumer.Row row : rows) {
                    if (this.myLastIdx != -1 && this.nextIdx(this.myLastIdx) == this.myFirstIdx) {
                        this.myFirstIdx = this.nextIdx(this.myFirstIdx);
                    }
                    this.myLastIdx = this.nextIdx(this.myLastIdx);
                    this.myBuffer[this.myLastIdx] = row;
                }
            }

            @NotNull
            public List<DataConsumer.Row> getRows() {
                if (this.myLastIdx == -1) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine$LastPageHandler$RowsCyclicBuffer", "getRows"));
                    }
                    return list;
                }
                if (this.myFirstIdx == 0) {
                    List list = ContainerUtil.newArrayList((Object[])this.myBuffer, (int)0, (int)(this.myLastIdx + 1));
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine$LastPageHandler$RowsCyclicBuffer", "getRows"));
                    }
                    return list;
                }
                ArrayList rows = ContainerUtil.newArrayListWithCapacity((int)this.myBuffer.length);
                ImmutableList bufferAsList = ContainerUtil.immutableList((Object[])this.myBuffer);
                rows.addAll(bufferAsList.subList(this.myFirstIdx, this.myBuffer.length));
                rows.addAll(bufferAsList.subList(0, this.myLastIdx + 1));
                ArrayList arrayList = rows;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine$LastPageHandler$RowsCyclicBuffer", "getRows"));
                }
                return arrayList;
            }

            private int nextIdx(int idx) {
                return (idx + 1) % this.myBuffer.length;
            }
        }
    }
}

