/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv;

import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CsvFormat {
    public final String name;
    public final CsvRecordFormat dataRecord;
    public final CsvRecordFormat headerRecord;
    public final boolean rowNumbers;

    public CsvFormat(@NotNull CsvRecordFormat dataRecord, @Nullable CsvRecordFormat headerRecord, boolean rowNumbers) {
        if (dataRecord == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataRecord", "com/intellij/database/csv/CsvFormat", "<init>"));
        }
        this("", dataRecord, headerRecord, rowNumbers);
    }

    public CsvFormat(@NotNull String name, @NotNull CsvRecordFormat dataRecord, @Nullable CsvRecordFormat headerRecord, boolean rowNumbers) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/csv/CsvFormat", "<init>"));
        }
        if (dataRecord == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataRecord", "com/intellij/database/csv/CsvFormat", "<init>"));
        }
        this.name = name;
        this.dataRecord = dataRecord;
        this.headerRecord = headerRecord;
        this.rowNumbers = rowNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CsvFormat)) {
            return false;
        }
        CsvFormat format = (CsvFormat)o;
        if (this.rowNumbers != format.rowNumbers) {
            return false;
        }
        if (!this.name.equals(format.name)) {
            return false;
        }
        if (!this.dataRecord.equals(format.dataRecord)) {
            return false;
        }
        return !(this.headerRecord != null ? !this.headerRecord.equals(format.headerRecord) : format.headerRecord != null);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.dataRecord.hashCode();
        result = 31 * result + (this.headerRecord != null ? this.headerRecord.hashCode() : 0);
        result = 31 * result + (this.rowNumbers ? 1 : 0);
        return result;
    }

    public static int indexOfFormatNamed(@NotNull List<CsvFormat> formats, final @Nullable String name) {
        if (formats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "com/intellij/database/csv/CsvFormat", "indexOfFormatNamed"));
        }
        return name == null ? -1 : ContainerUtil.indexOf(formats, (Condition)new Condition<CsvFormat>(){

            public boolean value(CsvFormat format) {
                return StringUtil.equals((CharSequence)name, (CharSequence)format.name);
            }
        });
    }
}

