/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.DatabaseModelLoader;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.JdbcOperation;
import com.intellij.database.util.LoaderContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDataSource
extends DataSource {
    private final AtomicReference<Pair<ProgressIndicator, LoaderContext>> myCurrentProgressIndicator = new AtomicReference();

    public boolean refreshMetaData(Project project, final @NotNull LoaderContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/AbstractDataSource", "refreshMetaData"));
        }
        Boolean result = this.performJdbcOperation(project, context.getErrorHandler(), new JdbcOperation<Boolean>(){

            public Boolean perform(@NotNull Connection connection, @NotNull ProgressIndicator indicator) throws Exception {
                if (connection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/AbstractDataSource$1", "perform"));
                }
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/AbstractDataSource$1", "perform"));
                }
                AbstractDataSource.this.refreshMetaData(connection, context, indicator);
                return true;
            }
        });
        return result != null && result != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshMetaData(@NotNull Connection connection, @NotNull LoaderContext context, @NotNull ProgressIndicator indicator) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/AbstractDataSource", "refreshMetaData"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/AbstractDataSource", "refreshMetaData"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/AbstractDataSource", "refreshMetaData"));
        }
        indicator.checkCanceled();
        Pair pair = Pair.create((Object)indicator, (Object)context);
        Pair<ProgressIndicator, LoaderContext> prevPair = this.myCurrentProgressIndicator.getAndSet((Pair<ProgressIndicator, LoaderContext>)pair);
        if (prevPair != null) {
            ((ProgressIndicator)prevPair.first).cancel();
            for (Object o : ((LoaderContext)prevPair.second).getSelection()) {
                context.include(o);
            }
        }
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            this.refreshDatabaseInfo(metaData);
            if (!context.loadNothing()) {
                this.setupDefaults(connection);
                DatabaseModelLoader.performIntrospection(context, this.myState, connection, metaData, indicator);
            }
        }
        finally {
            this.myCurrentProgressIndicator.compareAndSet((Pair<ProgressIndicator, LoaderContext>)pair, null);
        }
    }

    protected void setupDefaults(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/AbstractDataSource", "setupDefaults"));
        }
    }

    @Nullable
    protected String getSchemaPattern() {
        return null;
    }

    @Nullable
    protected String getTablePattern() {
        return null;
    }

    protected boolean useLegacyIntrospector() {
        return false;
    }

    @Nullable
    public RawConnectionConfig getConnectionConfig() {
        return null;
    }

    @Nullable
    public Connection getConnection(Project project) throws Exception {
        throw new UnsupportedOperationException("getConnection() is not supported");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public <T> T performJdbcOperation(Project project, @NotNull ErrorHandler errorHandler, @NotNull JdbcOperation<T> operation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isRemote(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/AbstractDataSource", "isRemote"));
        }
        for (Throwable t = e; t != null; t = t.getCause()) {
            if (!(t instanceof RemoteException)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getSpecialMessage(@NotNull Throwable t, @NotNull String processName) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/database/dataSource/AbstractDataSource", "getSpecialMessage"));
        }
        if (processName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processName", "com/intellij/database/dataSource/AbstractDataSource", "getSpecialMessage"));
        }
        Throwable cause = ExceptionUtil.getRootCause((Throwable)t);
        boolean remote = AbstractDataSource.isRemote(t);
        String message = cause.getMessage();
        if (message == null) {
            return null;
        }
        if (cause instanceof SQLException && StringUtil.contains((CharSequence)message, (CharSequence)"ORA-12705:")) {
            return DatabaseMessages.message((String)"error.message.ora.nls", (Object[])new Object[]{processName});
        }
        if (cause instanceof OutOfMemoryError && remote) {
            return DatabaseMessages.message((String)"error.message.remote.oomerror", (Object[])new Object[]{processName});
        }
        return null;
    }
}

