/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.view.ui.DatabaseConfigController;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.BaseConfigurableWithChangeSupport;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDatabaseConfigurable<T>
extends BaseConfigurableWithChangeSupport
implements Disposable {
    protected final T myTarget;
    protected final Project myProject;
    protected DatabaseConfigController myController;

    protected AbstractDatabaseConfigurable(@NotNull Project project, @NotNull T target) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/AbstractDatabaseConfigurable", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/dataSource/AbstractDatabaseConfigurable", "<init>"));
        }
        this.myProject = project;
        this.myTarget = target;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/AbstractDatabaseConfigurable", "getProject"));
        }
        return project;
    }

    public T getTarget() {
        return this.myTarget;
    }

    public void setController(@NotNull DatabaseConfigController controller) {
        if (controller == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controller", "com/intellij/database/dataSource/AbstractDatabaseConfigurable", "setController"));
        }
        this.myController = controller;
    }

    public DatabaseConfigController getController() {
        return this.myController;
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }
}

