/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceGeneralPanel;
import com.intellij.database.dataSource.DataSourceManager;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LazyPasswordField;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSshSslPanel {
    private static final String AUTH_PASSWORD = "Password";
    private static final String AUTH_KEYPAIR = "Key pair (OpenSSH)";
    private final Project myProject;
    private final LocalDataSource myDataSource;
    @NotNull
    private final DataSourceConfigurable myDialog;
    private JPanel myPanel;
    private JTextField myProxyHostField;
    private JTextField myProxyPortField;
    private JTextField myUserField;
    private JBPasswordField myPasswordField;
    private JCheckBox myUseSshCheckBox;
    private JPanel mySettingContainerPanel;
    private ComboBox myAuthTypeCombo;
    private JBPasswordField myPassphraseField;
    private TextFieldWithBrowseButton myPrivateKeyFileField;
    private JBLabel myInfoLabel;
    private JBCheckBox myUseSSLJBCheckBox;
    private JPanel mySslPanel;
    private LinkLabel mySslCopyFrom;
    private LinkLabel mySshCopyFrom;
    private TextFieldWithBrowseButton myCaCertFileField;
    private TextFieldWithBrowseButton myClientCertFileField;
    private TextFieldWithBrowseButton myClientKeyFileField;
    private ThreeStateCheckBox myRememberPasswordCheckBox;
    private JPanel myPasswordPanel;
    private JPanel myCertificatePanel;
    private JButton myTestConnectionButton;
    private LazyPasswordField myPasswordLazyField;
    private LazyPasswordField myPassphraseLazyField;

    public DataSourceSshSslPanel(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DataSourceConfigurable dialog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DataSourceSshSslPanel", "<init>"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceSshSslPanel", "<init>"));
        }
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/dataSource/DataSourceSshSslPanel", "<init>"));
        }
        this.myProject = project;
        this.myDataSource = dataSource;
        this.myDialog = dialog;
        this.$$$setupUI$$$();
        this.myPanel.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        DataSourceSshTunnelConfiguration ssh = this.myDataSource.getSshConfiguration();
        DataSourceSslConfiguration ssl = this.myDataSource.getSslCfg();
        this.setupFromSshCfg(ssh);
        this.setupFromSslCfg(ssl);
        new UiNotifyConnector((Component)this.myPanel, new Activatable(){

            public void showNotify() {
                DataSourceSshSslPanel.this.refresh();
            }

            public void hideNotify() {
            }
        });
        this.myRememberPasswordCheckBox.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.MINI));
        this.myUseSshCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DataSourceSshSslPanel.this.updateSshPanel();
                DataSourceSshSslPanel.this.updateTestConnectionButton();
            }
        });
        if (!dataSource.supportsTunnelling()) {
            this.myInfoLabel.setVisible(true);
            this.myInfoLabel.setBorder((Border)new EmptyBorder(5, 10, 10, 10));
            this.myInfoLabel.setIcon(UIUtil.getBalloonErrorIcon());
            DatabaseDriver driver = dataSource.getDatabaseDriver();
            if (driver != null) {
                this.myInfoLabel.setText("Host/port parts not found in \"" + StringUtil.first((String)driver.getFullName(), (int)20, (boolean)true) + "\" URL template");
            } else {
                this.myInfoLabel.setText("SSH tunnelling not supported for standalone data sources");
            }
        } else {
            this.myInfoLabel.setVisible(false);
        }
        this.myAuthTypeCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(Arrays.asList(AUTH_PASSWORD, AUTH_KEYPAIR), (Object)(ssh == null || ssh.isUsePassword() ? AUTH_PASSWORD : AUTH_KEYPAIR)));
        this.myAuthTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSourceSshSslPanel.this.updateOnAuthTypeChange();
                Object focus = DataSourceSshSslPanel.this.myAuthTypeCombo.getSelectedItem() == DataSourceSshSslPanel.AUTH_PASSWORD ? DataSourceSshSslPanel.this.myPasswordField : DataSourceSshSslPanel.this.myPrivateKeyFileField.getTextField();
                IdeFocusManager.findInstanceByComponent((Component)focus).requestFocus((Component)focus, false);
            }
        });
        this.myUseSSLJBCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DataSourceSshSslPanel.this.updateSslPanel();
                DataSourceSshSslPanel.this.updateTestConnectionButton();
            }
        });
        this.myPrivateKeyFileField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                DataSourceSshSslPanel.this.updateNeedsPassphrase();
            }
        });
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, true, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return true;
            }
        };
        if ((SystemInfo.isLinux || SystemInfo.isMac) && StringUtil.isEmptyOrSpaces((String)this.myPrivateKeyFileField.getText())) {
            this.myPrivateKeyFileField.setText(DataSourceSshSslPanel.getSshDirectory());
        }
        this.myPrivateKeyFileField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener("Choose Private Key File", "", (ComponentWithBrowseButton)this.myPrivateKeyFileField, null, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
        this.myTestConnectionButton.setAction(dialog.getTestAction());
        DataSourceSshSslPanel.addListener("Choose SSL Certificate Authority File", this.myCaCertFileField);
        DataSourceSshSslPanel.addListener("Choose Client Certificate File", this.myClientCertFileField);
        DataSourceSshSslPanel.addListener("Choose Client Key File", this.myClientKeyFileField);
        this.updateSshPanel();
        this.updateSslPanel();
        this.updateTestConnectionButton();
    }

    private void updateTestConnectionButton() {
        UIUtil.setEnabled((Component)this.myTestConnectionButton, (this.myUseSSLJBCheckBox.isSelected() || this.myUseSshCheckBox.isSelected() ? 1 : 0) != 0, (boolean)true);
    }

    private void refresh() {
        this.myDialog.fireStateChanged();
    }

    public void updateSslPanel() {
        UIUtil.setEnabled((Component)this.mySslPanel, (boolean)this.myUseSSLJBCheckBox.isSelected(), (boolean)true);
        this.mySslCopyFrom.setVisible(this.myUseSSLJBCheckBox.isSelected());
    }

    private static void addListener(String title, TextFieldWithBrowseButton field) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, true, false, false);
        field.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener(title, "", (ComponentWithBrowseButton)field, null, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
    }

    @NotNull
    private static String getSshDirectory() {
        String userHome = SystemProperties.getUserHome();
        if (userHome != null) {
            String string = userHome + "/.ssh/";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshSslPanel", "getSshDirectory"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshSslPanel", "getSshDirectory"));
        }
        return "";
    }

    private void updateNeedsPassphrase() {
        if (StringUtil.isNotEmpty((String)this.myPrivateKeyFileField.getText())) {
            boolean needsPassphrase = true;
            File file = new File(this.myPrivateKeyFileField.getText());
            if (file.isFile() && file.canRead()) {
                try {
                    KeyPair keyPair = KeyPair.load((JSch)new JSch(), (String)file.getAbsolutePath());
                    needsPassphrase = keyPair == null || keyPair.isEncrypted();
                }
                catch (JSchException jSchException) {
                    // empty catch block
                }
            }
            if (needsPassphrase) {
                if (!this.myPassphraseField.isEnabled()) {
                    this.myPassphraseField.setEnabled(true);
                }
            } else {
                this.myPassphraseField.setEnabled(false);
            }
        } else {
            this.myPasswordField.setEnabled(true);
        }
    }

    private void updateOnAuthTypeChange() {
        boolean usePassword = this.myAuthTypeCombo.getSelectedItem() == AUTH_PASSWORD;
        UIUtil.setEnabled((Component)this.myPasswordPanel, (boolean)usePassword, (boolean)true);
        this.myPasswordPanel.setVisible(usePassword);
        UIUtil.setEnabled((Component)this.myCertificatePanel, (!usePassword ? 1 : 0) != 0, (boolean)true);
        this.myCertificatePanel.setVisible(!usePassword);
        this.updateNeedsPassphrase();
    }

    private void updateSshPanel() {
        this.updateOnAuthTypeChange();
        this.updateNeedsPassphrase();
        UIUtil.setEnabled((Component)this.mySettingContainerPanel, (boolean)this.myUseSshCheckBox.isSelected(), (boolean)true);
        this.mySshCopyFrom.setVisible(this.myUseSshCheckBox.isSelected());
    }

    @NotNull
    protected JPanel getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshSslPanel", "getComponent"));
        }
        return jPanel;
    }

    @Nullable
    public DataSourceSshTunnelConfiguration createSshConfig(@NotNull LocalDataSource ds, boolean copyCredentials) {
        if (ds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ds", "com/intellij/database/dataSource/DataSourceSshSslPanel", "createSshConfig"));
        }
        DatabaseCredentials.StorageType storageType = DataSourceGeneralPanel.getSecretStorageType(this.myRememberPasswordCheckBox.getState());
        boolean storeLocal = ds.getUniqueId() == null || storageType == DatabaseCredentials.StorageType.EMBEDDED;
        String password = storeLocal && copyCredentials ? PasswordUtil.encodePassword((String)this.getPassword()) : "";
        String passphrase = storeLocal && copyCredentials ? PasswordUtil.encodePassword((String)this.getPassphrase()) : "";
        DataSourceSshTunnelConfiguration result = new DataSourceSshTunnelConfiguration(this.myProxyHostField.getText().trim(), this.myProxyPortField.getText(), storageType, this.myUserField.getText().trim(), password, this.myPrivateKeyFileField.getText().equals(DataSourceSshSslPanel.getSshDirectory()) ? "" : this.myPrivateKeyFileField.getText(), passphrase, this.myUseSshCheckBox.isSelected(), this.myAuthTypeCombo.getSelectedItem().equals(AUTH_PASSWORD));
        return result.isEmpty() ? null : result;
    }

    private void setupFromSshCfg(@Nullable DataSourceSshTunnelConfiguration c) {
        DatabaseCredentials.StorageType storageType = c != null ? c.getSecretStorage() : null;
        boolean thirdState = storageType == DatabaseCredentials.StorageType.EMBEDDED;
        this.myRememberPasswordCheckBox.setThirdStateEnabled(thirdState);
        if (thirdState) {
            this.myRememberPasswordCheckBox.setState(ThreeStateCheckBox.State.DONT_CARE);
        } else {
            this.myRememberPasswordCheckBox.setSelected(storageType != DatabaseCredentials.StorageType.MEMORY);
        }
        if (c == null) {
            return;
        }
        this.myProxyHostField.setText(c.getProxyHost());
        this.myProxyPortField.setText(c.getProxyPort());
        this.myUserField.setText(c.getUser());
        this.myUseSshCheckBox.setSelected(c.isEnabled());
        this.myAuthTypeCombo.setSelectedItem((Object)(c.isUsePassword() ? AUTH_PASSWORD : AUTH_KEYPAIR));
        this.myPasswordLazyField.reset();
        this.myPassphraseLazyField.reset();
        this.myPrivateKeyFileField.setText(c.getPrivateKeyPath());
    }

    private void createUIComponents() {
        this.mySslCopyFrom = this.createLabel(new Condition<LocalDataSource>(){

            public boolean value(LocalDataSource ds) {
                return ds.getSslCfg() != null;
            }
        }, new Consumer<LocalDataSource>(){

            public void consume(LocalDataSource dataSource) {
                DataSourceSshSslPanel.this.setupFromSslCfg(dataSource.getSslCfg());
            }
        }, "No data sources with SSL");
        this.mySshCopyFrom = this.createLabel(new Condition<LocalDataSource>(){

            public boolean value(LocalDataSource ds) {
                return ds.getSshConfiguration() != null;
            }
        }, new Consumer<LocalDataSource>(){

            public void consume(LocalDataSource dataSource) {
                DataSourceSshSslPanel.this.setupFromSshCfg(dataSource.getSshConfiguration());
            }
        }, "No data sources with SSH");
        this.myPasswordField = new JBPasswordField();
        this.myPasswordLazyField = new LazyPasswordField(this.myPasswordField, new Getter<String>(){

            public String get() {
                return (String)((DataSourceSshSslPanel)DataSourceSshSslPanel.this).myDialog.getSecretService().getSshCredentials((Project)((DataSourceSshSslPanel)DataSourceSshSslPanel.this).myDialog.getProject(), (LocalDataSource)((LocalDataSource)((Object)((DataSourceSshSslPanel)DataSourceSshSslPanel.this).myDialog.getDataSource()))).first;
            }
        });
        this.myPassphraseField = new JBPasswordField();
        this.myPassphraseLazyField = new LazyPasswordField(this.myPassphraseField, new Getter<String>(){

            public String get() {
                return (String)((DataSourceSshSslPanel)DataSourceSshSslPanel.this).myDialog.getSecretService().getSshCredentials((Project)((DataSourceSshSslPanel)DataSourceSshSslPanel.this).myDialog.getProject(), (LocalDataSource)((LocalDataSource)((Object)((DataSourceSshSslPanel)DataSourceSshSslPanel.this).myDialog.getDataSource()))).second;
            }
        });
    }

    @NotNull
    private LinkLabel createLabel(final @NotNull Condition<LocalDataSource> condition, final @NotNull Consumer<LocalDataSource> processor, final @NotNull String emptyText) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/dataSource/DataSourceSshSslPanel", "createLabel"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/dataSource/DataSourceSshSslPanel", "createLabel"));
        }
        if (emptyText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyText", "com/intellij/database/dataSource/DataSourceSshSslPanel", "createLabel"));
        }
        LinkLabel linkLabel = new LinkLabel("Copy from ...", null, (LinkListener)new LinkListener<Void>(){

            public void linkSelected(LinkLabel src, Void data) {
                final List sources = DataSourceSshSslPanel.this.findAvailableDataSources((Condition<LocalDataSource>)condition);
                final JBList list = new JBList((Collection)sources);
                if (sources.isEmpty()) {
                    JBList emptyList = new JBList(new Object[]{emptyText});
                    emptyList.installCellRenderer((NotNullFunction)new NotNullFunction<Object, JComponent>(){

                        @NotNull
                        public JComponent fun(Object dom) {
                            JBLabel label = new JBLabel((String)dom, null, 2);
                            label.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)4, (int)2, (int)4));
                            JBLabel jBLabel = label;
                            if (jBLabel == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshSslPanel$13$1", "fun"));
                            }
                            return jBLabel;
                        }
                    });
                    JBPopupFactory.getInstance().createListPopupBuilder((JList)emptyList).setRequestFocus(true).createPopup().showUnderneathOf((Component)src);
                    return;
                }
                list.installCellRenderer((NotNullFunction)new NotNullFunction<Object, JComponent>(){

                    @NotNull
                    public JComponent fun(Object o) {
                        JBLabel label = new JBLabel(((LocalDataSource)((Object)o)).getName(), ((LocalDataSource)((Object)o)).getBaseIcon(), 2);
                        label.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)4, (int)2, (int)4));
                        JBLabel jBLabel = label;
                        if (jBLabel == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshSslPanel$13$2", "fun"));
                        }
                        return jBLabel;
                    }
                });
                JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setRequestFocus(true).setItemChoosenCallback(new Runnable(){

                    @Override
                    public void run() {
                        int i = list.getSelectedIndex();
                        if (i < 0) {
                            return;
                        }
                        LocalDataSource source = (LocalDataSource)((Object)sources.get(i));
                        processor.consume((Object)source);
                    }
                }).createPopup().showUnderneathOf((Component)src);
            }
        });
        if (linkLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshSslPanel", "createLabel"));
        }
        return linkLabel;
    }

    @NotNull
    private List<LocalDataSource> findAvailableDataSources(Condition<LocalDataSource> condition) {
        ArrayList result = ContainerUtil.newArrayList();
        for (DataSource ds : DataSourceManager.getInstance((Project)this.myProject).getDataSources()) {
            if (ds == this.myDataSource || !(ds instanceof LocalDataSource) || !condition.value((Object)((LocalDataSource)ds))) continue;
            ContainerUtil.addAllNotNull((Collection)result, (Object[])new LocalDataSource[]{(LocalDataSource)ds});
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshSslPanel", "findAvailableDataSources"));
        }
        return arrayList;
    }

    private void setupFromSslCfg(@Nullable DataSourceSslConfiguration ssl) {
        if (ssl == null) {
            return;
        }
        this.myUseSSLJBCheckBox.setSelected(ssl.myEnabled);
        this.myCaCertFileField.setText(ssl.myCaCertPath);
        this.myClientCertFileField.setText(ssl.myClientCertPath);
        this.myClientKeyFileField.setText(ssl.myClientKeyPath);
    }

    public void reset(@NotNull LocalDataSource ds) {
        if (ds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ds", "com/intellij/database/dataSource/DataSourceSshSslPanel", "reset"));
        }
        this.setupFromSshCfg(ds.getSshConfiguration());
        this.setupFromSslCfg(ds.getSslCfg());
    }

    public void saveData(@NotNull LocalDataSource ds, boolean copyCredentials) {
        if (ds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ds", "com/intellij/database/dataSource/DataSourceSshSslPanel", "saveData"));
        }
        DataSourceSshTunnelConfiguration newSsh = this.createSshConfig(ds, copyCredentials);
        DataSourceSshTunnelConfiguration prevSsh = ds.getSshConfiguration();
        ds.setSshConfiguration(newSsh);
        if (copyCredentials) {
            DatabaseCredentials.StorageType newStorageType;
            DatabaseCredentials.StorageType prevStorageType = prevSsh == null ? null : prevSsh.getSecretStorage();
            DatabaseCredentials.StorageType storageType = newStorageType = newSsh == null ? null : newSsh.getSecretStorage();
            if (prevStorageType != null && prevStorageType != newStorageType) {
                this.myDialog.getSecretService().removeSshCredentials(this.myProject, ds, prevStorageType);
            }
            if (newSsh != null && newStorageType != DatabaseCredentials.StorageType.EMBEDDED) {
                this.myDialog.getSecretService().setSshCredentials(this.myProject, ds, this.getPassword(), this.getPassphrase());
            }
        }
        DataSourceSslConfiguration newSsl = this.getSslCfg();
        if (ds.getSslCfg() == null && !newSsl.isEmpty() || ds.getSslCfg() != null) {
            ds.setSslCfg(newSsl.isEmpty() ? null : newSsl);
        }
    }

    @NotNull
    public String getPassword() {
        String string = this.myAuthTypeCombo.getSelectedItem() == AUTH_PASSWORD ? this.myPasswordLazyField.getPassword() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshSslPanel", "getPassword"));
        }
        return string;
    }

    @NotNull
    public String getPassphrase() {
        String string = this.myAuthTypeCombo.getSelectedItem() == AUTH_KEYPAIR ? this.myPassphraseLazyField.getPassword() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshSslPanel", "getPassphrase"));
        }
        return string;
    }

    @NotNull
    public DataSourceSslConfiguration getSslCfg() {
        DataSourceSslConfiguration dataSourceSslConfiguration = new DataSourceSslConfiguration(this.getCaCertFilePath(), this.getClientCertFilePath(), this.getClientKeyFilePath(), this.getUseSsl());
        if (dataSourceSslConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshSslPanel", "getSslCfg"));
        }
        return dataSourceSslConfiguration;
    }

    @NotNull
    public String getCaCertFilePath() {
        String string = this.myCaCertFileField.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshSslPanel", "getCaCertFilePath"));
        }
        return string;
    }

    @NotNull
    public String getClientCertFilePath() {
        String string = this.myClientCertFileField.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshSslPanel", "getClientCertFilePath"));
        }
        return string;
    }

    @NotNull
    public String getClientKeyFilePath() {
        String string = this.myClientKeyFileField.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshSslPanel", "getClientKeyFilePath"));
        }
        return string;
    }

    public boolean getUseSsl() {
        return this.myUseSSLJBCheckBox.isSelected();
    }

    public boolean isPasswordChanged() {
        return this.myPasswordLazyField.isModified();
    }

    public boolean isPassphraseChanged() {
        return this.myPassphraseLazyField.isModified();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JPanel jPanel;
        JPanel jPanel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton4;
        JPanel jPanel3;
        ThreeStateCheckBox threeStateCheckBox;
        ComboBox comboBox;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JPanel jPanel4;
        JBCheckBox jBCheckBox;
        JBLabel jBLabel;
        JCheckBox jCheckBox;
        JPanel jPanel5;
        this.createUIComponents();
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(9, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myUseSshCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(0);
        jCheckBox.setText("Use SSH tunnel");
        jCheckBox.setMnemonic('H');
        jCheckBox.setDisplayedMnemonicIndex(6);
        jPanel5.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myInfoLabel = jBLabel = new JBLabel();
        jBLabel.setText("label");
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 0, 1, 3, 0, 0, 7, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        jPanel5.add((Component)titledSeparator, new GridConstraints(3, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        this.myUseSSLJBCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Use SSL");
        jBCheckBox.setMnemonic('L');
        jBCheckBox.setDisplayedMnemonicIndex(6);
        jPanel5.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySettingContainerPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Proxy host:");
        jBLabel2.setDisplayedMnemonic('O');
        jBLabel2.setDisplayedMnemonicIndex(7);
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Proxy user:");
        jBLabel3.setDisplayedMnemonic('U');
        jBLabel3.setDisplayedMnemonicIndex(6);
        jPanel4.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProxyHostField = jTextField3 = new JTextField();
        jPanel4.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(0, 2, 1, 1, 0, 3, 0, 0, null, null, null, 0, true));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Port:");
        jBLabel4.setDisplayedMnemonic('P');
        jBLabel4.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myProxyPortField = jTextField2 = new JTextField();
        jTextField2.setText("22");
        jTextField2.setColumns(5);
        jPanel6.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myUserField = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAuthTypeCombo = comboBox = new ComboBox();
        comboBox.setSwingPopup(true);
        jPanel4.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Auth type:");
        jBLabel5.setDisplayedMnemonic('T');
        jBLabel5.setDisplayedMnemonicIndex(5);
        jPanel4.add((Component)jBLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRememberPasswordCheckBox = threeStateCheckBox = new ThreeStateCheckBox();
        threeStateCheckBox.setHorizontalAlignment(0);
        threeStateCheckBox.setVerticalAlignment(0);
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox, ResourceBundle.getBundle("messages/DatabaseBundle").getString("save.on.disk.with.master.key"));
        jPanel4.add((Component)threeStateCheckBox, new GridConstraints(6, 1, 1, 2, 5, 0, 0, 0, null, null, null));
        this.myCertificatePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(4, 0, 2, 3, 0, 3, 7, 3, null, null, null, 0, true));
        this.myPrivateKeyFileField = textFieldWithBrowseButton4 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton4, new GridConstraints(0, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("Private key file:");
        jBLabel6.setDisplayedMnemonic('R');
        jBLabel6.setDisplayedMnemonicIndex(1);
        jPanel3.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBPasswordField jBPasswordField = this.myPassphraseField;
        jPanel3.add((Component)jBPasswordField, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setText("Passphrase:");
        jBLabel7.setDisplayedMnemonic('S');
        jBLabel7.setDisplayedMnemonicIndex(2);
        jPanel3.add((Component)jBLabel7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel8 = new JBLabel();
        jBLabel8.setText("Proxy password:");
        jBLabel8.setDisplayedMnemonic('W');
        jBLabel8.setDisplayedMnemonicIndex(10);
        jPanel2.add((Component)jBLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBPasswordField jBPasswordField2 = this.myPasswordField;
        jPanel2.add((Component)jBPasswordField2, new GridConstraints(0, 1, 1, 2, 0, 1, 6, 0, null, new Dimension(150, -1), null));
        this.mySslPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel9 = new JBLabel();
        jBLabel9.setText("CA file:");
        jBLabel9.setDisplayedMnemonic('A');
        jBLabel9.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jBLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel10 = new JBLabel();
        jBLabel10.setText("Client certificate file:");
        jBLabel10.setDisplayedMnemonic('C');
        jBLabel10.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel10, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCaCertFileField = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(350, -1), null));
        this.myClientCertFileField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(350, -1), null));
        this.myClientKeyFileField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(350, -1), null));
        JBLabel jBLabel11 = new JBLabel();
        jBLabel11.setText("Client key file:");
        jBLabel11.setDisplayedMnemonic('K');
        jBLabel11.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jBLabel11, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        LinkLabel linkLabel = this.mySslCopyFrom;
        linkLabel.setText("Copy from...");
        linkLabel.setVerticalAlignment(1);
        jPanel5.add((Component)linkLabel, new GridConstraints(4, 1, 1, 2, 4, 0, 0, 0, null, new Dimension(114, 12), null));
        LinkLabel linkLabel2 = this.mySshCopyFrom;
        linkLabel2.setText("Copy from...");
        linkLabel2.setVerticalAlignment(1);
        jPanel5.add((Component)linkLabel2, new GridConstraints(1, 2, 1, 1, 4, 0, 0, 0, null, new Dimension(114, 12), null));
        this.myTestConnectionButton = jButton = new JButton();
        jButton.setText("");
        jPanel5.add((Component)jButton, new GridConstraints(7, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(8, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        jPanel5.add((Component)titledSeparator2, new GridConstraints(6, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        jBLabel2.setLabelFor(jTextField3);
        jBLabel3.setLabelFor(jTextField);
        jBLabel4.setLabelFor(jTextField2);
        jBLabel5.setLabelFor((Component)comboBox);
        jBLabel6.setLabelFor((Component)textFieldWithBrowseButton4);
        jBLabel7.setLabelFor((Component)jBPasswordField);
        jBLabel8.setLabelFor((Component)jBPasswordField2);
        jBLabel9.setLabelFor((Component)textFieldWithBrowseButton3);
        jBLabel10.setLabelFor((Component)textFieldWithBrowseButton2);
        jBLabel11.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

