/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSshTunnelConfiguration {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.database.dataSource.DataSourceSshTunnelConfiguration");
    public static final String ELEMENT_NAME = "ssh-properties";
    @NotNull
    private final String myProxyHost;
    @NotNull
    private final String myProxyPort;
    @NotNull
    private final String myUser;
    @NotNull
    private final String myPassword;
    @NotNull
    private final String myPrivateKeyPath;
    @NotNull
    private final String myPassphrase;
    @NotNull
    private final DatabaseCredentials.StorageType mySecretStorage;
    private final boolean myEnabled;
    private final boolean myUsePassword;

    public DataSourceSshTunnelConfiguration(@NotNull String proxyHost, @NotNull String proxyPort, @NotNull DatabaseCredentials.StorageType storage, @NotNull String user, @NotNull String password, @NotNull String privateKeyPath, @NotNull String passphrase, boolean enabled, boolean usePassword) {
        if (proxyHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxyHost", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "<init>"));
        }
        if (proxyPort == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxyPort", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "<init>"));
        }
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "<init>"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "<init>"));
        }
        if (password == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "password", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "<init>"));
        }
        if (privateKeyPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "privateKeyPath", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "<init>"));
        }
        if (passphrase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "passphrase", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "<init>"));
        }
        this.myProxyHost = proxyHost;
        this.myUser = user;
        this.myPassword = password;
        this.myPrivateKeyPath = privateKeyPath;
        this.myPassphrase = passphrase;
        this.myProxyPort = proxyPort;
        this.myEnabled = enabled;
        this.myUsePassword = usePassword;
        this.mySecretStorage = storage;
    }

    public static boolean equal(@Nullable DataSourceSshTunnelConfiguration c1, @Nullable DataSourceSshTunnelConfiguration c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.equalConfiguration(c2);
    }

    @Nullable
    public static DataSourceSshTunnelConfiguration deserialize(@NotNull HierarchicalStreamReader xmlReader, @NotNull LocalDataSource dataSource) {
        DataSourceSshTunnelConfiguration configuration;
        if (xmlReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlReader", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "deserialize"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "deserialize"));
        }
        String proxyHost = "";
        String proxyPort = "";
        String user = "";
        String password = "";
        String privateKeyPath = "";
        String passphrase = "";
        String remoteHost = "";
        String remotePort = "";
        String localPort = "";
        boolean enabled = false;
        boolean usePassword = true;
        DatabaseCredentials.StorageType secretStorage = DatabaseCredentials.StorageType.EMBEDDED;
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String name = xmlReader.getNodeName();
            String value = xmlReader.getValue();
            if ("proxy-host".equals(name)) {
                proxyHost = value;
            } else if ("proxy-port".equals(name)) {
                proxyPort = value;
            } else if ("secret-storage".equals(name)) {
                secretStorage = DatabaseCredentials.StorageType.valueOf(StringUtil.toUpperCase((String)xmlReader.getValue()));
            } else if ("user".equals(name)) {
                user = value;
            } else if ("use-password".equals(name)) {
                usePassword = StringUtil.parseBoolean((String)value, (boolean)true);
            } else if ("password".equals(name)) {
                password = value;
            } else if ("passphrase".equals(name)) {
                passphrase = value;
            } else if ("private-key-path".equals(name)) {
                privateKeyPath = value;
            } else if ("remote-host".equals(name)) {
                remoteHost = value;
            } else if ("remote-port".equals(name)) {
                remotePort = value;
            } else if ("local-port".equals(name)) {
                localPort = value;
            } else if ("enabled".equals(name)) {
                enabled = StringUtil.parseBoolean((String)value, (boolean)false);
            }
            xmlReader.moveUp();
        }
        if (!(StringUtil.isEmpty((String)remoteHost) || StringUtil.isEmpty((String)remotePort) || StringUtil.isEmpty((String)localPort))) {
            String url = dataSource.getUrl();
            url = url.replace(localPort, remotePort);
            url = url.replace("localhost", remoteHost);
            url = url.replace("127.0.0.1", remoteHost);
            dataSource.setUrl(url);
        }
        return (configuration = new DataSourceSshTunnelConfiguration(proxyHost, proxyPort, secretStorage, user, password, privateKeyPath, passphrase, enabled, usePassword)).isEmpty() ? null : configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Pair<Session, Integer> createTunnel(@NotNull Project project, @NotNull LocalDataSource dataSource) throws JSchException {
        Session session;
        int localPort;
        block17: {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "createTunnel"));
            }
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "createTunnel"));
            }
            if (!this.isEnabled() || dataSource.getDatabaseDriver() == null) {
                return null;
            }
            String connectionUrl = dataSource.getUrl();
            if (connectionUrl == null) {
                return null;
            }
            JdbcUrlParser parser = JdbcUrlParserUtil.statefull(JdbcUrlParserUtil.select(dataSource.getDatabaseDriver().getJDBCUrlParsers(), connectionUrl, StatelessJdbcUrlParser.LocationType.REMOTE));
            if (parser == null) {
                return null;
            }
            parser.setUrlText(connectionUrl);
            String remoteHost = parser.getParameter("host");
            String remotePort = parser.getParameter("port");
            if (StringUtil.isEmpty((String)remotePort)) {
                remotePort = parser.getParameterDefValue("port");
            }
            if (remoteHost == null || remotePort == null) {
                return null;
            }
            localPort = -1;
            try (ServerSocket serverSocket = new ServerSocket(0);){
                localPort = serverSocket.getLocalPort();
            }
            catch (IOException e) {
                throw new JSchException("Can't find a free port", (Throwable)e);
            }
            JSch jsch = new JSch();
            JSch.setConfig((String)"kex", (String)"diffie-hellman-group1-sha1,diffie-hellman-group14-sha1,diffie-hellman-group-exchange-sha1,diffie-hellman-group-exchange-sha256");
            Pair<String, String> pair = DatabaseCredentials.getInstance().getSshCredentials(project, dataSource);
            if (!this.isUsePassword()) {
                jsch.addIdentity(this.getPrivateKeyPath(), (String)pair.second);
            }
            session = jsch.getSession(this.getUser(), this.getProxyHost(), StringUtil.parseInt((String)this.getProxyPort(), (int)-1));
            if (this.isUsePassword()) {
                session.setPassword((String)pair.first);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            config.put("TCPKeepAlive", "yes");
            session.setConfig(config);
            session.setServerAliveInterval((int)TimeUnit.MINUTES.toMillis(2L));
            session.setServerAliveCountMax(1000);
            session.connect();
            try {
                session.setPortForwardingL(localPort, remoteHost, StringUtil.parseInt((String)remotePort, (int)-1));
            }
            catch (JSchException e) {
                if (e.getCause() instanceof BindException) break block17;
                throw e;
            }
        }
        LOG.info("SSH tunnel created: " + Arrays.asList(session.getPortForwardingL()) + " via " + session.getHost() + ":" + session.getPort() + " on localhost:" + localPort);
        return Pair.create((Object)session, (Object)localPort);
    }

    public void serialize(@NotNull HierarchicalStreamWriter serializer) {
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "serialize"));
        }
        serializer.startNode(ELEMENT_NAME);
        DataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"enabled", (String)Boolean.toString(this.myEnabled));
        DataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"proxy-host", (String)this.myProxyHost);
        DataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"proxy-port", (String)this.myProxyPort);
        if (this.mySecretStorage != DatabaseCredentials.StorageType.EMBEDDED) {
            DataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"secret-storage", (String)StringUtil.toLowerCase((String)this.mySecretStorage.name()));
        }
        DataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"user", (String)this.myUser);
        DataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"use-password", (String)Boolean.toString(this.myUsePassword));
        DataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"password", (String)this.myPassword);
        DataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"private-key-path", (String)this.myPrivateKeyPath);
        DataSource.writeTag((HierarchicalStreamWriter)serializer, (String)"passphrase", (String)this.myPassphrase);
        serializer.endNode();
    }

    @NotNull
    public String getProxyHost() {
        String string = this.myProxyHost;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "getProxyHost"));
        }
        return string;
    }

    @NotNull
    public String getUser() {
        String string = this.myUser;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "getUser"));
        }
        return string;
    }

    @NotNull
    public String getProxyPort() {
        String string = this.myProxyPort;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "getProxyPort"));
        }
        return string;
    }

    @NotNull
    public String getPassword() {
        String string = this.myPassword;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "getPassword"));
        }
        return string;
    }

    @NotNull
    public String getPrivateKeyPath() {
        String string = this.myPrivateKeyPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "getPrivateKeyPath"));
        }
        return string;
    }

    @NotNull
    public String getPassphrase() {
        String string = this.myPassphrase;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "getPassphrase"));
        }
        return string;
    }

    @NotNull
    public DatabaseCredentials.StorageType getSecretStorage() {
        DatabaseCredentials.StorageType storageType = this.mySecretStorage;
        if (storageType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "getSecretStorage"));
        }
        return storageType;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public boolean isUsePassword() {
        return this.myUsePassword;
    }

    public boolean equalConfiguration(@NotNull DataSourceSshTunnelConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/dataSource/DataSourceSshTunnelConfiguration", "equalConfiguration"));
        }
        if (this.myEnabled != configuration.myEnabled) {
            return false;
        }
        if (this.myUsePassword != configuration.myUsePassword) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myProxyHost), (CharSequence)StringUtil.nullize((String)configuration.myProxyHost))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myProxyPort), (CharSequence)StringUtil.nullize((String)configuration.myProxyPort))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myUser), (CharSequence)StringUtil.nullize((String)configuration.myUser))) {
            return false;
        }
        if (this.mySecretStorage != configuration.getSecretStorage()) {
            return false;
        }
        return StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myPrivateKeyPath), (CharSequence)StringUtil.nullize((String)configuration.myPrivateKeyPath));
    }

    public boolean isEmpty() {
        if (this.myEnabled) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)this.myProxyHost)) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)this.myUser)) {
            return false;
        }
        return !StringUtil.isNotEmpty((String)this.myPrivateKeyPath);
    }
}

