/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverListener;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.DatabaseDriverManagerImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.template.StatelessTemplateJdbcUrlParser;
import com.intellij.database.dataSource.url.template.StatelessTextDecomposition;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import icons.DatabaseIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDriverImpl
implements DatabaseDriver {
    private static final Logger LOG = Logger.getInstance(DatabaseDriverImpl.class);
    private final boolean myPredefined;
    private final String myId;
    private String myName;
    private String myDriverClass;
    private String myDialect;
    private Icon myIcon;
    private String myIconName;
    private String myVmOptions;
    @NotNull
    private Map<String, String> myVmEnv = ContainerUtil.newLinkedHashMap();
    private final List<UrlTemplate> myUrlTemplates = ContainerUtil.newArrayList();
    private final List<Pair<UrlTemplate, String>> myTemplatesErrors = ContainerUtil.newArrayList();
    private final Map<String, String> myDriverProperties = ContainerUtil.newLinkedHashMap();
    private final Map<DatabaseDriver.Option, String> myOptions = ContainerUtil.newLinkedHashMap();
    private String myArtifactName;
    private final List<SimpleClasspathElement> myClasspathElements = ContainerUtil.newArrayList();
    private List<StatelessJdbcUrlParser> myJdbcUrlParsers = Collections.emptyList();
    private final EnumSet<StatelessJdbcUrlParser.LocationType> mySupportedLocations = EnumSet.noneOf(StatelessJdbcUrlParser.LocationType.class);

    public DatabaseDriverImpl(@Nullable String id, boolean predefined) {
        this.myId = StringUtil.isEmpty((String)id) ? UUID.randomUUID().toString() : id;
        this.myPredefined = predefined;
    }

    public DatabaseDriverImpl(@Nullable String id, @Nullable String name, @Nullable String driverClass, @Nullable UrlTemplate urlTemplate) {
        this(id, false);
        this.myName = name;
        this.myDriverClass = driverClass;
        if (urlTemplate != null) {
            this.setURLTemplates(Collections.singletonList(urlTemplate));
        }
    }

    @NotNull
    public List<Pair<UrlTemplate, String>> getTemplatesErrors() {
        List<Pair<UrlTemplate, String>> list = this.myTemplatesErrors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getTemplatesErrors"));
        }
        return list;
    }

    @Override
    public boolean isPredefined() {
        return this.myPredefined;
    }

    @Override
    public String getId() {
        return this.myId;
    }

    @Override
    @NotNull
    public String getName() {
        String string = !StringUtil.isEmpty((String)this.myName) ? this.myName : "?";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFullName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getFullName"));
        }
        return string;
    }

    @NotNull
    public List<DataSourceTemplate> getSubConfigurations() {
        List<DataSourceTemplate> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getSubConfigurations"));
        }
        return list;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Override
    @NotNull
    public List<StatelessJdbcUrlParser> getJDBCUrlParsers() {
        List<StatelessJdbcUrlParser> list = this.myJdbcUrlParsers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getJDBCUrlParsers"));
        }
        return list;
    }

    @Override
    @NotNull
    public EnumSet<StatelessJdbcUrlParser.LocationType> getSupportedLocations() {
        EnumSet<StatelessJdbcUrlParser.LocationType> enumSet = this.mySupportedLocations;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getSupportedLocations"));
        }
        return enumSet;
    }

    @NotNull
    public DatabaseSystem createDataSource(@NotNull Project project, @Nullable DatabaseSystem copyFrom, @Nullable String newName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DatabaseDriverImpl", "createDataSource"));
        }
        LocalDataSource result = copyFrom instanceof LocalDataSource ? ((LocalDataSource)copyFrom).copy(project, false) : new LocalDataSource(this, this.getSampleUrl());
        if (copyFrom == null) {
            this.setDefaultProperties(result);
        } else {
            result.setFirstSync(ThreeState.NO);
            DatabaseCredentials.getInstance().copyCredentials(project, copyFrom, (DatabaseSystem)result);
        }
        result.setName(StringUtil.notNullize((String)newName, (String)""));
        LocalDataSource localDataSource = result;
        if (localDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "createDataSource"));
        }
        return localDataSource;
    }

    public void setDefaultProperties(@NotNull LocalDataSource result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/dataSource/DatabaseDriverImpl", "setDefaultProperties"));
        }
        result.getDriverProperties().putAll(this.myDriverProperties);
        result.setDriverClass(this.myDriverClass);
        result.setVmOptions(this.myVmOptions);
        result.setVmEnv(this.myVmEnv);
        result.setAutoSynchronize(DatabaseDriver.OPTION_AUTO_SYNC.get(this));
        result.setAutoCommit(DatabaseDriver.OPTION_AUTO_COMMIT.get(this));
    }

    @Override
    public String getDriverClass() {
        return this.myDriverClass;
    }

    public void setDriverClass(String driverClass) {
        this.myDriverClass = driverClass;
    }

    @NotNull
    public Collection<UrlTemplate> getUrlTemplates() {
        List<UrlTemplate> list = this.myUrlTemplates;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getUrlTemplates"));
        }
        return list;
    }

    public void setURLTemplates(@NotNull Collection<UrlTemplate> templates) {
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templates", "com/intellij/database/dataSource/DatabaseDriverImpl", "setURLTemplates"));
        }
        this.myUrlTemplates.clear();
        this.myTemplatesErrors.clear();
        this.myUrlTemplates.addAll(templates);
        this.myJdbcUrlParsers = ContainerUtil.newArrayListWithCapacity((int)templates.size());
        for (UrlTemplate template : templates) {
            try {
                StatelessTextDecomposition decomposition = StatelessTextDecomposition.build(template.getTemplate(), TypesRegistry.INSTANCE);
                this.myJdbcUrlParsers.add(new StatelessTemplateJdbcUrlParser(template.getName(), decomposition));
            }
            catch (StatelessTextDecomposition.InvalidTemplateException e) {
                this.myTemplatesErrors.add((Pair<UrlTemplate, String>)Pair.create((Object)template, (Object)e.getMessage()));
            }
        }
        this.mySupportedLocations.clear();
        for (StatelessJdbcUrlParser p : this.myJdbcUrlParsers) {
            this.mySupportedLocations.addAll(p.getPossibleLocations());
        }
    }

    @Override
    public boolean matchesUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/DatabaseDriverImpl", "matchesUrl"));
        }
        return JdbcUrlParserUtil.select(this.myJdbcUrlParsers, url) != null;
    }

    @Override
    @NotNull
    public String getSampleUrl() {
        StatelessJdbcUrlParser sparser = null;
        for (StatelessJdbcUrlParser parser : this.myJdbcUrlParsers) {
            if (!parser.getName().equals("default")) continue;
            sparser = parser;
            break;
        }
        if (sparser == null) {
            sparser = (StatelessJdbcUrlParser)ContainerUtil.getFirstItem(this.myJdbcUrlParsers);
        }
        if (sparser == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getSampleUrl"));
            }
            return "";
        }
        JdbcUrlParser parser = sparser.createStatefull();
        for (String p : parser.getParameters()) {
            String def = parser.getParameterDefValue(p);
            parser.setParameter(p, StringUtil.notNullize((String)def));
        }
        String string = parser.getUrlText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getSampleUrl"));
        }
        return string;
    }

    @Override
    public String getDialect() {
        return this.myDialect;
    }

    public void setDialect(String dialect) {
        if (Comparing.equal((String)dialect, (String)this.getDialect())) {
            return;
        }
        this.myDialect = dialect;
    }

    @NotNull
    public Icon getIcon(@Iconable.IconFlags int flags) {
        Icon icon = this.myIcon != null ? this.myIcon : DatabaseIcons.UserDriver;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getIcon"));
        }
        return icon;
    }

    @Override
    public String getIconName() {
        return this.myIconName;
    }

    @Override
    public Map<String, String> getDriverProperties() {
        return this.myDriverProperties;
    }

    @Override
    public <T> T getOption(@NotNull DatabaseDriver.Option<T> option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/database/dataSource/DatabaseDriverImpl", "getOption"));
        }
        String value = this.myOptions.get(option);
        return option.fromString(value);
    }

    @Override
    public <T> void setOption(@NotNull DatabaseDriver.Option<T> option, T value) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/database/dataSource/DatabaseDriverImpl", "setOption"));
        }
        if (value == null) {
            this.myOptions.remove(option);
        } else {
            this.myOptions.put(option, String.valueOf(value));
        }
    }

    @Override
    public String getVmOptions() {
        return this.myVmOptions;
    }

    public void setVmOptions(String vmOptions) {
        this.myVmOptions = vmOptions;
    }

    @NotNull
    public Map<String, String> getVmEnv() {
        Map<String, String> map = this.myVmEnv;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getVmEnv"));
        }
        return map;
    }

    public void setVmEnv(@NotNull Map<String, String> vmEnv) {
        if (vmEnv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmEnv", "com/intellij/database/dataSource/DatabaseDriverImpl", "setVmEnv"));
        }
        this.myVmEnv = vmEnv;
    }

    @Override
    public boolean isDownloaded() {
        if (StringUtil.isEmpty((String)this.myArtifactName)) {
            return true;
        }
        for (SimpleClasspathElement file : this.myClasspathElements) {
            for (String url : file.getClassesRootUrls()) {
                if (!new File(PathUtil.toPresentableUrl((String)url)).exists()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public Progressive downloadDriverTask() {
        Progressive progressive = new Progressive(){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseDriverImpl$1", "run"));
                }
                List versions = DataSourceConfigUtil.getDriverVersionsFetcher().fetchVersions();
                DownloadableFileSetDescription toDownload = null;
                for (DownloadableFileSetDescription artifactFileSet : versions) {
                    if (!Comparing.equal((String)artifactFileSet.getName(), (String)DatabaseDriverImpl.this.myArtifactName)) continue;
                    toDownload = artifactFileSet;
                    break;
                }
                if (toDownload == null) {
                    return;
                }
                Iterator iterator = toDownload.getFiles().iterator();
                while (iterator.hasNext()) {
                    DownloadableFileDescription description = (DownloadableFileDescription)iterator.next();
                    if (!description.getPresentableFileName().contains("win") || SystemInfo.isWindows) continue;
                    iterator.remove();
                }
                FileDownloader downloader = DownloadableFileService.getInstance().createDownloader(toDownload);
                List result = null;
                while (true) {
                    try {
                        result = downloader.download(new File(DatabaseDriverImpl.getDriverDownloadDirectory()));
                    }
                    catch (IOException e) {
                        String title;
                        boolean retry;
                        if (retry = IOExceptionDialog.showErrorDialog((String)(title = IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{StringUtil.capitalize((String)DatabaseDriverImpl.this.myArtifactName) + " files"})), (String)e.getMessage())) continue;
                    }
                    break;
                }
                if (result != null && !result.isEmpty() && !indicator.isCanceled()) {
                    final List finalResult = result;
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            DatabaseDriverImpl.this.myClasspathElements.clear();
                            DatabaseDriverImpl.configureClassPath(DatabaseDriverImpl.this.myArtifactName, finalResult);
                        }
                    });
                } else {
                    indicator.cancel();
                }
            }
        };
        if (progressive == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "downloadDriverTask"));
        }
        return progressive;
    }

    private static void configureClassPath(@NotNull String artifactName, @NotNull List<Pair<File, DownloadableFileDescription>> downloadedFiles) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "com/intellij/database/dataSource/DatabaseDriverImpl", "configureClassPath"));
        }
        if (downloadedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloadedFiles", "com/intellij/database/dataSource/DatabaseDriverImpl", "configureClassPath"));
        }
        LinkedHashSet<DatabaseDriverImpl> updatedDrivers = new LinkedHashSet<DatabaseDriverImpl>();
        for (DatabaseDriver databaseDriver : DatabaseDriverManager.getInstance().getDrivers()) {
            DatabaseDriverImpl localDriver;
            if (!(databaseDriver instanceof DatabaseDriverImpl) || (localDriver = (DatabaseDriverImpl)databaseDriver).isDownloaded() || !Comparing.equal((String)localDriver.getArtifactName(), (String)artifactName)) continue;
            for (Pair<File, DownloadableFileDescription> pair : downloadedFiles) {
                localDriver.addToClasspathElement(FileUtil.toSystemIndependentName((String)((File)pair.first).getPath()));
                updatedDrivers.add(localDriver);
            }
        }
        for (DatabaseDriverImpl databaseDriverImpl : updatedDrivers) {
            DatabaseDriverImpl.getMulticaster().driverFilesDownloaded(databaseDriverImpl);
        }
    }

    @Override
    public String getArtifactName() {
        return this.myArtifactName;
    }

    @Override
    public List<SimpleClasspathElement> getClasspathElements() {
        return Collections.unmodifiableList(this.myClasspathElements);
    }

    public DatabaseDriverImpl loadState(@NotNull Element config, boolean merge, boolean overrideName) {
        String optionName;
        Element env;
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/database/dataSource/DatabaseDriverImpl", "loadState"));
        }
        if (overrideName || this.myName == null) {
            this.myName = DatabaseDriverImpl.getOverride(config.getAttributeValue("name"), this.myName, merge);
        }
        this.myDriverClass = DatabaseDriverImpl.getOverride(config.getAttributeValue("driver-class"), this.myDriverClass, merge);
        this.myDialect = DatabaseDriverImpl.getOverride(config.getAttributeValue("dialect"), this.myDialect, merge);
        this.myIconName = DatabaseDriverImpl.getOverride(config.getAttributeValue("icon"), this.myIconName, merge);
        if (!StringUtil.isEmpty((String)this.myIconName)) {
            this.myIcon = IconLoader.findIcon((String)this.myIconName);
        }
        ArrayList templates = ContainerUtil.newArrayList();
        if (merge) {
            templates.addAll(this.myUrlTemplates);
        }
        for (Element element : config.getChildren("url-template")) {
            String name = DatabaseDriverImpl.getIfNotNull(element.getAttributeValue("name"), "default");
            String template = DatabaseDriverImpl.getIfNotNull(element.getAttributeValue("template"), element.getValue());
            if (StringUtil.isEmpty((String)template)) continue;
            templates.add(new UrlTemplate(name, template));
        }
        this.setURLTemplates(templates);
        if (!merge) {
            this.myVmEnv.clear();
        }
        if ((env = config.getChild("vm-env")) != null) {
            for (Element property : env.getChildren("property")) {
                this.myVmEnv.put(property.getAttributeValue("name"), property.getAttributeValue("value"));
            }
        }
        for (Element element : config.getChildren("vm-options")) {
            this.myVmOptions = DatabaseDriverImpl.getOverride(element.getTextTrim(), this.myVmOptions, merge);
        }
        for (Element element : config.getChildren("artifact")) {
            this.myArtifactName = DatabaseDriverImpl.getOverride(element.getAttributeValue("name"), this.myArtifactName, merge);
        }
        if (!merge) {
            this.myOptions.clear();
        }
        for (Element element : config.getChildren("option")) {
            optionName = element.getAttributeValue("name");
            String value = element.getAttributeValue("value");
            DatabaseDriver.Option option = DatabaseDriver.Option.byName(optionName);
            if (option == null) continue;
            this.myOptions.put(option, value);
        }
        if (!merge) {
            this.myDriverProperties.clear();
        }
        for (Element element : config.getChildren("property")) {
            optionName = element.getAttributeValue("name");
            if (StringUtil.isEmpty((String)optionName)) continue;
            this.myDriverProperties.put(optionName, element.getAttributeValue("value"));
        }
        if (!merge) {
            this.myClasspathElements.clear();
        }
        for (Element element : config.getChildren("library")) {
            this.myClasspathElements.addAll(SimpleClasspathElementFactory.createElements(null, (Element)element));
        }
        return this;
    }

    public Element getState(boolean includePredefined) {
        boolean allOptions;
        Element result = new Element("driver");
        result.setAttribute("id", this.myId);
        result.setAttribute("name", StringUtil.notNullize((String)this.myName));
        if (this.myDialect != null) {
            result.setAttribute("dialect", this.myDialect);
        }
        boolean bl = allOptions = !this.myPredefined || includePredefined;
        if (allOptions) {
            if (StringUtil.isNotEmpty((String)this.myDriverClass)) {
                result.setAttribute("driver-class", this.myDriverClass);
            }
            if (StringUtil.isNotEmpty((String)this.myIconName)) {
                result.setAttribute("icon", this.myIconName);
            }
            if (StringUtil.isNotEmpty((String)this.myArtifactName)) {
                Element artifactElement = new Element("artifact");
                artifactElement.setAttribute("name", this.myArtifactName);
                result.addContent(artifactElement);
            }
            for (UrlTemplate urlTemplate : this.myUrlTemplates) {
                Element tplElement = new Element("url-template");
                tplElement.setAttribute("name", urlTemplate.getName());
                tplElement.setAttribute("template", urlTemplate.getTemplate());
                result.addContent(tplElement);
            }
        }
        for (DatabaseDriver.Option option : this.myOptions.keySet()) {
            if (!allOptions && option.isFixed()) continue;
            Element e = new Element("option");
            e.setAttribute("name", option.getName());
            e.setAttribute("value", this.myOptions.get(option));
            result.addContent(e);
        }
        if (StringUtil.isNotEmpty((String)this.myVmOptions)) {
            Element e = new Element("vm-options");
            e.setText(this.myVmOptions);
            result.addContent(e);
        }
        if (!this.myVmEnv.isEmpty()) {
            Element env = new Element("vm-env");
            for (String name : this.myVmEnv.keySet()) {
                Element prop = new Element("property");
                prop.setAttribute("name", name);
                prop.setAttribute("value", this.myVmEnv.get(name));
                env.addContent(prop);
            }
            result.addContent(env);
        }
        for (Map.Entry<String, String> entry : this.myDriverProperties.entrySet()) {
            Element optionElement = new Element("property");
            optionElement.setAttribute("name", entry.getKey());
            optionElement.setAttribute("value", entry.getValue());
            result.addContent(optionElement);
        }
        for (SimpleClasspathElement simpleClasspathElement : this.myClasspathElements) {
            Element libraryElement = new Element("library");
            try {
                simpleClasspathElement.serialize(libraryElement);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            result.addContent(libraryElement);
        }
        return result;
    }

    private static String getIfNotNull(String value, String defaultValue) {
        return StringUtil.isEmpty((String)value) ? defaultValue : value;
    }

    private static String getOverride(String value, String oldValue, boolean merge) {
        return merge ? DatabaseDriverImpl.getIfNotNull(value, oldValue) : value;
    }

    private void addToClasspathElement(String path) {
        this.myClasspathElements.addAll(SimpleClasspathElementFactory.createElements((String[])new String[]{VfsUtilCore.pathToUrl((String)path)}));
    }

    public void setClasspathElements(List<SimpleClasspathElement> classpathElements) {
        this.myClasspathElements.clear();
        this.myClasspathElements.addAll(classpathElements);
        DatabaseDriverImpl.getMulticaster().driverUpdated(this);
    }

    private static DatabaseDriverListener getMulticaster() {
        return (DatabaseDriverListener)DatabaseDriverManagerImpl.getLocalInstance().getDispatcher().getMulticaster();
    }

    public static String getDriverDownloadDirectory() {
        String configPath = PathManager.getConfigPath();
        File config = new File(configPath + "/jdbc-drivers");
        if (!config.exists() && !config.mkdirs()) {
            LOG.warn("Unable to create directory: " + config.getAbsolutePath());
        }
        return config.getPath();
    }

    public DatabaseDriverImpl copy(@Nullable String newName) {
        DatabaseDriverImpl result = new DatabaseDriverImpl(null, StringUtil.notNullize((String)newName, (String)this.myName), null, null);
        return result.loadState(this.getState(true), false, false);
    }

    public boolean equalConfiguration(DatabaseDriverImpl o) {
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myName), (String)StringUtil.nullize((String)o.myName))) {
            return false;
        }
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myArtifactName), (String)StringUtil.nullize((String)o.myArtifactName))) {
            return false;
        }
        if (!this.myClasspathElements.equals(o.myClasspathElements)) {
            return false;
        }
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myDialect), (String)StringUtil.nullize((String)o.myDialect))) {
            return false;
        }
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myDriverClass), (String)StringUtil.nullize((String)o.myDriverClass))) {
            return false;
        }
        if (!this.myDriverProperties.equals(o.myDriverProperties)) {
            return false;
        }
        for (DatabaseDriver.Option<?> option : DatabaseDriver.Option.enumerate()) {
            if (Comparing.equal(this.getOption(option), o.getOption(option))) continue;
            return false;
        }
        if (this.myUrlTemplates != null ? !this.myUrlTemplates.equals(o.myUrlTemplates) : o.myUrlTemplates != null) {
            return false;
        }
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myVmOptions), (String)StringUtil.nullize((String)o.myVmOptions))) {
            return false;
        }
        return ContainerUtil.diff(this.myVmEnv, o.myVmEnv).isEmpty();
    }

    public String toString() {
        return "LocalDatabaseDriver{myId='" + this.myId + '\'' + ", myName='" + this.myName + '\'' + '}';
    }

    public void dump(@NotNull StringBuilder sb) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/dataSource/DatabaseDriverImpl", "dump"));
        }
        sb.append("Id - ").append(this.getId()).append("\n");
        sb.append("Name - ").append(this.getName()).append("\n");
        sb.append("DriverClass - ").append(this.getDriverClass()).append("\n");
        sb.append("Dialect - ").append(this.getDialect()).append("\n");
        sb.append("IconName - ").append(this.getIconName()).append("\n");
        sb.append("VmOptions - ").append(this.getVmOptions()).append("\n");
        sb.append("Predefined - ").append(this.isPredefined()).append("\n");
        sb.append("UrlTemplates").append("\n");
        for (UrlTemplate urlTemplate : this.getUrlTemplates()) {
            sb.append(" * ").append(urlTemplate.getName()).append(" - ").append(urlTemplate.getTemplate()).append("\n");
        }
        sb.append("DriverProperties").append("\n");
        for (Map.Entry entry : this.getDriverProperties().entrySet()) {
            sb.append(" * ").append((String)entry.getKey()).append(" - ").append((String)entry.getValue()).append("\n");
        }
        sb.append("Option").append("\n");
        for (Map.Entry entry : this.myOptions.entrySet()) {
            sb.append(" * ").append(entry.getKey()).append(" - ").append((String)entry.getValue()).append("\n");
        }
        sb.append("ArtifactName - ").append(this.getArtifactName()).append("\n");
        sb.append("ClasspathElements - ").append("\n");
        for (SimpleClasspathElement simpleClasspathElement : this.getClasspathElements()) {
            sb.append(" * ").append(simpleClasspathElement.getPresentableName()).append("\n");
        }
    }

    @Nullable
    public static SqlLanguageDialect getLanguage(@Nullable DatabaseDriver driver) {
        if (driver == null || driver.getDialect() == null) {
            return null;
        }
        return (SqlLanguageDialect)ObjectUtils.tryCast((Object)Language.findLanguageByID((String)driver.getDialect()), SqlLanguageDialect.class);
    }
}

