/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NotNull;

public enum TableType {
    TABLE("table"),
    VIEW("view"),
    SEQUENCE("sequence"),
    SYNONYM("synonym"),
    INDEX("index"),
    TYPE("type"),
    SYSTEM_TABLE("system table"),
    SYSTEM_VIEW("system view"),
    SYSTEM_INDEX("system index"),
    LOCAL_TEMPORARY("local temporary table"),
    GLOBAL_TEMPORARY("global temporary table"),
    ALIAS("table alias");

    final String myTitle;

    private TableType(String title) {
        this.myTitle = title;
    }

    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public static TableType findByName(String name) {
        if ("BASE TABLE".equals(name)) {
            TableType tableType = TABLE;
            if (tableType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/TableType", "findByName"));
            }
            return tableType;
        }
        for (TableType type : TableType.values()) {
            if (!Comparing.equal((String)type.getTitle(), (String)name, (boolean)false)) continue;
            TableType tableType = type;
            if (tableType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/TableType", "findByName"));
            }
            return tableType;
        }
        TableType tableType = TABLE;
        if (tableType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/TableType", "findByName"));
        }
        return tableType;
    }

    @NotNull
    public ObjectKind getKind() {
        switch (this) {
            case TABLE: {
                ObjectKind objectKind = ObjectKind.TABLE;
                if (objectKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/TableType", "getKind"));
                }
                return objectKind;
            }
            case VIEW: {
                ObjectKind objectKind = ObjectKind.VIEW;
                if (objectKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/TableType", "getKind"));
                }
                return objectKind;
            }
            case SEQUENCE: {
                ObjectKind objectKind = ObjectKind.SEQUENCE;
                if (objectKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/TableType", "getKind"));
                }
                return objectKind;
            }
            case SYNONYM: {
                ObjectKind objectKind = ObjectKind.SYNONYM;
                if (objectKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/TableType", "getKind"));
                }
                return objectKind;
            }
            case INDEX: {
                ObjectKind objectKind = ObjectKind.INDEX;
                if (objectKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/TableType", "getKind"));
                }
                return objectKind;
            }
            case TYPE: {
                ObjectKind objectKind = ObjectKind.OBJECT_TYPE;
                if (objectKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/TableType", "getKind"));
                }
                return objectKind;
            }
            case SYSTEM_TABLE: {
                ObjectKind objectKind = ObjectKind.TABLE;
                if (objectKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/TableType", "getKind"));
                }
                return objectKind;
            }
            case SYSTEM_VIEW: {
                ObjectKind objectKind = ObjectKind.VIEW;
                if (objectKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/TableType", "getKind"));
                }
                return objectKind;
            }
            case SYSTEM_INDEX: {
                ObjectKind objectKind = ObjectKind.INDEX;
                if (objectKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/TableType", "getKind"));
                }
                return objectKind;
            }
            case LOCAL_TEMPORARY: {
                ObjectKind objectKind = ObjectKind.TABLE;
                if (objectKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/TableType", "getKind"));
                }
                return objectKind;
            }
            case GLOBAL_TEMPORARY: {
                ObjectKind objectKind = ObjectKind.TABLE;
                if (objectKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/TableType", "getKind"));
                }
                return objectKind;
            }
            case ALIAS: {
                ObjectKind objectKind = ObjectKind.SYNONYM;
                if (objectKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/TableType", "getKind"));
                }
                return objectKind;
            }
        }
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/TableType", "getKind"));
        }
        return objectKind;
    }
}

